/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.AbstractSegmentStoreDensityView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.AbstractSegmentStoreDensityViewer;
import org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.density2.BaseMouseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.AxisRange;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;

public class MouseSelectionProvider
extends BaseMouseProvider
implements MouseListener,
MouseMoveListener,
ICustomPaintListener {
    private double fStartCoordinate;
    private double fEndCoordinate;
    private boolean fIsUpdate;
    private boolean fDragBeginMarker;

    public MouseSelectionProvider(AbstractSegmentStoreDensityViewer densityViewer) {
        super(densityViewer);
    }

    public void mouseDoubleClick(@Nullable MouseEvent e) {
    }

    public void mouseDown(@Nullable MouseEvent e) {
        if (e != null && e.button == 1) {
            this.fDragBeginMarker = false;
            if ((e.stateMask & 0x20000) != 131072 || this.fEndCoordinate == this.fStartCoordinate) {
                IAxis xAxis = this.getXAxis();
                this.fEndCoordinate = this.fStartCoordinate = xAxis.getDataCoordinate(e.x);
            } else {
                double selectionBegin = this.fStartCoordinate;
                double selectionEnd = this.fEndCoordinate;
                IAxis xAxis = this.getXAxis();
                double time = xAxis.getDataCoordinate(e.x);
                if (Math.abs(time - selectionBegin) < Math.abs(time - selectionEnd)) {
                    this.fDragBeginMarker = true;
                    this.fStartCoordinate = time;
                    this.fEndCoordinate = selectionEnd;
                } else {
                    this.fStartCoordinate = selectionBegin;
                    this.fEndCoordinate = time;
                }
            }
            this.fIsUpdate = true;
        }
    }

    public void mouseUp(@Nullable MouseEvent e) {
        if (this.fIsUpdate) {
            if (this.fStartCoordinate > this.fEndCoordinate) {
                double tmp = this.fStartCoordinate;
                this.fStartCoordinate = this.fEndCoordinate;
                this.fEndCoordinate = tmp;
            }
            if (!this.isEmptySelection()) {
                this.getDensityViewer().select(new AxisRange(((Double)AbstractSegmentStoreDensityView.DEFAULT_RANGE.getFirst()).doubleValue(), ((Double)AbstractSegmentStoreDensityView.DEFAULT_RANGE.getSecond()).doubleValue()));
            } else {
                this.getDensityViewer().select(new AxisRange(this.fStartCoordinate, this.fEndCoordinate));
            }
            this.fIsUpdate = false;
            this.redraw();
        }
    }

    public void mouseMove(@Nullable MouseEvent e) {
        if (e != null && this.fIsUpdate) {
            IAxis xAxis = this.getXAxis();
            if (this.fDragBeginMarker) {
                this.fStartCoordinate = xAxis.getDataCoordinate(e.x);
            } else {
                this.fEndCoordinate = xAxis.getDataCoordinate(e.x);
            }
            this.redraw();
        }
    }

    private boolean isEmptySelection() {
        IAxis xAxis = this.getXAxis();
        int begin = xAxis.getPixelCoordinate(this.fStartCoordinate);
        int end = xAxis.getPixelCoordinate(this.fEndCoordinate);
        return Math.abs(end - begin) > 2;
    }

    public void paintControl(@Nullable PaintEvent e) {
        if (e == null || !this.isEmptySelection()) {
            return;
        }
        Display display = this.getControl().getDisplay();
        IAxis xAxis = this.getXAxis();
        e.gc.setBackground(display.getSystemColor(9));
        e.gc.setForeground(display.getSystemColor(9));
        e.gc.setLineStyle(1);
        int begin = xAxis.getPixelCoordinate(this.fStartCoordinate);
        e.gc.drawLine(begin, 0, begin, e.height);
        int end = xAxis.getPixelCoordinate(this.fEndCoordinate);
        e.gc.drawLine(end, 0, end, e.height);
        e.gc.setAlpha(64);
        if (Math.abs(this.fEndCoordinate - this.fStartCoordinate) > 1.0) {
            e.gc.setBackground(display.getSystemColor(22));
            int beginX = xAxis.getPixelCoordinate(this.fStartCoordinate);
            int endX = xAxis.getPixelCoordinate(this.fEndCoordinate);
            if (this.fEndCoordinate > this.fStartCoordinate) {
                e.gc.fillRectangle(beginX + 1, 0, endX - beginX - 1, e.height);
            } else {
                e.gc.fillRectangle(endX + 1, 0, beginX - endX - 1, e.height);
            }
        }
    }

    public boolean drawBehindSeries() {
        return false;
    }
}

