/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.event;

import java.security.Permission;
import java.util.Set;
import org.eclipse.equinox.internal.event.EventAdminMsg;
import org.eclipse.equinox.internal.event.EventHandlerTracker;
import org.eclipse.equinox.internal.event.EventHandlerWrapper;
import org.eclipse.equinox.internal.event.LogTracker;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.TopicPermission;

public class EventAdminImpl
implements EventAdmin {
    private final LogTracker log;
    private final EventHandlerTracker handlers;
    private volatile EventManager eventManager;

    EventAdminImpl(BundleContext context) {
        this.log = new LogTracker(context, System.out);
        this.handlers = new EventHandlerTracker(context, this.log);
    }

    void start() {
        this.log.open();
        ThreadGroup eventGroup = new ThreadGroup("Equinox Event Admin");
        this.eventManager = new EventManager(EventAdminMsg.EVENT_ASYNC_THREAD_NAME, eventGroup);
        this.handlers.open();
    }

    void stop() {
        this.handlers.close();
        this.eventManager.close();
        this.eventManager = null;
        this.log.close();
    }

    public void postEvent(Event event) {
        this.dispatchEvent(event, true);
    }

    public void sendEvent(Event event) {
        this.dispatchEvent(event, false);
    }

    private void dispatchEvent(Event event, boolean isAsync) {
        EventManager currentManager = this.eventManager;
        if (currentManager == null) {
            return;
        }
        if (event == null) {
            this.log.error(EventAdminMsg.EVENT_NULL_EVENT);
            throw new NullPointerException(EventAdminMsg.EVENT_NULL_EVENT);
        }
        String topic = event.getTopic();
        try {
            this.checkTopicPermissionPublish(topic);
        }
        catch (SecurityException e) {
            String msg = NLS.bind((String)EventAdminMsg.EVENT_NO_TOPICPERMISSION_PUBLISH, (Object)event.getTopic());
            this.log.error(msg);
            throw e;
        }
        Set<EventHandlerWrapper> eventHandlers = this.handlers.getHandlers(topic);
        if (eventHandlers.isEmpty()) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        TopicPermission perm = sm == null ? null : new TopicPermission(topic, "subscribe");
        CopyOnWriteIdentityMap listeners = new CopyOnWriteIdentityMap();
        for (EventHandlerWrapper wrapper : eventHandlers) {
            listeners.put(wrapper, perm);
        }
        ListenerQueue listenerQueue = new ListenerQueue(currentManager);
        listenerQueue.queueListeners(listeners.entrySet(), (EventDispatcher)this.handlers);
        if (isAsync) {
            listenerQueue.dispatchEventAsynchronous(0, (Object)event);
        } else {
            listenerQueue.dispatchEventSynchronous(0, (Object)event);
        }
    }

    private void checkTopicPermissionPublish(String topic) throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission((Permission)new TopicPermission(topic, "publish"));
    }
}

