/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.results.IntResult;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarToggleButton;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotTimeGraph;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public abstract class TimeGraphViewUiContextTestBase {
    private static final String FLIPPING_ENDIANNESS = "flipping-endianness";
    private static final String BUG446190 = "bug446190";
    protected static final String KERNEL_TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    protected static final String KERNEL_PERSPECTIVE_ID = "org.eclipse.linuxtools.lttng2.kernel.ui.perspective";
    protected static final String TRACE_PROJECT_NAME = "test";
    private static final String HIDE_EMPTY_ROWS = "Hide Empty Rows";
    protected static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void beforeClass() throws IOException {
        SWTBotUtils.initialize();
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fBot = new SWTWorkbenchBot();
        SWTBotUtils.closeView((String)"welcome", (SWTWorkbenchBot)fBot);
        SWTBotUtils.switchToPerspective((String)KERNEL_PERSPECTIVE_ID);
        SWTBotUtils.createProject((String)TRACE_PROJECT_NAME);
        WaitUtils.waitForJobs();
    }

    @AfterClass
    public static void afterClass() {
        SWTBotUtils.deleteProject((String)TRACE_PROJECT_NAME, (SWTWorkbenchBot)fBot);
    }

    @Before
    public void before() throws IOException {
        SWTBotUtils.openView((String)this.getViewId());
        String tracePath1 = FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL())).getAbsolutePath();
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)tracePath1, (String)KERNEL_TRACE_TYPE);
        String tracePath2 = FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.FLIPPING_ENDIANNESS.getTraceURL())).getAbsolutePath();
        SWTBotUtils.openTrace((String)TRACE_PROJECT_NAME, (String)tracePath2, (String)KERNEL_TRACE_TYPE);
    }

    @After
    public void after() {
        fBot.closeAllEditors();
        SWTBotUtils.closeSecondaryShells((SWTWorkbenchBot)fBot);
    }

    private SWTBotView getViewBot() {
        return fBot.viewByTitle(this.getViewTitle());
    }

    protected abstract String getViewId();

    protected abstract String getViewTitle();

    protected abstract String[] getItemLabel();

    @Test
    public void testExpandedState() {
        SWTBotTimeGraph timegraphBot = new SWTBotTimeGraph(this.getViewBot().bot());
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)BUG446190);
        SWTBotUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)BUG446190, (String)"Failed to activate editor bug446190");
        timegraphBot.expandAll();
        int count1 = timegraphBot.getExpandedElementCount();
        String[] stringArray = this.getItemLabel();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            timegraphBot.expandEntry(false, new String[]{BUG446190, label});
            ++n2;
        }
        int count2 = timegraphBot.getExpandedElementCount();
        Assert.assertTrue((String)("Expanded entries count sould be less than " + count1 + " but actual value is " + count2), (count2 < count1 ? 1 : 0) != 0);
        int count3 = TimeGraphViewUiContextTestBase.switchBetweenTraces(timegraphBot);
        Assert.assertEquals((String)("Expanded entries count is " + count3 + " but it should be " + count2), (long)count2, (long)count3);
        timegraphBot.collapseAll();
        int count4 = TimeGraphViewUiContextTestBase.switchBetweenTraces(timegraphBot);
        Assert.assertTrue((String)("Expanded entries count soswitchBetweenTraces(timegraphBot);uld be less than " + count3 + " but actual value is " + count4), (count4 < count3 ? 1 : 0) != 0);
        int count5 = TimeGraphViewUiContextTestBase.switchBetweenTraces(timegraphBot);
        Assert.assertEquals((String)("Expanded entries count is " + count5 + " but it should be " + count4), (long)count4, (long)count5);
    }

    @Test
    public void testHideEmptyRowsState() {
        SWTBotTimeGraph timegraphBot = new SWTBotTimeGraph(this.getViewBot().bot());
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)BUG446190);
        SWTBotUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)BUG446190, (String)"Failed to activate editor bug446190");
        timegraphBot.expandAll();
        int count = TimeGraphViewUiContextTestBase.getVisibleItems(timegraphBot);
        SWTBotToolbarToggleButton button = this.getViewBot().toolbarToggleButton(HIDE_EMPTY_ROWS);
        button.click();
        Assert.assertTrue((boolean)button.isChecked());
        SWTBotUtils.waitUntil(graph -> TimeGraphViewUiContextTestBase.getVisibleItems(graph) < count, (Object)timegraphBot, () -> "More number of visible entries expected: (count: " + count + ", actual: " + TimeGraphViewUiContextTestBase.getVisibleItems(timegraphBot) + ")");
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)FLIPPING_ENDIANNESS);
        SWTBotUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)FLIPPING_ENDIANNESS, (String)"Failed to activate editor flipping-endianness");
        button = this.getViewBot().toolbarToggleButton(HIDE_EMPTY_ROWS);
        Assert.assertFalse((boolean)button.isChecked());
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)BUG446190);
        SWTBotUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)BUG446190, (String)"Failed to activate editor flipping-endianness");
        button = this.getViewBot().toolbarToggleButton(HIDE_EMPTY_ROWS);
        Assert.assertTrue((boolean)button.isChecked());
        SWTBotUtils.waitUntil(graph -> TimeGraphViewUiContextTestBase.getVisibleItems(graph) < count, (Object)timegraphBot, () -> "More number of visible entries expected: (count: " + count + ", actual: " + TimeGraphViewUiContextTestBase.getVisibleItems(timegraphBot) + ")");
        button = this.getViewBot().toolbarToggleButton(HIDE_EMPTY_ROWS);
        button.click();
        Assert.assertFalse((boolean)button.isChecked());
        SWTBotUtils.waitUntil(graph -> TimeGraphViewUiContextTestBase.getVisibleItems(graph) == count, (Object)timegraphBot, () -> "More number of visible entries expected: (count: " + count + ", actual: " + TimeGraphViewUiContextTestBase.getVisibleItems(timegraphBot) + ")");
    }

    private static int switchBetweenTraces(SWTBotTimeGraph timegraphBot) {
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)FLIPPING_ENDIANNESS);
        SWTBotUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)FLIPPING_ENDIANNESS, (String)"Failed to activate editor flipping-endianness");
        SWTBotUtils.activateEditor((SWTWorkbenchBot)fBot, (String)BUG446190);
        SWTBotUtils.waitUntil(root -> timegraphBot.getEntries()[0].getText().equals(root), (Object)BUG446190, (String)"Failed to activate editor bug446190");
        return timegraphBot.getExpandedElementCount();
    }

    private static int getVisibleItems(final SWTBotTimeGraph timegraph) {
        return (Integer)UIThreadRunnable.syncExec((Display)Display.getDefault(), (Result)new IntResult(){

            public Integer run() {
                ITimeGraphEntry[] expandedElements;
                int count = 0;
                TimeGraphControl control = (TimeGraphControl)timegraph.widget;
                ITimeGraphEntry[] iTimeGraphEntryArray = expandedElements = control.getExpandedElements();
                int n = expandedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
                    Rectangle itemBounds = control.getItemBounds(entry);
                    if (itemBounds.height > 0) {
                        ++count;
                    }
                    ++n2;
                }
                return count;
            }
        });
    }
}

