/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.IGetEventInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.UstProviderComponent;
import org.eclipse.ui.IWorkbenchPage;

public class AssignEventHandler
extends BaseControlViewHandler {
    private Parameter fParam;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Parameter tmpParam = null;
        this.fLock.lock();
        try {
            tmpParam = this.fParam;
            if (tmpParam == null) {
                return null;
            }
            tmpParam = new Parameter(tmpParam);
        }
        finally {
            this.fLock.unlock();
        }
        final Parameter param = tmpParam;
        final IGetEventInfoDialog dialog = TraceControlDialogFactory.getInstance().getGetEventInfoDialog();
        dialog.setDomain(param.getDomain());
        dialog.setSessions(param.getSessions());
        if (dialog.open() != 0) {
            return null;
        }
        Job job = new Job(Messages.TraceControl_EnableEventsJob){

            protected IStatus run(IProgressMonitor monitor) {
                ExecutionException error = null;
                TraceSessionComponent session = dialog.getSession();
                try {
                    ArrayList<String> eventNames = new ArrayList<String>();
                    List<BaseEventComponent> events = param.getEvents();
                    TraceEventType eventType = !events.isEmpty() ? events.get(0).getEventType() : null;
                    for (BaseEventComponent baseEvent : events) {
                        eventNames.add(baseEvent.getName());
                    }
                    TraceChannelComponent channel = dialog.getChannel();
                    if (TraceEventType.TRACEPOINT.equals((Object)eventType)) {
                        if (channel == null) {
                            session.enableEvents(eventNames, param.getDomain(), dialog.getFilterExpression(), null, monitor);
                        } else {
                            channel.enableEvents(eventNames, dialog.getFilterExpression(), null, monitor);
                        }
                    } else if (TraceEventType.SYSCALL.equals((Object)eventType)) {
                        if (channel == null) {
                            session.enableSyscalls(eventNames, monitor);
                        } else {
                            channel.enableSyscalls(eventNames, monitor);
                        }
                    }
                }
                catch (ExecutionException e) {
                    error = e;
                }
                if (session != null) {
                    AssignEventHandler.this.refresh(new CommandParameter(session));
                }
                if (error != null) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_EnableEventsFailure, (Throwable)error);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        boolean isEnabled;
        @NonNull ArrayList<@NonNull BaseEventComponent> events = new ArrayList<BaseEventComponent>();
        @NonNull TraceSessionComponent[] sessions = null;
        TraceDomainType domain = null;
        TraceEventType eventType = null;
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                if (!(element instanceof BaseEventComponent)) continue;
                BaseEventComponent event = (BaseEventComponent)element;
                ITraceControlComponent provider = event.getParent();
                TraceDomainType temp = null;
                if (provider instanceof KernelProviderComponent) {
                    temp = TraceDomainType.KERNEL;
                } else if (provider instanceof UstProviderComponent) {
                    temp = TraceDomainType.UST;
                } else {
                    return false;
                }
                if (domain == null) {
                    domain = temp;
                } else if (!domain.equals((Object)temp)) {
                    return false;
                }
                if (eventType == null) {
                    eventType = event.getEventType();
                } else if (!eventType.equals((Object)event.getEventType())) {
                    events.clear();
                    break;
                }
                events.add(event);
                if (sessions != null) continue;
                TargetNodeComponent root = (TargetNodeComponent)event.getParent().getParent().getParent();
                sessions = root.getSessions();
            }
        }
        boolean bl = isEnabled = !events.isEmpty() && sessions != null && sessions.length > 0;
        if (domain == null) {
            return false;
        }
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new Parameter((TraceSessionComponent[])NonNullUtils.checkNotNull(sessions), events, domain);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    @NonNullByDefault
    private static final class Parameter {
        private final List<BaseEventComponent> fEvents;
        private final @NonNull TraceSessionComponent[] fSessions;
        private final TraceDomainType fDomain;

        public Parameter(@NonNull TraceSessionComponent[] sessions, List<BaseEventComponent> events, TraceDomainType domain) {
            this.fSessions = (TraceSessionComponent[])NonNullUtils.checkNotNull((Object)Arrays.copyOf(sessions, sessions.length));
            this.fEvents = new ArrayList<BaseEventComponent>();
            this.fEvents.addAll(events);
            this.fDomain = domain;
        }

        public Parameter(Parameter other) {
            this(other.fSessions, other.fEvents, other.fDomain);
        }

        public TraceSessionComponent[] getSessions() {
            return this.fSessions;
        }

        public List<BaseEventComponent> getEvents() {
            return this.fEvents;
        }

        public TraceDomainType getDomain() {
            return this.fDomain;
        }
    }
}

