/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.relayd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.ILttngRelaydConnector;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.AttachSessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.Command;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ConnectResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.CreateSessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.CreateSessionReturnCode;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.GetNextIndex;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IndexResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.NextIndexReturnCode;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.SessionResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.StreamResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.ViewerCommand;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.impl.LttngRelaydConnectorFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class LttngRelayd24TestApplication {
    private static final int PACKETS_TO_READ = 100;
    private static final String ADDRESS = "127.0.0.1";
    private static final int PORT = 5344;

    private static void getPackets(AttachSessionResponse attachedSession, Socket connection, ILttngRelaydConnector relayD) throws IOException {
        int numPacketsReceived = 0;
        DataOutputStream fOutNet = new DataOutputStream(connection.getOutputStream());
        DataInputStream fInNet = new DataInputStream(connection.getInputStream());
        while (numPacketsReceived < 100) {
            for (StreamResponse stream : attachedSession.getStreamList()) {
                if (stream.getMetadataFlag() == 1) continue;
                ConnectResponse connectPayload = new ConnectResponse(fInNet);
                Assert.assertNotNull((Object)connectPayload);
                ViewerCommand connectCommand = new ViewerCommand(Command.VIEWER_GET_NEXT_INDEX, 20L, 0);
                fOutNet.write(connectCommand.serialize());
                fOutNet.flush();
                GetNextIndex indexRequest = new GetNextIndex(stream.getId());
                fOutNet.write(indexRequest.serialize());
                fOutNet.flush();
                IndexResponse indexReply = new IndexResponse(fInNet);
                if (indexReply.getStatus() != NextIndexReturnCode.VIEWER_INDEX_OK || relayD.getPacketFromStream(indexReply, stream.getId()) == null) continue;
                ++numPacketsReceived;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    @Ignore
    public void testViewerConnection() throws IOException {
        InetAddress addr = InetAddress.getByName(ADDRESS);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Socket connection = new Socket(addr, 5344);
            try {
                try (ILttngRelaydConnector relayD = LttngRelaydConnectorFactory.getNewConnector((Socket)connection);){
                    List sessions = relayD.getSessions();
                    Assert.assertTrue((sessions.size() > 0 ? 1 : 0) != 0);
                    SessionResponse lttngViewerSession = (SessionResponse)sessions.get(0);
                    Assert.assertNotNull((Object)lttngViewerSession);
                    CreateSessionResponse createSession = relayD.createSession();
                    Assert.assertEquals((Object)createSession.getStatus(), (Object)CreateSessionReturnCode.LTTNG_VIEWER_CREATE_SESSION_OK);
                    AttachSessionResponse attachedSession = relayD.attachToSession(lttngViewerSession);
                    String metaData = relayD.getMetadata(attachedSession);
                    Assert.assertNotNull((Object)metaData);
                    LttngRelayd24TestApplication.getPackets(attachedSession, connection, relayD);
                }
                if (connection == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            connection.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

