/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.views.contentmodel;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMVisitor;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class CMListWorkbenchAdapter
extends CMVisitor
implements IWorkbenchAdapter {
    private CMElementDeclaration fDeclaration;
    private String text;
    private ImageDescriptor image;
    private GroupStack fGroupStack;
    private CMDescriber fRoot;
    private static final Object[] EMPTY = new Object[0];

    public CMListWorkbenchAdapter(CMElementDeclaration decl) {
        if (decl != null) {
            this.text = CMListWorkbenchAdapter.getFormattedLabel(decl.getNodeName(), decl.getMinOccur(), decl.getMaxOccur(), decl.getDataType());
            this.fDeclaration = decl;
            this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.ui", (String)"icons/full/obj16/element_obj.gif");
            this.fGroupStack = new GroupStack();
            this.fRoot = new CMDescriber((CMNode)decl);
        } else {
            this.text = XMLUIMessages.ContentModel_ElementNotDescribed;
            this.image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.ui", (String)"icons/full/obj16/warning_obj.gif");
        }
    }

    public Object[] getChildren(Object o) {
        return this.fRoot != null ? this.fRoot.getChildren(o) : EMPTY;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return this.image;
    }

    public String getLabel(Object o) {
        return this.text;
    }

    public Object getParent(Object o) {
        return this.fDeclaration;
    }

    static String getFormattedLabel(String name, int min, int max, CMDataType dataType) {
        StringBuffer buffer = new StringBuffer(name);
        buffer.append('[');
        buffer.append(min);
        buffer.append("..");
        buffer.append(max >= 0 ? Integer.toString(max) : "*");
        buffer.append(']');
        if (dataType != null) {
            buffer.append(" {");
            buffer.append(dataType.getDataTypeName());
            buffer.append('}');
        }
        return buffer.toString();
    }

    private class CMDescriber
    extends CMVisitor
    implements IWorkbenchAdapter {
        List fChildren = null;
        ImageDescriptor fImage;
        String label;
        CMNode root;

        public CMDescriber(CMNode node) {
            this.root = node;
        }

        public Object[] getChildren(Object o) {
            if (this.fChildren == null) {
                this.fChildren = new ArrayList();
                if (this.root.getNodeType() == 5) {
                    CMElementDeclaration ed = (CMElementDeclaration)this.root;
                    CMNamedNodeMap nodeMap = ed.getAttributes();
                    int size = nodeMap.getLength();
                    int i = 0;
                    while (i < size) {
                        this.visitCMNode(nodeMap.item(i));
                        ++i;
                    }
                    this.visitCMNode((CMNode)ed.getContent());
                }
            }
            return this.fChildren.toArray();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return this.fImage;
        }

        public void setImage(String path) {
            this.fImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.wst.xml.ui", (String)path);
        }

        public String getLabel(Object o) {
            return this.label;
        }

        public Object getParent(Object o) {
            return this.root;
        }

        public void visitCMGroup(CMGroup e) {
            CMListWorkbenchAdapter.this.fGroupStack.push(e.getMaxOccur());
            super.visitCMGroup(e);
            CMListWorkbenchAdapter.this.fGroupStack.pop();
        }

        public void visitCMAttributeDeclaration(CMAttributeDeclaration ad) {
            CMDescriber describer = new CMDescriber((CMNode)ad);
            describer.label = ad.getNodeName();
            describer.setImage("icons/full/obj16/attribute_obj.gif");
            this.fChildren.add(describer);
        }

        public void visitCMElementDeclaration(CMElementDeclaration ed) {
            CMDescriber describer = new CMDescriber((CMNode)ed);
            describer.label = CMListWorkbenchAdapter.getFormattedLabel(ed.getNodeName(), ed.getMinOccur(), !CMListWorkbenchAdapter.this.fGroupStack.isEmpty() && CMListWorkbenchAdapter.this.fGroupStack.peek() < 0 ? -1 : ed.getMaxOccur(), ed.getDataType());
            describer.setImage("icons/full/obj16/element_obj.gif");
            this.fChildren.add(describer);
        }
    }

    private static class GroupStack {
        int[] stack = new int[5];
        int size;

        public void push(int i) {
            if (this.size >= this.stack.length) {
                int[] tmp = this.stack;
                this.stack = new int[this.stack.length * 2];
                System.arraycopy(tmp, 0, this.stack, 0, tmp.length);
            }
            this.stack[this.size++] = i;
        }

        public int pop() {
            if (this.isEmpty()) {
                throw new EmptyStackException();
            }
            return this.stack[--this.size];
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public int peek() {
            if (this.isEmpty()) {
                throw new EmptyStackException();
            }
            return this.stack[this.size - 1];
        }
    }
}

