/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.actions.NodeAction;
import org.eclipse.wst.xml.ui.internal.dialogs.EditDoctypeDialog;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EditDoctypeAction
extends NodeAction {
    protected DocumentType doctype;
    protected Document document;
    protected IStructuredModel model;
    protected String resourceLocation;
    protected String title;

    public EditDoctypeAction(IStructuredModel model, Document document, String resourceLocation, String title) {
        this.setText(title);
        this.model = model;
        this.document = document;
        this.resourceLocation = resourceLocation;
        this.title = title;
    }

    public EditDoctypeAction(IStructuredModel model, DocumentType doctype, String resourceLocation, String title) {
        this.setText(title);
        this.model = model;
        this.doctype = doctype;
        this.resourceLocation = resourceLocation;
        this.title = title;
    }

    protected DocumentType createDoctype(EditDoctypeDialog dialog, Document document) {
        IDOMDocumentType result = null;
        if (document instanceof DocumentImpl) {
            IDOMDocument documentImpl = (IDOMDocument)document;
            IDOMDocumentType doctypeImpl = (IDOMDocumentType)documentImpl.createDoctype(dialog.getName());
            doctypeImpl.setPublicId(dialog.getPublicId());
            doctypeImpl.setSystemId(dialog.getSystemId());
            result = doctypeImpl;
        }
        return result;
    }

    private Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    protected String getRootElementName(Document document) {
        Node rootElement = null;
        NodeList nodeList = document.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1) {
                rootElement = (Element)childNode;
                break;
            }
            ++i;
        }
        return rootElement != null ? rootElement.getNodeName() : XMLUIMessages._UI_LABEL_ROOT_ELEMENT_VALUE;
    }

    @Override
    public String getUndoDescription() {
        return this.title;
    }

    protected void insertDoctype(DocumentType doctype, Document document) {
        Node refChild = null;
        NodeList nodeList = document.getChildNodes();
        int nodeListLength = nodeList.getLength();
        int i = 0;
        while (i < nodeListLength) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 7 && childNode.getNodeType() != 8) {
                refChild = childNode;
                break;
            }
            ++i;
        }
        document.insertBefore(doctype, refChild);
    }

    public void run() {
        Shell shell = this.getDisplay().getActiveShell();
        if (this.validateEdit(this.model, shell)) {
            this.model.beginRecording((Object)this, this.getUndoDescription());
            EditDoctypeDialog dialog = this.showEditDoctypeDialog(shell);
            if (dialog.getReturnCode() == 0) {
                DocumentType doctype;
                if (this.doctype != null) {
                    this.updateDoctype(dialog, this.doctype);
                } else if (this.document != null && (doctype = this.createDoctype(dialog, this.document)) != null) {
                    this.insertDoctype(doctype, this.document);
                }
            }
            this.model.endRecording((Object)this);
        }
    }

    protected EditDoctypeDialog showEditDoctypeDialog(Shell shell) {
        EditDoctypeDialog dialog = null;
        if (this.doctype != null) {
            dialog = new EditDoctypeDialog(shell, this.doctype);
            if (this.title == null) {
                this.title = XMLUIMessages._UI_LABEL_EDIT_DOCTYPE;
            }
        } else if (this.document != null) {
            String rootElementName = this.getRootElementName(this.document);
            dialog = new EditDoctypeDialog(shell, rootElementName, "", String.valueOf(rootElementName) + ".dtd");
            if (this.title == null) {
                this.title = XMLUIMessages._UI_MENU_ADD_DTD_INFORMATION_TITLE;
            }
        }
        dialog.setComputeSystemId(this.doctype == null || this.doctype.getSystemId() == null || this.doctype.getSystemId().trim().length() == 0);
        dialog.setErrorChecking(false);
        dialog.create();
        dialog.getShell().setText(this.title);
        dialog.setBlockOnOpen(true);
        dialog.setResourceLocation((IPath)new Path(this.resourceLocation));
        dialog.open();
        return dialog;
    }

    protected void updateDoctype(EditDoctypeDialog dialog, DocumentType doctype) {
        if (doctype instanceof IDOMDocumentType) {
            IDOMDocumentType doctypeImpl = (IDOMDocumentType)doctype;
            if (doctypeImpl.getName().equals(dialog.getName())) {
                doctypeImpl.setPublicId(dialog.getPublicId());
                doctypeImpl.setSystemId(dialog.getSystemId());
            } else {
                Document document = doctype.getOwnerDocument();
                DocumentType newDoctype = this.createDoctype(dialog, document);
                document.insertBefore(newDoctype, doctype);
                document.removeChild(doctype);
            }
        }
    }
}

