/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.nsedit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectFileOrXMLCatalogIdDialog;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonNamespaceInfoTable;

public class CommonAddNamespacesControl
extends Composite
implements SelectionListener {
    protected Button deleteButton;
    protected Button editButton;
    protected EditNamespaceControl editNamespaceControl;
    protected int heightHint = 250;
    protected List namespaceInfoList = new ArrayList();
    protected Button newButton;
    protected PageBook pageBook;
    protected Button radio1;
    protected Button radio2;
    protected IPath resourceLocation;
    protected Composite tableSection;
    protected CommonNamespaceInfoTable tableViewer;
    protected int widthHint = 500;

    public CommonAddNamespacesControl(Composite parent, int style, IPath resourceLocation) {
        super(parent, style);
        this.resourceLocation = resourceLocation;
        GridData gd = new GridData(1808);
        if (this.widthHint != -1) {
            gd.widthHint = this.widthHint;
        }
        if (this.heightHint != -1) {
            gd.heightHint = this.heightHint;
        }
        this.setLayoutData(gd);
        this.setLayout((Layout)new GridLayout());
        this.radio1 = new Button((Composite)this, 16);
        this.radio1.setText(XMLUIMessages._UI_SELECT_REGISTERED_NAMESPACES);
        this.radio1.setSelection(true);
        this.radio1.addSelectionListener((SelectionListener)this);
        this.radio2 = new Button((Composite)this, 16);
        this.radio2.setText(XMLUIMessages._UI_SPECIFY_NEW_NAMESPACE);
        this.radio2.addSelectionListener((SelectionListener)this);
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.pageBook = new PageBook((Composite)this, 0);
        this.pageBook.setLayoutData((Object)new GridData(1808));
        this.tableSection = new Composite((Composite)this.pageBook, 0);
        this.tableSection.setLayout((Layout)new GridLayout());
        Label label = new Label(this.tableSection, 0);
        label.setText(XMLUIMessages._UI_SELECT_NAMESPACE_TO_ADD);
        this.tableViewer = new CommonNamespaceInfoTable(this.tableSection, 32, 6);
        this.editNamespaceControl = new EditNamespaceControl((Composite)this.pageBook);
        this.pageBook.showPage((Control)this.tableSection);
        this.tableViewer.setInput(this.namespaceInfoList);
    }

    public List getNamespaceInfoList() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.radio1.getSelection()) {
            TableItem[] items = this.tableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                if (item.getChecked()) {
                    list.add(item.getData());
                }
                ++i;
            }
        } else {
            NamespaceInfo info = new NamespaceInfo();
            info.prefix = this.editNamespaceControl.prefixField.getText();
            info.uri = this.editNamespaceControl.uriField.getText();
            info.locationHint = this.editNamespaceControl.locationHintField.getText();
            list.add(info);
        }
        return list;
    }

    public void setNamespaceInfoList(List list) {
        this.namespaceInfoList = list;
        this.tableViewer.setInput(this.namespaceInfoList);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.radio1) {
            this.pageBook.showPage((Control)this.tableSection);
        } else if (e.widget == this.radio2) {
            this.pageBook.showPage((Control)this.editNamespaceControl);
        }
    }

    class EditNamespaceControl
    extends Composite {
        protected Button browseButton;
        Text locationHintField;
        Text prefixField;
        Text uriField;

        public EditNamespaceControl(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout());
            this.setLayoutData(new GridData(1808));
            Label label = new Label((Composite)this, 0);
            label.setText(XMLUIMessages._UI_ENTER_REQ_PREFIX_AND_NAMESPACE);
            Composite composite = new Composite((Composite)this, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.verticalSpacing = 1;
            composite.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.widthHint = 350;
            composite.setLayoutData((Object)gd);
            Label prefixLabel = new Label(composite, 0);
            prefixLabel.setText(XMLUIMessages._UI_LABEL_PREFIX_COLON);
            this.prefixField = new Text(composite, 2052);
            this.prefixField.setLayoutData((Object)new GridData(768));
            new Label(composite, 0);
            Label uriLabel = new Label(composite, 0);
            uriLabel.setText(XMLUIMessages._UI_LABEL_NAMESPACE_NAME_COLON);
            this.uriField = new Text(composite, 2052);
            this.uriField.setLayoutData((Object)new GridData(768));
            new Label(composite, 0);
            Label locationHintLabel = new Label(composite, 0);
            locationHintLabel.setText(XMLUIMessages._UI_LABEL_LOCATION_HINT_COLON);
            this.locationHintField = new Text(composite, 2052);
            this.locationHintField.setLayoutData((Object)new GridData(768));
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditNamespaceControl.this.performBrowse();
                }
            };
            this.browseButton = new Button(composite, 0);
            this.browseButton.setText(XMLUIMessages._UI_LABEL_BROWSE);
            this.browseButton.addSelectionListener((SelectionListener)selectionListener);
            this.browseButton.setEnabled(this.locationHintField.getEnabled());
        }

        protected void performBrowse() {
            String[] extensions = new String[]{".xsd"};
            SelectFileOrXMLCatalogIdDialog dialog = new SelectFileOrXMLCatalogIdDialog(this.getShell(), extensions);
            dialog.create();
            dialog.getShell().setText(XMLUIMessages._UI_LABEL_SELECT_FILE);
            dialog.setBlockOnOpen(true);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                IFile file = dialog.getFile();
                String id = dialog.getId();
                if (file != null) {
                    String uri = null;
                    if (CommonAddNamespacesControl.this.resourceLocation != null) {
                        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(CommonAddNamespacesControl.this.resourceLocation);
                        if (resource != null) {
                            IPath location = resource.getLocation();
                            if (location != null) {
                                uri = URIHelper.getRelativeURI((IPath)file.getLocation(), (IPath)location);
                            }
                        } else {
                            uri = URIHelper.getRelativeURI((IPath)file.getLocation(), (IPath)CommonAddNamespacesControl.this.resourceLocation);
                        }
                    } else {
                        uri = file.getLocation().toOSString();
                    }
                    this.locationHintField.setText(uri);
                } else if (id != null) {
                    this.locationHintField.setText(id);
                    URIResolverPlugin.createResolver();
                }
            }
        }
    }
}

