/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderCapabilities;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.DataProviderCapabilities;

public class DataProviderDescriptor
implements IDataProviderDescriptor {
    private final String fId;
    private final String fName;
    private final String fDescription;
    private final IDataProviderDescriptor.ProviderType fType;
    private final @Nullable String fParentId;
    private final @Nullable ITmfConfiguration fConfiguration;
    private final IDataProviderCapabilities fCapabilities;

    private DataProviderDescriptor(Builder builder) {
        this.fId = builder.fId;
        this.fName = builder.fName;
        this.fDescription = builder.fDescription;
        this.fType = Objects.requireNonNull(builder.fType);
        this.fParentId = builder.fParentId;
        this.fConfiguration = builder.fConfiguration;
        this.fCapabilities = builder.fCapabilities;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public IDataProviderDescriptor.ProviderType getType() {
        return this.fType;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public IDataProviderCapabilities getCapabilities() {
        return this.fCapabilities;
    }

    @Override
    public @Nullable String getParentId() {
        return this.fParentId;
    }

    @Override
    public @Nullable ITmfConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [fName=" + this.getName() + ", fDescription=" + this.getDescription() + ", fType=" + String.valueOf((Object)this.getType()) + ", fId=" + this.getId() + ", fParentId=" + this.fParentId + ", fConfiguration=" + String.valueOf(this.fConfiguration) + ", fCapabilities=" + String.valueOf(this.fCapabilities) + "]";
    }

    public boolean equals(@Nullable Object arg0) {
        if (!(arg0 instanceof DataProviderDescriptor)) {
            return false;
        }
        DataProviderDescriptor other = (DataProviderDescriptor)arg0;
        return Objects.equals(this.fName, other.fName) && Objects.equals(this.fId, other.fId) && Objects.equals((Object)this.fType, (Object)other.fType) && Objects.equals(this.fDescription, other.fDescription) && Objects.equals(this.fParentId, other.fParentId) && Objects.equals(this.fConfiguration, other.fConfiguration) && Objects.equals(this.fCapabilities, other.fCapabilities);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fParentId, this.fName, this.fId, this.fType, this.fDescription, this.fConfiguration, this.fCapabilities});
    }

    public static class Builder {
        private String fId = "";
        private String fName = "";
        private String fDescription = "";
        private @Nullable IDataProviderDescriptor.ProviderType fType = null;
        private @Nullable String fParentId = null;
        private @Nullable ITmfConfiguration fConfiguration = null;
        private IDataProviderCapabilities fCapabilities = DataProviderCapabilities.NULL_INSTANCE;

        public Builder setId(String id) {
            this.fId = id;
            return this;
        }

        public Builder setName(String name) {
            this.fName = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.fDescription = description;
            return this;
        }

        public Builder setProviderType(IDataProviderDescriptor.ProviderType type) {
            this.fType = type;
            return this;
        }

        public Builder setParentId(@Nullable String parentId) {
            this.fParentId = parentId;
            return this;
        }

        public Builder setConfiguration(@Nullable ITmfConfiguration configuration) {
            this.fConfiguration = configuration;
            return this;
        }

        public Builder setCapabilities(IDataProviderCapabilities capabilities) {
            this.fCapabilities = capabilities;
            return this;
        }

        public IDataProviderDescriptor build() {
            if (this.fType == null) {
                throw new IllegalStateException("Data provider type not set");
            }
            if (this.fId.isEmpty()) {
                throw new IllegalStateException("Empty data provider ID");
            }
            return new DataProviderDescriptor(this);
        }
    }
}

