/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateSystemPathCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenStateSystemPath;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenOutputEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.output.DataDrivenXYDataProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public class TmfXmlOutputEntryCu
implements IDataDrivenCompilationUnit {
    private final List<TmfXmlOutputEntryCu> fChildrenEntries;
    private final String fPath;
    private final @Nullable String fAnalysisId;
    private final boolean fDisplayText;
    private final @Nullable TmfXmlStateSystemPathCu fDisplayCu;
    private final @Nullable TmfXmlStateSystemPathCu fIdCu;
    private final @Nullable TmfXmlStateSystemPathCu fParentCu;
    private final @Nullable TmfXmlStateSystemPathCu fNameCu;
    private final DataDrivenXYDataProvider.DisplayType fDisplayType;

    private TmfXmlOutputEntryCu(List<TmfXmlOutputEntryCu> childrenCu, String path, @Nullable String analysisId, boolean displayText, @Nullable TmfXmlStateSystemPathCu displayCu, @Nullable TmfXmlStateSystemPathCu idCu, @Nullable TmfXmlStateSystemPathCu parentCu, @Nullable TmfXmlStateSystemPathCu nameCu, DataDrivenXYDataProvider.DisplayType displayType) {
        this.fChildrenEntries = childrenCu;
        this.fPath = path;
        this.fAnalysisId = analysisId;
        this.fDisplayText = displayText;
        this.fDisplayCu = displayCu;
        this.fIdCu = idCu;
        this.fParentCu = parentCu;
        this.fNameCu = nameCu;
        this.fDisplayType = displayType;
    }

    @Override
    public DataDrivenOutputEntry generate() {
        List<DataDrivenOutputEntry> entries = this.fChildrenEntries.stream().map(TmfXmlOutputEntryCu::generate).collect(Collectors.toList());
        DataDrivenStateSystemPath display = this.fDisplayCu != null ? this.fDisplayCu.generate() : null;
        DataDrivenStateSystemPath id = this.fIdCu != null ? this.fIdCu.generate() : null;
        DataDrivenStateSystemPath parent = this.fParentCu != null ? this.fParentCu.generate() : null;
        DataDrivenStateSystemPath name = this.fNameCu != null ? this.fNameCu.generate() : null;
        return new DataDrivenOutputEntry(entries, this.fPath, this.fAnalysisId, this.fDisplayText, display, id, parent, name, this.fDisplayType);
    }

    public static @Nullable TmfXmlOutputEntryCu compile(AnalysisCompilationData compilationData, Element entryEl) {
        String analysisId;
        String path = entryEl.getAttribute("path");
        if (path.isEmpty()) {
            path = "*";
        }
        List<Element> displayElements = TmfXmlUtils.getChildElements(entryEl, "display");
        List<Element> entryElements = TmfXmlUtils.getChildElements(entryEl, "entry");
        if (displayElements.isEmpty() && entryElements.isEmpty()) {
            Activator.logWarning(String.format("XML view: entry for %s should have either a display element or entry elements", path));
            return null;
        }
        ArrayList<TmfXmlOutputEntryCu> childrenCu = new ArrayList<TmfXmlOutputEntryCu>();
        for (Element childEl : entryElements) {
            TmfXmlOutputEntryCu childCu = TmfXmlOutputEntryCu.compile(compilationData, childEl);
            if (childCu == null) continue;
            childrenCu.add(childCu);
        }
        TmfXmlStateSystemPathCu displayCu = null;
        if (!displayElements.isEmpty()) {
            if (displayElements.size() > 1) {
                Activator.logWarning(String.format("XML view: entry for %s should have at most one 'display' element", path));
            }
            displayCu = TmfXmlStateSystemPathCu.compile(compilationData, Collections.singletonList(displayElements.get(0)));
        }
        TmfXmlStateSystemPathCu idCu = null;
        List<Element> elements = TmfXmlUtils.getChildElements(entryEl, "id");
        if (!elements.isEmpty()) {
            if (elements.size() > 1) {
                Activator.logWarning(String.format("XML view: entry for %s should have at most one 'id' element", path));
            }
            idCu = TmfXmlStateSystemPathCu.compile(compilationData, Collections.singletonList(elements.get(0)));
        }
        TmfXmlStateSystemPathCu parentCu = null;
        elements = TmfXmlUtils.getChildElements(entryEl, "parent");
        if (!elements.isEmpty()) {
            if (elements.size() > 1) {
                Activator.logWarning(String.format("XML view: entry for %s should have at most one 'parent' element", path));
            }
            parentCu = TmfXmlStateSystemPathCu.compile(compilationData, Collections.singletonList(elements.get(0)));
        }
        TmfXmlStateSystemPathCu nameCu = null;
        elements = TmfXmlUtils.getChildElements(entryEl, "name");
        if (!elements.isEmpty()) {
            if (elements.size() > 1) {
                Activator.logWarning(String.format("XML view: entry for %s should have at most one 'name' element", path));
            }
            nameCu = TmfXmlStateSystemPathCu.compile(compilationData, Collections.singletonList(elements.get(0)));
        }
        if ((analysisId = entryEl.getAttribute("analysisId")).isEmpty()) {
            analysisId = null;
        }
        boolean displayText = Boolean.parseBoolean(entryEl.getAttribute("displayText"));
        String displayTypeStr = entryEl.getAttribute("displayType");
        DataDrivenXYDataProvider.DisplayType displayType = DataDrivenXYDataProvider.DisplayType.ABSOLUTE;
        if (displayTypeStr.equalsIgnoreCase("delta")) {
            displayType = DataDrivenXYDataProvider.DisplayType.DELTA;
        }
        return new TmfXmlOutputEntryCu(childrenCu, path, analysisId, displayText, displayCu, idCu, parentCu, nameCu, displayType);
    }
}

