/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.hudson.maven.core.analysis;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.hudson.maven.core.trace.MavenEvent;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class MavenCallstackStateProvider
extends CallStackStateProvider {
    private static final double NANOS_IN_SEC = 1.0E9;
    private static final int GROUP_DEPTH = 2;
    private static final int FINAL_DEPTH = 3;
    private static final int VERSION = 2;
    long fSafeTime = 0L;
    private long fNextClose = Long.MAX_VALUE;
    private int fDepth = 0;

    public MavenCallstackStateProvider(@NonNull ITmfTrace trace) {
        super(trace);
    }

    public int getVersion() {
        return 2;
    }

    public CallStackStateProvider getNewInstance() {
        return new MavenCallstackStateProvider(this.getTrace());
    }

    protected boolean considerEvent(ITmfEvent event) {
        return event instanceof MavenEvent;
    }

    protected @Nullable ITmfStateValue functionEntry(ITmfEvent event) {
        return null;
    }

    protected @Nullable ITmfStateValue functionExit(ITmfEvent event) {
        return null;
    }

    protected int getProcessId(ITmfEvent event) {
        return 0;
    }

    protected long getThreadId(ITmfEvent event) {
        return 0L;
    }

    protected @Nullable String getProcessName(ITmfEvent event) {
        return "CI";
    }

    protected @Nullable String getThreadName(ITmfEvent event) {
        return "Maven Job";
    }

    protected void eventHandle(ITmfEvent event) {
        boolean isFirst;
        ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
        if (ssb == null) {
            return;
        }
        int processQuark = ssb.optQuarkAbsolute(new String[]{"Processes", this.getProcessName(event)});
        boolean bl = isFirst = processQuark == -2;
        if (isFirst) {
            processQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", this.getProcessName(event)});
        }
        int threadQuark = ssb.getQuarkRelativeAndAdd(processQuark, new String[]{this.getThreadName(event)});
        int callStackQuark = ssb.getQuarkRelativeAndAdd(threadQuark, new String[]{"CallStack"});
        String groupAspect = (String)MavenEvent.GROUP_ASPECT.resolve(event);
        if (event.getType().equals(MavenEvent.GOAL_TYPE)) {
            this.fSafeTime = Math.max(this.fSafeTime + 1L, event.getTimestamp().toNanos());
            if (this.fDepth == 3) {
                ssb.popAttribute(Math.min(this.fNextClose, this.fSafeTime), callStackQuark);
                --this.fDepth;
            }
            while (this.fDepth > 2) {
                --this.fDepth;
                ssb.popAttribute(this.fSafeTime, callStackQuark);
            }
            if (!isFirst) {
                ssb.popAttribute(this.fSafeTime - 1L, callStackQuark);
            } else {
                ssb.modifyAttribute(this.fSafeTime - 1L, (Object)this.fDepth, callStackQuark);
            }
            String element = (String)MavenEvent.ELEMENT_ASPECT.resolve(event);
            this.updateStackTop(ssb, callStackQuark, String.valueOf(element));
            ssb.pushAttribute(this.fSafeTime, (Object)groupAspect, callStackQuark);
            this.fNextClose = Long.MAX_VALUE;
            this.fDepth = 2;
        } else if (event.getType().equals(MavenEvent.SUMMARY_TYPE)) {
            if (this.fNextClose != Long.MAX_VALUE) {
                while (this.fDepth > 2) {
                    --this.fDepth;
                    ssb.popAttribute(this.fNextClose, callStackQuark);
                }
            }
            this.fSafeTime = this.fNextClose != Long.MAX_VALUE ? this.fNextClose + 1L : this.fSafeTime;
            long duration = (long)Math.ceil(Objects.requireNonNull((Double)MavenEvent.DURATION_ASPECT.resolve(event)) * 1.0E9);
            ssb.pushAttribute(this.fSafeTime, (Object)groupAspect, callStackQuark);
            this.fNextClose = this.fSafeTime + duration;
            this.fDepth = 3;
        } else if (event.getType().equals(MavenEvent.TEST_TYPE)) {
            String fullGroup = Objects.requireNonNull((String)MavenEvent.FULL_GROUP_ASPECT.resolve(event));
            String group = fullGroup.substring(fullGroup.indexOf(40) + 1, fullGroup.length() - 1);
            if (this.fDepth == 2) {
                ssb.pushAttribute(this.fSafeTime, (Object)group, callStackQuark);
                this.fDepth = 3;
            } else {
                String topGroup = MavenCallstackStateProvider.peekStackTop(ssb, callStackQuark);
                if (!group.equals(topGroup)) {
                    while (this.fDepth > 3) {
                        --this.fDepth;
                        ssb.popAttribute(this.fSafeTime, callStackQuark);
                    }
                    ssb.pushAttribute(this.fSafeTime, (Object)group, callStackQuark);
                    this.fDepth = 4;
                }
            }
            long testDuration = (long)Math.ceil(Objects.requireNonNull((Double)MavenEvent.DURATION_ASPECT.resolve(event)) * 1.0E9);
            ++this.fSafeTime;
            ssb.pushAttribute(this.fSafeTime, (Object)groupAspect, callStackQuark);
            this.fSafeTime += testDuration;
            ssb.popAttribute(this.fSafeTime, callStackQuark);
        }
    }

    private void updateStackTop(ITmfStateSystemBuilder ssb, int callStackQuark, String value) {
        Object currentDepth = ssb.queryOngoing(callStackQuark);
        if (currentDepth == null) {
            currentDepth = 1;
        }
        int currentGroupQuark = ssb.getQuarkRelativeAndAdd(callStackQuark, new String[]{String.valueOf(currentDepth)});
        ssb.modifyAttribute(this.fSafeTime, (Object)value, currentGroupQuark);
    }

    private static @Nullable String peekStackTop(ITmfStateSystemBuilder ssb, int callStackQuark) {
        Object currentDepth = ssb.queryOngoing(callStackQuark);
        int currentGroupQuark = ssb.getQuarkRelativeAndAdd(callStackQuark, new String[]{String.valueOf(currentDepth)});
        Object currentTop = ssb.queryOngoing(currentGroupQuark);
        return currentTop instanceof String ? (String)currentTop : null;
    }
}

