/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.resources;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.modules.platform.resources.FilesystemHandle;

public class ResourceHandle
extends FilesystemHandle {
    private final IFile fFile;

    public ResourceHandle(IFile file, int mode) {
        super(null, mode);
        this.fFile = file;
    }

    @Override
    protected BufferedReader createReader() throws Exception {
        return new BufferedReader(new InputStreamReader(this.fFile.getContents()));
    }

    @Override
    public void write(String data) throws IOException {
        this.write(data.getBytes());
    }

    @Override
    public void write(byte[] data) throws IOException {
        try {
            if ((this.getMode() & 4) == 4) {
                this.fFile.appendContents((InputStream)new ByteArrayInputStream(data), false, false, null);
            } else {
                this.fFile.setContents((InputStream)new ByteArrayInputStream(data), false, false, null);
                this.setMode(4);
            }
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public Path getPath() {
        return this.fFile.getLocation().toFile().toPath();
    }

    @Override
    public boolean exists() {
        return this.fFile.exists();
    }

    @Override
    public boolean createFile(boolean createHierarchy) throws IOException {
        if (createHierarchy) {
            ResourceHandle.createFolder(this.fFile.getParent());
        }
        try {
            this.fFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
            return true;
        }
        catch (CoreException e) {
            throw new IOException(e);
        }
    }

    public static boolean createFolder(IContainer container) throws IOException {
        if (!container.isAccessible()) {
            IContainer parent;
            block9: {
                parent = container.getParent();
                try {
                    if (parent.isAccessible()) break block9;
                    if (parent instanceof IFolder) {
                        ResourceHandle.createFolder(parent);
                        break block9;
                    }
                    if (parent instanceof IProject) {
                        ((IProject)parent).create(null);
                        ((IProject)parent).open(null);
                        break block9;
                    }
                    return false;
                }
                catch (CoreException e) {
                    throw new IOException(e);
                }
            }
            if (container instanceof IFolder) {
                ((IFolder)container).create(0, true, null);
            } else if (container instanceof IProject) {
                ((IProject)container).create(null);
                ((IProject)parent).open(null);
            }
        }
        return true;
    }

    @Override
    public Object getFile() {
        return this.fFile;
    }
}

