/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.ui.core.RectangleDrawer;
import org.eclipse.titan.log.viewer.views.msc.ui.view.IGC;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public abstract class TestCaseEventNode
extends MSCNode {
    protected int lifelines;

    public TestCaseEventNode(int eventOccurrence, int lifelines) {
        super(eventOccurrence);
        this.lifelines = lifelines;
    }

    @Override
    public int getX() {
        return MSCConstants.COLUMN_WIDTH + 6;
    }

    @Override
    public int getWidth() {
        return this.lifelines * MSCConstants.COLUMN_WIDTH - 12 + 2;
    }

    @Override
    protected void draw(IGC context) {
        Rectangle rectangle = new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        RectangleDrawer.drawShadow(context, rectangle, RectangleDrawer.getColor("COLOR_GREY"), 1);
        RectangleDrawer.drawBox(context, rectangle, this.getBackgroundColor(), RectangleDrawer.getColor("COLOR_WHITE"), 1);
        RectangleDrawer.drawBorder(context, rectangle, RectangleDrawer.getColor("COLOR_BLACK"), 1);
        RectangleDrawer.drawText(context, rectangle, this.getNodeText(), (Color)Activator.getDefault().getCachedResource("COLOR_BLACK"), (Font)Activator.getDefault().getCachedResource("FONT_DEFAULT"), 1);
    }

    protected abstract Color getBackgroundColor();

    @Override
    public int getY() {
        return MSCConstants.ROW_HEIGHT * this.getStartOccurrence() + 5;
    }

    protected abstract String getNodeText();
}

