/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views.msc.ui.core;

import java.util.List;
import org.eclipse.titan.log.viewer.views.msc.ui.core.Lifeline;
import org.eclipse.titan.log.viewer.views.msc.ui.core.LifelineHeader;
import org.eclipse.titan.log.viewer.views.msc.ui.core.MSCNode;
import org.eclipse.titan.log.viewer.views.msc.util.MSCConstants;

public abstract class BasicFrame {
    private int verticalIndex = 0;
    private int horizontalIndex = 1;
    private int visibleAreaX;
    private int visibleAreaY;
    private int visibleAreaWidth;
    private int visibleAreaHeight;

    protected int getMaxEventOccurrence() {
        return this.verticalIndex;
    }

    protected void setMaxEventOccurrence(int eventOccurrence) {
        this.verticalIndex = eventOccurrence;
    }

    protected int getNewHorizontalIndex() {
        return this.horizontalIndex++;
    }

    protected int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public int getX() {
        return 10;
    }

    public int getY() {
        return 10;
    }

    public int getWidth() {
        return this.horizontalIndex * MSCConstants.COLUMN_WIDTH + 10 + 50;
    }

    public int getHeight() {
        return this.verticalIndex * MSCConstants.ROW_HEIGHT + 10 + 50;
    }

    protected MSCNode getNodeFromListAt(int x, int y, List<MSCNode> list, int fromIndex) {
        MSCNode node;
        if (list == null) {
            return null;
        }
        for (int i = fromIndex; !(i >= list.size() || (node = list.get(i)) instanceof Lifeline && node.getX() > this.visibleAreaX + this.visibleAreaWidth || node.getHeight() < 0 && node.getY() + node.getHeight() > this.visibleAreaY + this.visibleAreaHeight); ++i) {
            if (!node.contains(x, y)) continue;
            return node;
        }
        return null;
    }

    protected MSCNode getHeaderNodeFromListAt(int x, int y, List<LifelineHeader> list, int fromIndex) {
        LifelineHeader node;
        if (list == null) {
            return null;
        }
        for (int i = fromIndex; i < list.size() && ((node = list.get(i)).getHeight() >= 0 || node.getY() + node.getHeight() <= this.visibleAreaY + this.visibleAreaHeight); ++i) {
            if (!node.contains(x, y)) continue;
            return node;
        }
        return null;
    }

    public int getVisibleAreaX() {
        return this.visibleAreaX;
    }

    public int getVisibleAreaWidth() {
        return this.visibleAreaWidth;
    }

    public int getVisibleAreaHeight() {
        return this.visibleAreaHeight;
    }

    public int getVisibleAreaY() {
        return this.visibleAreaY;
    }

    public void setVisibleArea(int x, int y, int width, int height) {
        this.visibleAreaX = x;
        this.visibleAreaY = y;
        this.visibleAreaWidth = width;
        this.visibleAreaHeight = height;
    }
}

