/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.wizards.projectFormat;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.path.TitanURIUtil;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.properties.data.DOMErrorHandlerImpl;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.wizards.projectFormat.EditPathVariableDialog;
import org.eclipse.titan.designer.wizards.projectFormat.NewProjectNameDialog;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.Bundle;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.xml.sax.SAXException;

public class TpdImporter {
    private static final String CREATING_PROJECT = "creating project";
    private static final String CREATION_FAILED = "Project creation failed";
    private static final String TPD_XSD = "schema/TPD.xsd";
    private DOMImplementationLS domImplLS;
    private LSParser parser;
    private DOMConfiguration config;
    private final Map<String, String> finalProjectNames = new HashMap<String, String>();
    private final Map<URI, Document> projectsToImport = new HashMap<URI, Document>();
    private final List<URI> importChain = new ArrayList<URI>();
    private final boolean wasAutoBuilding;
    private final Shell shell;
    private final boolean headless;
    private List<String> searchPaths;
    private final Map<String, String> tpdNameAttrMap = new HashMap<String, String>();
    private final Map<String, String> tpdURIMap = new HashMap<String, String>();
    private boolean islimitImportProcesses = false;
    private int processingUnitsToUse;

    public TpdImporter(Shell shell, boolean headless) {
        this.shell = shell;
        this.headless = headless;
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        this.wasAutoBuilding = description.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"while disabling autobuild on the workspace", (Throwable)e);
        }
        if (!headless) {
            Activator.getDefault().pauseHandlingResourceChanges();
        }
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        IPreferencesService prefs = Platform.getPreferencesService();
        this.processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
    }

    public boolean internalFinish(String projectFile, final boolean isSkipExistingProjects, boolean isOpenPropertiesForAllImports, boolean islimitImportProcesses, List<IProject> projectsCreated, IProgressMonitor monitor, final List<String> searchPaths) {
        List<IProject> projectsToBeConfigured;
        if (projectFile == null || "".equals(projectFile.trim())) {
            return false;
        }
        this.islimitImportProcesses = islimitImportProcesses;
        if (searchPaths != null) {
            this.searchPaths = new ArrayList<String>(searchPaths);
        }
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "com.sun.org.apache.xerces.internal.dom.DOMImplementationSourceImpl");
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("While importing from `" + projectFile + "'"), (Throwable)e);
            this.activatePreviousSettings();
            return false;
        }
        DOMImplementation domImpl = registry.getDOMImplementation("LS 3.0");
        this.domImplLS = (DOMImplementationLS)((Object)domImpl);
        this.parser = this.domImplLS.createLSParser((short)1, "http://www.w3.org/2001/XMLSchema");
        this.config = this.parser.getDomConfig();
        DOMErrorHandlerImpl errorHandler = new DOMErrorHandlerImpl();
        this.config.setParameter("error-handler", errorHandler);
        this.config.setParameter("validate", Boolean.TRUE);
        this.config.setParameter("schema-type", "http://www.w3.org/2001/XMLSchema");
        this.config.setParameter("well-formed", Boolean.TRUE);
        this.config.setParameter("validate-if-schema", Boolean.TRUE);
        Validator tpdValidator = null;
        try {
            Schema tpdXsd = TpdImporter.getTPDSchema();
            tpdValidator = tpdXsd.newValidator();
        }
        catch (Exception e) {
            ErrorReporter.INTERNAL_ERROR((String)e.getMessage());
        }
        final URI resolvedProjectFileURI = TITANPathUtilities.resolvePath((String)projectFile, (URI)null);
        if (!this.loadURIDocuments(resolvedProjectFileURI, tpdValidator)) {
            return false;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        progress.setTaskName("Loading data");
        SubMonitor projectCreationMonitor = progress.newChild(1);
        projectCreationMonitor.beginTask("Creating required projects", this.projectsToImport.size());
        final ConcurrentHashMap projectMap = new ConcurrentHashMap();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = islimitImportProcesses ? Executors.newFixedThreadPool(this.processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        final AtomicBoolean isErroneous = new AtomicBoolean(false);
        final LinkedBlockingDeque projectsCreatedTemp = new LinkedBlockingDeque();
        final CountDownLatch latch = new CountDownLatch(this.projectsToImport.size());
        for (final URI file : this.projectsToImport.keySet()) {
            final Document actualDocument = this.projectsToImport.get(file);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    IProject project = TpdImporter.this.createProject(actualDocument.getDocumentElement(), file.equals(resolvedProjectFileURI) || !isSkipExistingProjects);
                    if (project == null) {
                        if (file.equals(resolvedProjectFileURI)) {
                            isErroneous.set(true);
                            latch.countDown();
                            return;
                        }
                        latch.countDown();
                        return;
                    }
                    projectsCreatedTemp.add(project);
                    projectMap.put(file, project);
                    try {
                        project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"), file.getPath().toString());
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While loading referenced project from `" + file.getPath() + "'"), (Throwable)e);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        projectsCreated.addAll(projectsCreatedTemp);
        projectCreationMonitor.done();
        if (isErroneous.get()) {
            return false;
        }
        SubMonitor normalInformationLoadingMonitor = progress.newChild(1);
        normalInformationLoadingMonitor.beginTask("Loading directly stored project information", this.projectsToImport.size());
        ExecutorService executor2 = islimitImportProcesses ? Executors.newFixedThreadPool(this.processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        final CountDownLatch latch2 = new CountDownLatch(this.projectsToImport.size());
        for (final URI file : this.projectsToImport.keySet()) {
            executor2.execute(new Runnable(){

                @Override
                public void run() {
                    if (!projectMap.containsKey(file)) {
                        latch2.countDown();
                        return;
                    }
                    IProject project = (IProject)projectMap.get(file);
                    IPath projectFileFolderPath = new Path(file.getPath()).removeLastSegments(1);
                    URI projectFileFolderURI = URIUtil.toURI((IPath)projectFileFolderPath);
                    Document actualDocument = (Document)TpdImporter.this.projectsToImport.get(file);
                    if (searchPaths != null && !searchPaths.isEmpty()) {
                        String tpdNameAttrVal = (String)TpdImporter.this.tpdNameAttrMap.get(project.getName());
                        String tpdURIVal = (String)TpdImporter.this.tpdURIMap.get(project.getName());
                        if (tpdNameAttrVal != null) {
                            try {
                                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useTpdName"), tpdNameAttrVal);
                            }
                            catch (CoreException e) {
                                ErrorReporter.logExceptionStackTrace((String)("While setting `useTpdName' for project `" + project.getName() + "'"), (Throwable)e);
                            }
                        }
                        if (tpdURIVal != null) {
                            try {
                                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "origTpdURI"), tpdURIVal);
                            }
                            catch (CoreException e) {
                                ErrorReporter.logExceptionStackTrace((String)("While setting `origTpdURI' for project `" + project.getName() + "'"), (Throwable)e);
                            }
                        }
                    }
                    Element mainElement = actualDocument.getDocumentElement();
                    Node node = mainElement.getFirstChild();
                    String commentStr = "";
                    if (node != null && node.getNodeType() == 8) {
                        Comment comment = (Comment)node;
                        commentStr = comment.getData();
                    }
                    try {
                        project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "projectCopyright"), commentStr);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While setting `copyright string' for project `" + project.getName() + "'"), (Throwable)e);
                    }
                    if (!TpdImporter.this.loadProjectDataFromNode(mainElement, project, projectFileFolderURI)) {
                        latch2.countDown();
                        isErroneous.set(true);
                        return;
                    }
                    latch2.countDown();
                }
            });
        }
        try {
            latch2.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor2.shutdown();
        try {
            executor2.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor2.shutdownNow();
        if (isErroneous.get()) {
            return false;
        }
        normalInformationLoadingMonitor.done();
        IPath mainProjectFileFolderPath = new Path(resolvedProjectFileURI.getPath()).removeLastSegments(1);
        URI mainProjectFileFolderURI = URIUtil.toURI((IPath)mainProjectFileFolderPath);
        List<Node> packedProjects = this.loadPackedProjects(this.projectsToImport.get(resolvedProjectFileURI));
        SubMonitor packedInformationLoadingMonitor = progress.newChild(1);
        packedInformationLoadingMonitor.beginTask("Loading packed project information", packedProjects.size());
        for (Node node : packedProjects) {
            IProject project = this.createProject(node, false);
            if (project == null) {
                packedInformationLoadingMonitor.worked(1);
                continue;
            }
            projectsCreated.add(project);
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"), resolvedProjectFileURI.toString());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading packed project `" + project.getName() + "'"), (Throwable)e);
            }
            if (!this.loadProjectDataFromNode(node, project, mainProjectFileFolderURI)) {
                return false;
            }
            packedInformationLoadingMonitor.worked(1);
        }
        packedInformationLoadingMonitor.done();
        IProject mainProject = (IProject)projectMap.get(resolvedProjectFileURI);
        if (mainProject == null) {
            progress.done();
            return false;
        }
        try {
            mainProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "useTpdName"), mainProject.getName() + ".tpd");
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting `useTpdName' for project `" + mainProject.getName() + "'"), (Throwable)e);
        }
        ArrayList<4> jobs = new ArrayList<4>();
        if (isOpenPropertiesForAllImports) {
            projectsToBeConfigured = projectsCreated;
        } else {
            projectsToBeConfigured = new ArrayList<IProject>();
            projectsToBeConfigured.add(mainProject);
        }
        if (!this.headless) {
            for (final IProject iProject : projectsToBeConfigured) {
                WorkspaceJob loadJob = new WorkspaceJob("Property initilizer for " + iProject.getName()){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn(null, (IAdaptable)iProject, (String)"org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage", null, null);
                                if (dialog != null) {
                                    dialog.open();
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                loadJob.setUser(false);
                loadJob.setSystem(true);
                loadJob.setRule(iProject.getWorkspace().getRuleFactory().refreshRule((IResource)iProject));
                loadJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)ImageCache.getImageDescriptor("titan.gif"));
                loadJob.schedule();
                jobs.add(loadJob);
            }
            for (WorkspaceJob workspaceJob : jobs) {
                try {
                    workspaceJob.join();
                }
                catch (InterruptedException e) {
                    ErrorReporter.logExceptionStackTrace((String)("Interrupted while performing: " + workspaceJob.getName()), (Throwable)e);
                }
            }
        }
        this.activatePreviousSettings();
        progress.done();
        return true;
    }

    public static void validateTpd(File tpdFile) throws IOException, SAXException {
        Schema tpdXsd = TpdImporter.getTPDSchema();
        Validator validator = tpdXsd.newValidator();
        validator.validate(new StreamSource(tpdFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema getTPDSchema() throws IOException, SAXException {
        Schema schema;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.titan.designer");
        InputStream xsdInputStream = null;
        try {
            xsdInputStream = FileLocator.openStream((Bundle)bundle, (IPath)new Path(TPD_XSD), (boolean)false);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema result = factory.newSchema(new StreamSource(xsdInputStream));
            xsdInputStream.close();
            schema = result;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xsdInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)xsdInputStream);
        return schema;
    }

    private void activatePreviousSettings() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (description.isAutoBuilding() != this.wasAutoBuilding) {
            description.setAutoBuilding(this.wasAutoBuilding);
            try {
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("Resetting autobuild settings to" + this.wasAutoBuilding), (Throwable)e);
            }
        }
        if (!this.headless) {
            Activator.getDefault().resumeHandlingResourceChanges();
        }
    }

    private List<Node> loadPackedProjects(Document document) {
        NodeList referencedProjectsList = document.getDocumentElement().getChildNodes();
        Node packed = ProjectFileHandler.getNodebyName(referencedProjectsList, "PackedReferencedProjects");
        if (packed == null) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList projects = packed.getChildNodes();
        int size = projects.getLength();
        for (int i = 0; i < size; ++i) {
            Node referencedProjectNode = projects.item(i);
            if (!"PackedReferencedProject".equals(referencedProjectNode.getNodeName())) continue;
            result.add(referencedProjectNode);
        }
        return result;
    }

    private boolean loadProjectDataFromNode(Node mainElement, IProject project, URI projectFileFolderURI) {
        NodeList mainNodes = mainElement.getChildNodes();
        Node referencedProjectsNode = ProjectFileHandler.getNodebyName(mainNodes, "ReferencedProjects");
        if (referencedProjectsNode != null && !this.loadReferencedProjectsData(referencedProjectsNode, project)) {
            return false;
        }
        Node pathVariablesNode = ProjectFileHandler.getNodebyName(mainNodes, "PathVariables");
        if (pathVariablesNode != null && !this.loadPathVariables(pathVariablesNode, project.getName())) {
            return false;
        }
        Node foldersNode = ProjectFileHandler.getNodebyName(mainNodes, "Folders");
        if (foldersNode != null && !this.loadFoldersData(foldersNode, project, projectFileFolderURI)) {
            return false;
        }
        Node filesNode = ProjectFileHandler.getNodebyName(mainNodes, "Files");
        if (filesNode != null && !this.loadFilesData(filesNode, project, projectFileFolderURI)) {
            return false;
        }
        ProjectDocumentHandlingUtility.createDocument(project);
        return this.loadConfigurationData(project, mainNodes);
    }

    private boolean loadReferencedProjectsData(Node referencedProjectsNode, final IProject project) {
        NodeList referencedProjectsList = referencedProjectsNode.getChildNodes();
        final LinkedBlockingDeque referencedProjects = new LinkedBlockingDeque();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = this.islimitImportProcesses ? Executors.newFixedThreadPool(this.processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        final AtomicBoolean isErroneous = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(referencedProjectsList.getLength());
        int i = 0;
        int size = referencedProjectsList.getLength();
        while (i < size) {
            final Node referencedProjectNode = referencedProjectsList.item(i);
            final int index = i++;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (referencedProjectNode.getNodeType() != 1) {
                        latch.countDown();
                        return;
                    }
                    NamedNodeMap attributeMap = referencedProjectNode.getAttributes();
                    if (attributeMap == null) {
                        latch.countDown();
                        return;
                    }
                    Node nameNode = attributeMap.getNamedItem("name");
                    if (nameNode == null) {
                        TpdImporter.this.displayError("Import failed", "Error while importing project " + project.getName() + " the name attribute of the " + index + " th referenced project is missing");
                        isErroneous.set(true);
                        latch.countDown();
                        return;
                    }
                    String projectName = nameNode.getTextContent();
                    String realProjectName = (String)TpdImporter.this.finalProjectNames.get(projectName);
                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (realProjectName != null && realProjectName.length() > 0) {
                        IProject tempProject = workspaceRoot.getProject(realProjectName);
                        referencedProjects.add(tempProject);
                    } else {
                        IProject tempProject = workspaceRoot.getProject(projectName);
                        referencedProjects.add(tempProject);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        if (isErroneous.get()) {
            return false;
        }
        try {
            IProjectDescription description = project.getDescription();
            description.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting project references for `" + project.getName() + "'"), (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean loadFoldersData(Node foldersNode, IProject project, URI projectFileFolderURI) {
        URI projectLocationURI = project.getLocationURI();
        NodeList folderNodeList = foldersNode.getChildNodes();
        int size = folderNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node folderItem = folderNodeList.item(i);
            if (folderItem.getNodeType() != 1 || (attributeMap = folderItem.getAttributes()) == null) continue;
            Node projectRelativePathNode = attributeMap.getNamedItem("projectRelativePath");
            if (projectRelativePathNode == null) {
                this.displayError("Import failed", "Error while importing project " + project.getName() + " the project relative path attribute of the " + i + " th folder is missing");
                return false;
            }
            String projectRelativePath = projectRelativePathNode.getTextContent();
            Node relativeURINode = attributeMap.getNamedItem("relativeURI");
            Node rawURINode = attributeMap.getNamedItem("rawURI");
            IFolder folder = project.getFolder(projectRelativePath);
            if (!folder.exists()) {
                try {
                    if (relativeURINode != null) {
                        String relativeLocation = relativeURINode.getTextContent();
                        if ("virtual:/virtual".equals(relativeLocation)) {
                            folder.createLink(URI.create(relativeLocation), 16, null);
                            continue;
                        }
                        URI absoluteURI = TITANPathUtilities.resolvePathURI((String)relativeLocation, (String)URIUtil.toPath((URI)projectFileFolderURI).toOSString());
                        if (absoluteURI == null) continue;
                        if (TitanURIUtil.isPrefix((URI)projectLocationURI, (URI)absoluteURI)) {
                            folder.create(false, true, null);
                            continue;
                        }
                        File tmpFolder = new File(absoluteURI);
                        if (tmpFolder.exists()) {
                            folder.createLink(absoluteURI, 16, null);
                            continue;
                        }
                        ErrorReporter.logError((String)("Error while importing folders into project `" + project.getName() + "'. Folder `" + absoluteURI + "' does not exist"));
                        continue;
                    }
                    if (rawURINode != null) {
                        String rawLocation = rawURINode.getTextContent();
                        folder.createLink(URI.create(rawLocation), 16, null);
                        continue;
                    }
                    TITANDebugConsole.println("Cannot create the resource " + folder.getFullPath().toString() + " the location information is missing or corrupted");
                }
                catch (CoreException e) {
                    ErrorReporter.logError((String)("Error while importing folders into project: " + (Object)((Object)e)));
                }
                continue;
            }
            ErrorReporter.logWarning((String)("Folder to be imported `" + folder.getName() + "' already exists in project `" + project.getName() + "'"));
        }
        return true;
    }

    private boolean loadFilesData(Node filesNode, final IProject project, final URI projectFileFolderURI) {
        NodeList fileNodeList = filesNode.getChildNodes();
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = this.islimitImportProcesses ? Executors.newFixedThreadPool(this.processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        final AtomicBoolean isErroneous = new AtomicBoolean(false);
        final CountDownLatch latch = new CountDownLatch(fileNodeList.getLength());
        int i = 0;
        int size = fileNodeList.getLength();
        while (i < size) {
            final Node fileItem = fileNodeList.item(i);
            final int index = i++;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    block10: {
                        if (fileItem.getNodeType() != 1) {
                            latch.countDown();
                            return;
                        }
                        NamedNodeMap attributeMap = fileItem.getAttributes();
                        if (attributeMap == null) {
                            latch.countDown();
                            return;
                        }
                        Node projectRelativePathNode = attributeMap.getNamedItem("projectRelativePath");
                        if (projectRelativePathNode == null) {
                            TpdImporter.this.displayError("Import failed", "Error while importing project " + project.getName() + " some attributes of the " + index + " th file are missing");
                            latch.countDown();
                            return;
                        }
                        String projectRelativePath = projectRelativePathNode.getTextContent();
                        Node relativeURINode = attributeMap.getNamedItem("relativeURI");
                        Node rawURINode = attributeMap.getNamedItem("rawURI");
                        IFile targetFile = project.getFile(projectRelativePath);
                        if (!targetFile.exists()) {
                            try {
                                if (relativeURINode != null) {
                                    String relativeLocation = relativeURINode.getTextContent();
                                    URI absoluteURI = TITANPathUtilities.resolvePathURI((String)relativeLocation, (String)URIUtil.toPath((URI)projectFileFolderURI).toOSString());
                                    if (absoluteURI == null) {
                                        ErrorReporter.logError((String)("Error while importing files into project `" + project.getName() + "'. File `" + absoluteURI + "' does not exist!"));
                                        latch.countDown();
                                        return;
                                    }
                                    File file = new File(absoluteURI);
                                    if (file.exists()) {
                                        targetFile.createLink(absoluteURI, 16, null);
                                        break block10;
                                    }
                                    ErrorReporter.logError((String)("Error while importing files into project `" + project.getName() + "'. File `" + absoluteURI + "' does not exist"));
                                    latch.countDown();
                                    return;
                                }
                                if (rawURINode != null) {
                                    String rawURI = rawURINode.getTextContent();
                                    targetFile.createLink(URI.create(rawURI), 16, null);
                                    break block10;
                                }
                                TITANDebugConsole.println("Can not create the resource " + targetFile.getFullPath().toString() + " the location information is missing or corrupted");
                                latch.countDown();
                                return;
                            }
                            catch (CoreException e) {
                                ErrorReporter.logExceptionStackTrace((String)("While creating link for `" + targetFile + "'"), (Throwable)e);
                                isErroneous.set(true);
                                latch.countDown();
                                return;
                            }
                        }
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        return !isErroneous.get();
    }

    private URI convertPathOrUriStringToURI(String pathOrUriString) throws URISyntaxException {
        URI uri = new URI(pathOrUriString);
        if (uri.getScheme() == null || "file".equals(uri.getScheme())) {
            return uri;
        }
        Path tempPath = new Path(pathOrUriString);
        if (tempPath.isValidPath(pathOrUriString)) {
            return URIUtil.toURI((IPath)tempPath);
        }
        return URIUtil.toURI((String)pathOrUriString, (boolean)false);
    }

    private boolean loadPathVariables(Node rootNode, String projectName) {
        final IPathVariableManager pathVariableManager = ResourcesPlugin.getWorkspace().getPathVariableManager();
        NodeList variableNodes = rootNode.getChildNodes();
        int size = variableNodes.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node variable = variableNodes.item(i);
            if (variable.getNodeType() != 1 || (attributeMap = variable.getAttributes()) == null) continue;
            Node nameNode = attributeMap.getNamedItem("name");
            Node valueNode = attributeMap.getNamedItem("value");
            if (nameNode == null || valueNode == null) {
                this.displayError("Import failed", "Error while importing project " + projectName + " some attributes of a path variable are missing");
                return false;
            }
            final String variableName = nameNode.getTextContent();
            final String variableValue = valueNode.getTextContent();
            if (this.headless || this.shell == null) {
                try {
                    pathVariableManager.setURIValue(variableName, this.convertPathOrUriStringToURI(variableValue));
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While setting path variable `" + variableName + "' in headless mode"), (Throwable)e);
                }
                catch (URISyntaxException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While setting path variable `" + variableName + "' in headless mode"), (Throwable)e);
                }
                continue;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        URI variableValueURI = TpdImporter.this.convertPathOrUriStringToURI(variableValue);
                        String variableValue1 = variableValueURI.toString();
                        if (pathVariableManager.isDefined(variableName)) {
                            EditPathVariableDialog dialog;
                            URI uri = pathVariableManager.getURIValue(variableName);
                            if (!variableValue1.equals(uri.toString()) && 0 == (dialog = new EditPathVariableDialog(TpdImporter.this.shell, variableName, uri, variableValueURI)).open()) {
                                URI actualValue = dialog.getActualValue();
                                pathVariableManager.setURIValue(variableName, actualValue);
                            }
                        } else {
                            pathVariableManager.setURIValue(variableName, variableValueURI);
                        }
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While setting path variable `" + variableName + "' in GUI mode"), (Throwable)e);
                    }
                    catch (URISyntaxException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While setting path variable `" + variableName + "' in GUI mode"), (Throwable)e);
                    }
                }
            });
        }
        return true;
    }

    private boolean loadConfigurationData(IProject project, NodeList mainNodes) {
        Document targetDocument = ProjectDocumentHandlingUtility.getDocument(project);
        Node activeConfigurationNode = ProjectFileHandler.getNodebyName(mainNodes, "ActiveConfiguration");
        String activeConfiguration = "Default";
        activeConfiguration = activeConfigurationNode != null ? activeConfigurationNode.getTextContent() : "Default";
        try {
            project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.activeConfiguration"), activeConfiguration);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting `" + activeConfiguration + "' as configuration for project `" + project.getName() + "'"), (Throwable)e);
        }
        this.removeConfigurationNodes(targetDocument.getDocumentElement());
        Element targetActiveConfiguration = targetDocument.createElement("ActiveConfiguration");
        targetActiveConfiguration.appendChild(targetDocument.createTextNode(activeConfiguration));
        targetDocument.getDocumentElement().appendChild(targetActiveConfiguration);
        Element targetConfigurationsRoot = targetDocument.createElement("Configurations");
        targetDocument.getDocumentElement().appendChild(targetConfigurationsRoot);
        Node configurationsNode = ProjectFileHandler.getNodebyName(mainNodes, "Configurations");
        if (configurationsNode == null) {
            ProjectDocumentHandlingUtility.saveDocument(project);
            ProjectBuildPropertyData.setProjectAlreadyExported(project, false);
            ProjectFileHandler handler = new ProjectFileHandler(project);
            handler.loadProjectSettingsFromDocument(targetDocument);
            return true;
        }
        NodeList configurationsNodeList = configurationsNode.getChildNodes();
        int size = configurationsNodeList.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node configurationNode = configurationsNodeList.item(i);
            if (configurationNode.getNodeType() != 1 || (attributeMap = configurationNode.getAttributes()) == null) continue;
            Node nameNode = attributeMap.getNamedItem("name");
            if (nameNode == null) {
                this.displayError("Import failed", "Error while importing project " + project.getName() + " the name attribute of a referenced project is missing");
                return false;
            }
            String configurationName = nameNode.getTextContent();
            if ("Default".equals(configurationName)) {
                this.copyConfigurationData(targetDocument.getDocumentElement(), configurationNode);
                continue;
            }
            Element targetConfiguration = targetDocument.createElement("Configuration");
            targetConfiguration.setAttribute("name", configurationName);
            targetConfigurationsRoot.appendChild(targetConfiguration);
            this.copyConfigurationData(targetConfiguration, configurationNode);
        }
        ProjectDocumentHandlingUtility.saveDocument(project);
        ProjectBuildPropertyData.setProjectAlreadyExported(project, false);
        ProjectFileHandler handler = new ProjectFileHandler(project);
        handler.loadProjectSettingsFromDocument(targetDocument);
        return true;
    }

    private void removeConfigurationNodes(Node rootNode) {
        NodeList rootNodeList = rootNode.getChildNodes();
        Node tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "Configurations");
        if (tempNode != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "ProjectProperties")) != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "FolderProperties")) != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "FileProperties")) != null) {
            rootNode.removeChild(tempNode);
        }
        if ((tempNode = ProjectFileHandler.getNodebyName(rootNodeList, "ActiveConfiguration")) != null) {
            rootNode.removeChild(tempNode);
        }
    }

    private void copyConfigurationData(Element targetRoot, Node sourceRoot) {
        Document document = targetRoot.getOwnerDocument();
        NodeList rootList = sourceRoot.getChildNodes();
        Node targetNode = null;
        int size = rootList.getLength();
        for (int i = 0; i < size; ++i) {
            Node tempNode = rootList.item(i);
            String nodeName = tempNode.getNodeName();
            if (!"ProjectProperties".equals(nodeName) && !"FolderProperties".equals(nodeName) && !"FileProperties".equals(nodeName)) continue;
            targetNode = document.importNode(tempNode, true);
            ProjectFileHandler.clearNode(targetNode);
            targetRoot.appendChild(targetNode);
        }
    }

    private IProject createProject(Node mainElement, boolean treatExistingProjectAsError) {
        String originalProjectName;
        NodeList mainNodes = mainElement.getChildNodes();
        Node projectNameNode = ProjectFileHandler.getNodebyName(mainNodes, "ProjectName");
        if (null == projectNameNode) {
            TITANDebugConsole.println("The name of the project could not be found in the project descriptor, it will not be created.");
            return null;
        }
        String projectName = originalProjectName = projectNameNode.getFirstChild().getTextContent();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists()) {
            if (!treatExistingProjectAsError || this.headless) {
                if (!project.isOpen()) {
                    try {
                        project.open(null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logError((String)("An existing project with the name " + projectName + " cannot be opened!"));
                    }
                }
                ErrorReporter.logWarning((String)("A project with the name " + projectName + " already exists, skipping it!"));
                return null;
            }
            ProjectSelector temp = new ProjectSelector(projectName);
            Display.getDefault().syncExec((Runnable)temp);
            if (temp.cancelled) {
                return null;
            }
            projectName = temp.getProjectName();
            project = temp.getProject();
        }
        this.finalProjectNames.put(originalProjectName, projectName);
        project = this.createNewProject(project, projectName);
        if (project == null) {
            TITANDebugConsole.println("There was an error while creating the project " + projectName);
            return null;
        }
        try {
            TITANNature.addTITANBuilderToProject(project);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While adding builder to `" + project.getName() + "'"), (Throwable)e);
        }
        return project;
    }

    private boolean loadURIDocuments(URI file, Validator validator) {
        if (this.projectsToImport.containsKey(file)) {
            return true;
        }
        if (!"file".equals(file.getScheme()) && !"".equals(file.getScheme())) {
            ErrorReporter.logError((String)("Loading of project information is only supported for local files right now. " + file.toString() + " could not be loaded"));
            return false;
        }
        Document document = this.getDocumentFromFile(file.getPath());
        if (document == null) {
            StringBuilder builder = new StringBuilder("It was not possible to load the imported project file: '" + file.toString() + "'\n");
            for (int i = this.importChain.size() - 1; i >= 0; --i) {
                builder.append("imported by: '");
                builder.append(this.importChain.get(i).toString());
                builder.append("'\n");
            }
            ErrorReporter.logError((String)builder.toString());
            return false;
        }
        if (validator != null) {
            try {
                validator.validate(new StreamSource(new File(file)));
            }
            catch (Exception e) {
                ErrorReporter.logExceptionStackTrace((String)("Error while importing from file " + file + ": " + System.getProperty("line.separator")), (Throwable)e);
                return false;
            }
        }
        ProjectFileHandler.clearNode(document);
        this.projectsToImport.put(file, document);
        Element mainElement = document.getDocumentElement();
        NodeList mainNodes = mainElement.getChildNodes();
        Node referencedProjectsNode = ProjectFileHandler.getNodebyName(mainNodes, "ReferencedProjects");
        if (referencedProjectsNode == null) {
            return true;
        }
        IPath projectFileFolderPath = new Path(file.getPath()).removeLastSegments(1);
        NodeList referencedProjectsList = referencedProjectsNode.getChildNodes();
        boolean result = true;
        int size = referencedProjectsList.getLength();
        for (int i = 0; i < size; ++i) {
            NamedNodeMap attributeMap;
            Node referencedProjectNode = referencedProjectsList.item(i);
            if (referencedProjectNode.getNodeType() != 1 || (attributeMap = referencedProjectNode.getAttributes()) == null) continue;
            Node nameNode = attributeMap.getNamedItem("name");
            if (nameNode == null) {
                this.displayError("Import failed", "Error while importing from file " + file + " the name attribute of a referenced project is missing");
                return false;
            }
            String projectName = nameNode.getTextContent();
            Node locationNode = attributeMap.getNamedItem("projectLocationURI");
            if (locationNode == null) {
                if (i > 0) {
                    this.displayError("Import failed", "Error while importing from file " + file + " the location attribute of the referenced project " + projectName + " is not given.");
                    break;
                }
                ErrorReporter.logWarning((String)("Import failed while importing from file " + file + " the location attribute of the referenced project " + projectName + " is not given.\nPerhaps it is under PackedReferencedProjects"));
                break;
            }
            String unresolvedProjectLocationURI = locationNode.getTextContent();
            URI absoluteURI = TITANPathUtilities.resolvePath((String)unresolvedProjectLocationURI, (URI)URIUtil.toURI((IPath)projectFileFolderPath));
            Node tpdNameNode = attributeMap.getNamedItem("tpdName");
            String fileName = tpdNameNode != null ? tpdNameNode.getTextContent() : projectName + ".tpd";
            this.tpdNameAttrMap.put(projectName, fileName);
            if (this.searchPaths != null && !this.searchPaths.isEmpty()) {
                File f = new File(absoluteURI);
                Path unresolvedProjectLocationURIPath = new Path(unresolvedProjectLocationURI);
                if (!(unresolvedProjectLocationURIPath.isAbsolute() || f.exists() && !f.isDirectory())) {
                    Iterator<String> iterator = this.searchPaths.iterator();
                    while (iterator.hasNext()) {
                        String systemPath;
                        String path;
                        String filePath = path = iterator.next();
                        if (path.charAt(path.length() - 1) != '/') {
                            filePath = filePath + "/";
                        }
                        if (!(f = new File(systemPath = new Path(filePath = filePath + fileName).toOSString())).exists() || f.isDirectory()) continue;
                        absoluteURI = URIUtil.toURI((String)systemPath);
                        this.tpdURIMap.put(projectName, unresolvedProjectLocationURI);
                        break;
                    }
                }
            }
            if (absoluteURI != null && !"file".equals(absoluteURI.getScheme())) {
                StringBuilder builder = new StringBuilder("Loading of project information is only supported for local files right now. " + absoluteURI.toString() + " could not be loaded\n");
                for (int j = this.importChain.size() - 1; j >= 0; --j) {
                    builder.append("imported by: '");
                    builder.append(this.importChain.get(j).toString());
                    builder.append("'\n");
                }
                ErrorReporter.logError((String)builder.toString());
                continue;
            }
            this.importChain.add(file);
            result &= this.loadURIDocuments(absoluteURI, validator);
            this.importChain.remove(this.importChain.size() - 1);
        }
        return result;
    }

    private void displayError(String title, String message) {
        if (!this.headless) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)title, (String)message);
        }
        ErrorReporter.logError((String)message);
    }

    public Document getDocumentFromFile(String file) {
        LSInput lsInput = this.domImplLS.createLSInput();
        Document document = null;
        try {
            FileInputStream istream = new FileInputStream(file);
            lsInput.setByteStream(istream);
            document = this.parser.parse(lsInput);
            istream.close();
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting the document from `" + file + "'"), (Throwable)e);
        }
        return document;
    }

    IProject createNewProject(final IProject newProjectHandle, String name) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(name);
        TITANNature.addTITANNatureToProject(description);
        if (this.headless) {
            try {
                this.createProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While creating project `" + newProjectHandle.getName() + "'"), (Throwable)e);
            }
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException {
                                TpdImporter.this.createProject(description, newProjectHandle, monitor);
                            }
                        };
                        new ProgressMonitorDialog(null).run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (InvocationTargetException e) {
                        TpdImporter.this.displayError(TpdImporter.CREATION_FAILED, e.getMessage());
                        ErrorReporter.logExceptionStackTrace((String)("While creating project `" + newProjectHandle.getName() + "'"), (Throwable)e);
                        return;
                    }
                }
            });
        }
        IProject newProject = newProjectHandle;
        return newProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            progress.setTaskName(CREATING_PROJECT);
            projectHandle.create(description, (IProgressMonitor)progress.newChild(1));
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)progress.newChild(1));
            projectHandle.refreshLocal(1, (IProgressMonitor)progress.newChild(1));
        }
        finally {
            progress.done();
        }
    }

    class ProjectSelector
    implements Runnable {
        private String projectName;
        private IProject project = null;
        private boolean cancelled = false;

        public ProjectSelector(String projectName) {
            this.projectName = projectName;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public IProject getProject() {
            return this.project;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void run() {
            NewProjectNameDialog dialog = new NewProjectNameDialog(TpdImporter.this.shell, this.projectName);
            if (dialog.open() == 0) {
                this.projectName = dialog.getName();
                this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                if (this.project.exists()) {
                    this.cancelled = true;
                }
            } else {
                this.cancelled = true;
            }
        }
    }
}

