/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.OptionElement;
import org.eclipse.titan.designer.properties.pages.OptionElementContentProvider;
import org.eclipse.titan.designer.properties.pages.OptionElementLabelProvider;
import org.eclipse.titan.designer.properties.pages.PreprocessorIncludedOptionsPage;
import org.eclipse.titan.designer.properties.pages.PreprocessorSymbolsOptionsPage;
import org.eclipse.titan.designer.properties.pages.ProjectJavaBuildPropertyPage;
import org.eclipse.titan.designer.properties.pages.TITANFlagsOptionsPage;
import org.eclipse.titan.designer.properties.pages.TTCN3PreprocessorOptionsPage;

public class InternalJavaCreationTab {
    private TabItem newBuildPropertiesTabItem;
    private Composite newBuildPropertiesComposite;
    private TreeViewer optionList;
    private final TTCN3PreprocessorOptionsPage ttcn3PreprocessorPage = new TTCN3PreprocessorOptionsPage(false);
    private final PreprocessorSymbolsOptionsPage ttcn3PreprocessorSymbolsPage = new PreprocessorSymbolsOptionsPage(true);
    private final PreprocessorIncludedOptionsPage ttcn3PreprocessorIncludesPage;
    private final TITANFlagsOptionsPage titanFlagsPage = new TITANFlagsOptionsPage(false);
    private final IOptionsPage[] pages;
    private IOptionsPage actualPage = null;
    private Composite settingsPageContainer;
    private ScrolledComposite containerSC;

    public InternalJavaCreationTab(IProject project) {
        this.ttcn3PreprocessorIncludesPage = new PreprocessorIncludedOptionsPage(project, true);
        this.pages = new IOptionsPage[]{this.ttcn3PreprocessorPage, this.ttcn3PreprocessorSymbolsPage, this.ttcn3PreprocessorIncludesPage, this.titanFlagsPage};
    }

    public void dispose() {
        this.newBuildPropertiesTabItem.dispose();
        this.newBuildPropertiesComposite.dispose();
        this.settingsPageContainer.dispose();
        this.containerSC.dispose();
        for (IOptionsPage page : this.pages) {
            page.dispose();
        }
    }

    protected TabItem createContents(TabFolder tabFolder) {
        this.newBuildPropertiesTabItem = new TabItem(tabFolder, 2048);
        this.newBuildPropertiesTabItem.setText("Internal build attributes");
        this.newBuildPropertiesTabItem.setToolTipText("Settings controlling the new generation of the makefile.");
        this.newBuildPropertiesComposite = new Composite((Composite)tabFolder, 2);
        this.newBuildPropertiesComposite.setEnabled(true);
        this.newBuildPropertiesComposite.setLayout((Layout)new GridLayout());
        SashForm sashForm = new SashForm(this.newBuildPropertiesComposite, 0);
        sashForm.setOrientation(256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.optionList = new TreeViewer((Composite)sashForm, 2820);
        this.optionList.setContentProvider((IContentProvider)new OptionElementContentProvider());
        this.optionList.setLabelProvider((IBaseLabelProvider)new OptionElementLabelProvider());
        this.optionList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InternalJavaCreationTab.this.handleSelectionChanged();
            }
        });
        OptionElement root = new OptionElement("root");
        OptionElement ttcn3preprocessor = new OptionElement("TTCN-3 Preprocessor", this.ttcn3PreprocessorPage);
        root.addChild(ttcn3preprocessor);
        ttcn3preprocessor.addChild(new OptionElement("Symbols (define, undefine)", this.ttcn3PreprocessorSymbolsPage));
        ttcn3preprocessor.addChild(new OptionElement("Included directories", this.ttcn3PreprocessorIncludesPage));
        OptionElement titan = new OptionElement("TITAN");
        root.addChild(titan);
        titan.addChild(new OptionElement("Flags", this.titanFlagsPage));
        this.optionList.setInput((Object)root);
        this.containerSC = new ScrolledComposite((Composite)sashForm, 768);
        this.containerSC.setExpandHorizontal(true);
        this.containerSC.setExpandVertical(true);
        this.settingsPageContainer = new Composite((Composite)this.containerSC, 0);
        this.settingsPageContainer.setLayout((Layout)new GridLayout());
        GridData data = new GridData();
        data.exclude = true;
        this.settingsPageContainer.setLayoutData((Object)data);
        this.containerSC.setContent((Control)this.settingsPageContainer);
        this.containerSC.setMinSize(this.settingsPageContainer.computeSize(-1, -1));
        for (IOptionsPage page : this.pages) {
            Composite comp = page.createContents(this.settingsPageContainer);
            comp.setVisible(false);
            ((GridData)comp.getLayoutData()).exclude = true;
        }
        this.settingsPageContainer.layout();
        this.newBuildPropertiesTabItem.setControl((Control)this.newBuildPropertiesComposite);
        return this.newBuildPropertiesTabItem;
    }

    private void handleSelectionChanged() {
        if (this.optionList == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.optionList.getSelection();
        OptionElement element = (OptionElement)selection.getFirstElement();
        if (element != null) {
            IOptionsPage next = element.page;
            if (next != null) {
                Composite comp;
                if (this.actualPage != null) {
                    comp = this.actualPage.createContents(this.settingsPageContainer);
                    comp.setVisible(false);
                    ((GridData)comp.getLayoutData()).exclude = true;
                }
                comp = next.createContents(this.settingsPageContainer);
                comp.setVisible(true);
                ((GridData)comp.getLayoutData()).exclude = false;
                this.actualPage = next;
                this.containerSC.setMinSize(comp.computeSize(-1, -1));
                this.settingsPageContainer.layout();
            } else {
                if (this.actualPage != null) {
                    Composite comp = this.actualPage.createContents(this.settingsPageContainer);
                    comp.setVisible(false);
                    ((GridData)comp.getLayoutData()).exclude = true;
                }
                this.actualPage = null;
                this.containerSC.setMinSize(0, 0);
                this.settingsPageContainer.layout();
            }
        }
    }

    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        for (IOptionsPage page : this.pages) {
            page.copyPropertyStore(project, tempStorage);
        }
    }

    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        boolean result = false;
        for (IOptionsPage page : this.pages) {
            result |= page.evaluatePropertyStore(project, tempStorage);
        }
        return result;
    }

    protected void performDefaults() {
        for (IOptionsPage page : this.pages) {
            page.performDefaults();
        }
    }

    public boolean checkProperties(ProjectJavaBuildPropertyPage page) {
        boolean result = true;
        return true;
    }

    public void loadProperties(IProject project) {
        for (IOptionsPage page : this.pages) {
            page.loadProperties(project);
        }
    }

    public boolean saveProperties(IProject project) {
        boolean result = true;
        for (IOptionsPage page : this.pages) {
            result &= page.saveProperties(project);
        }
        return result;
    }
}

