/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.asn1editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.graphics.ImageCache;

public final class ASN1CodeSkeletons {
    public static final String CONTEXT_IDENTIFIER = "ASN1_SOURCE_CODE";
    public static final String CONTEXT_NAME = "ASN1 Code Skeleton Context";
    private static Image skeletonImage = ImageCache.getImage("skeleton.gif");
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final SkeletonTemplateProposal[] TEMPLATE_PROPOSALS = new SkeletonTemplateProposal[]{new SkeletonTemplateProposal("SEQUENCE", new Template("SEQUENCE", "", "ASN1_SOURCE_CODE", "SEQUENCE {" + NEWLINE + "${field1} ${subType1}," + NEWLINE + "${field2} ${subType2} }", false)), new SkeletonTemplateProposal("SEQUENCE", new Template("SEQUENCE OF", "", "ASN1_SOURCE_CODE", "SEQUENCE OF ${constraint} OF ${Type}", false)), new SkeletonTemplateProposal("SET", new Template("SET", "", "ASN1_SOURCE_CODE", "SET {" + NEWLINE + "${field1} ${subType1}," + NEWLINE + "${field2} ${subType2} }", false)), new SkeletonTemplateProposal("SET", new Template("SET OF", "", "ASN1_SOURCE_CODE", "SET OF ${constraint} OF ${Type}", false)), new SkeletonTemplateProposal("CHOICE", new Template("CHOICE", "", "ASN1_SOURCE_CODE", "CHOICE {" + NEWLINE + "${field1} ${subType1}," + NEWLINE + "${field2} ${subType2} }", false)), new SkeletonTemplateProposal("ENUMERATED", new Template("ENUMERATED", "", "ASN1_SOURCE_CODE", "ENUMERATED { ${identifier1}( ${value1} ), ${identifier2}( ${value2} )} ${fieldIdentifier}", false)), new SkeletonTemplateProposal("COMPONENTS", new Template("COMPONENTS OF", "", "ASN1_SOURCE_CODE", "COMPONENTS OF ${type_assignment}", false)), new SkeletonTemplateProposal("CLASS", new Template("Object Class", "", "ASN1_SOURCE_CODE", "${IDENTIFIER} := CLASS {" + NEWLINE + "&${field1} ${type1} ${UNIQUE} ${OPTIONAL}," + NEWLINE + "&${field2} ${type2} ${UNIQUE} ${OPTIONAL}" + NEWLINE + "}", false)), new SkeletonTemplateProposal("CLASS", new Template("Object Class", "with user defined syntax", "ASN1_SOURCE_CODE", "${IDENTIFIER} := CLASS {" + NEWLINE + "&${field1} ${type1} ${UNIQUE} ${OPTIONAL}," + NEWLINE + "&${field2} ${type2} ${UNIQUE} ${OPTIONAL}" + NEWLINE + "} WITH SYNTAX {" + NEWLINE + "${FIELD1} &${field1}" + NEWLINE + "${FIELD2} &${field2}" + NEWLINE + "}", false)), new SkeletonTemplateProposal("OBJECTSET", new Template("Object Set", "", "ASN1_SOURCE_CODE", "${Identifier} ${OBJECT-CLASS} := {" + NEWLINE + "${first-object} |" + NEWLINE + "${second-object}" + NEWLINE + "}", false)), new SkeletonTemplateProposal("VALUESET", new Template("Value Set", "", "ASN1_SOURCE_CODE", "${Identifier} ${type} := {" + NEWLINE + "${first-value} |" + NEWLINE + "${second-value}" + NEWLINE + "}", false))};
    private static final String ASN1_MODULE_EMPTY = " DEFINITIONS" + NEWLINE + NEWLINE + "  AUTOMATIC TAGS ::=" + NEWLINE + NEWLINE + "BEGIN" + NEWLINE + NEWLINE + "END" + NEWLINE;
    private static final String ASN1_MODULE_SKELETON = " DEFINITIONS" + NEWLINE + NEWLINE + "-- [(AUTOMATIC|EXPLICIT|IMPLICIT) TAGS]" + NEWLINE + "-- the default is EXPLICIT TAGS" + NEWLINE + "  AUTOMATIC TAGS ::=" + NEWLINE + NEWLINE + "BEGIN" + NEWLINE + "-- EXPORTS <exports clause>;" + NEWLINE + "-- IMPORTS <import clause>;" + NEWLINE + "-- MODULE-BODY" + NEWLINE + NEWLINE + "END" + NEWLINE;

    private ASN1CodeSkeletons() {
    }

    public static void addSkeletonProposals(IDocument doc, int offset, ProposalCollector collector) {
        for (SkeletonTemplateProposal templateProposal : TEMPLATE_PROPOSALS) {
            collector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), skeletonImage);
        }
    }

    public static String getASN1ModuleWithEmptyBody(String moduleName) {
        StringBuilder buffer = new StringBuilder(moduleName);
        buffer.append(ASN1_MODULE_EMPTY);
        return buffer.toString();
    }

    public static String getASN1ModuleSkeleton(String moduleName) {
        StringBuilder buffer = new StringBuilder(moduleName);
        buffer.append(ASN1_MODULE_SKELETON);
        return buffer.toString();
    }
}

