/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Record_Of_Template;
import org.eclipse.titan.runtime.core.Restricted_Length_Template;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TtcnError;

public final class RecordOf_Match {
    private RecordOf_Match() {
    }

    public static boolean compare_set_of(Base_Type left_ptr, int left_size, Base_Type right_ptr, int right_size, compare_function_t compare_function) {
        if (left_size < 0 || right_size < 0 || left_ptr == null || right_ptr == null) {
            throw new TtcnError("Internal error: compare_set_of: invalid argument.");
        }
        if (left_size != right_size) {
            return false;
        }
        if (left_size == 0) {
            return true;
        }
        boolean[] covered = new boolean[left_size];
        int first_on_right = 0;
        int last_on_right = left_size - 1;
        for (int left_index = 0; left_index < left_size; ++left_index) {
            boolean pair_found = false;
            for (int right_index = first_on_right; right_index <= last_on_right; ++right_index) {
                if (covered[right_index] || !compare_function.compare(left_ptr, left_index, right_ptr, right_index)) continue;
                covered[right_index] = true;
                if (right_index == first_on_right) {
                    while (++first_on_right < last_on_right && covered[first_on_right]) {
                    }
                }
                if (right_index == last_on_right) {
                    while (--last_on_right > first_on_right && covered[last_on_right]) {
                    }
                }
                pair_found = true;
                break;
            }
            if (pair_found) continue;
            return false;
        }
        return true;
    }

    public static boolean match_array(Base_Type value_ptr, int value_size, Restricted_Length_Template template_ptr, int template_size, match_function_t match_function, boolean legacy) {
        int template_index;
        if (value_ptr == null || value_size < 0 || template_ptr == null || template_size < 0) {
            throw new TtcnError("Internal error: match_array: invalid argument.");
        }
        if (template_size == 0) {
            return value_size == 0;
        }
        if (value_size == 0) {
            for (template_index = 0; template_index < template_size && match_function.match(value_ptr, -1, template_ptr, template_index, legacy); ++template_index) {
            }
            return template_index == template_size;
        }
        int value_index = 0;
        int last_asterisk = -1;
        int last_value_to_asterisk = -1;
        while (true) {
            if (match_function.match(value_ptr, -1, template_ptr, template_index, legacy)) {
                last_asterisk = template_index++;
                last_value_to_asterisk = value_index;
            } else if (match_function.match(value_ptr, value_index, template_ptr, template_index, legacy)) {
                ++value_index;
                ++template_index;
            } else {
                if (last_asterisk == -1) {
                    return false;
                }
                template_index = last_asterisk + 1;
                value_index = ++last_value_to_asterisk;
            }
            if (value_index == value_size && template_index == template_size) {
                return true;
            }
            if (template_index == template_size) {
                if (match_function.match(value_ptr, -1, template_ptr, template_index - 1, legacy)) {
                    return true;
                }
                if (last_asterisk == -1) {
                    return false;
                }
                template_index = last_asterisk + 1;
                value_index = ++last_value_to_asterisk;
                continue;
            }
            if (value_index == value_size) break;
        }
        while (template_index < template_size && match_function.match(value_ptr, -1, template_ptr, template_index, legacy)) {
            ++template_index;
        }
        return template_index == template_size;
    }

    public static boolean match_set_of_internal(Base_Type value_ptr, int value_start, int value_size, Restricted_Length_Template template_ptr, int template_start, int template_size, match_function_t match_function, type_of_matching match_type, AtomicInteger number_of_uncovered, int[] pair_list, int number_of_checked, boolean legacy) {
        Matching_Table table = new Matching_Table(value_ptr, value_start, value_size, template_ptr, template_start, template_size, match_function, legacy);
        int real_template_size = table.get_template_size();
        if (match_type == type_of_matching.EXACT && real_template_size < template_size) {
            match_type = type_of_matching.SUPERSET;
        }
        if (match_type == type_of_matching.SUBSET && real_template_size < template_size) {
            return true;
        }
        if (match_type == type_of_matching.SUBSET && value_size > real_template_size) {
            return false;
        }
        if (match_type == type_of_matching.EXACT && value_size != real_template_size) {
            return false;
        }
        if (match_type == type_of_matching.SUPERSET && value_size < real_template_size) {
            return false;
        }
        if (real_template_size == 0) {
            if (template_size > 0) {
                return true;
            }
            return value_size == 0 || match_type == type_of_matching.SUPERSET;
        }
        table.create_matrix();
        if (pair_list != null) {
            for (int i = 0; i < template_size; ++i) {
                if (pair_list[i] < 0) continue;
                table.set_paired(i, pair_list[i]);
                table.set_covered(pair_list[i], i);
                table.set_edge(i, pair_list[i], edge_status.PAIRS);
            }
        }
        block1: for (int template_index = 0; template_index < real_template_size; ++template_index) {
            if (table.is_paired(template_index)) continue;
            boolean found_route = false;
            Tree_list tree = new Tree_list(template_index);
            int i = template_index;
            while (true) {
                int j;
                for (j = table.is_paired(i) ? table.get_paired(i) + 1 : number_of_checked; j < value_size; ++j) {
                    if (table.is_covered(j) || table.get_edge(i, j) != edge_status.EDGE) continue;
                    int new_value_index = j;
                    boolean at_end = false;
                    while (!at_end) {
                        at_end = tree.is_head();
                        int actual_node = tree.actual_data();
                        int temp_value_index = table.get_paired(actual_node);
                        if (temp_value_index != -1) {
                            table.set_edge(temp_value_index, actual_node, edge_status.EDGE);
                        }
                        table.set_paired(actual_node, new_value_index);
                        if (pair_list != null) {
                            pair_list[actual_node] = new_value_index;
                        }
                        table.set_edge(actual_node, new_value_index, edge_status.PAIRS);
                        table.set_covered(new_value_index, actual_node);
                        new_value_index = temp_value_index;
                        if (at_end) continue;
                        tree.back_step();
                    }
                    if (match_type == type_of_matching.SUBSET && table.get_nof_covered() == value_size) {
                        return true;
                    }
                    found_route = true;
                    break;
                }
                if (found_route) continue block1;
                for (j = 0; j < value_size; ++j) {
                    int temp_index;
                    if (!table.is_covered(j) || table.get_edge(i, j) != edge_status.EDGE || tree.do_exists(j + real_template_size) || tree.do_exists(temp_index = table.covered_by(j))) continue;
                    tree.insert_data(temp_index);
                }
                if (tree.end_of_list()) break;
                tree.step_forward();
                i = tree.actual_data();
            }
            if (match_type == type_of_matching.EXACT) {
                return false;
            }
            if (match_type != type_of_matching.SUPERSET || number_of_uncovered != null) continue;
            return false;
        }
        int number_of_pairs = table.get_nof_covered();
        if (match_type == type_of_matching.SUBSET) {
            return number_of_pairs == value_size;
        }
        if (match_type == type_of_matching.EXACT) {
            return true;
        }
        if (match_type == type_of_matching.SUPERSET) {
            if (number_of_uncovered != null && number_of_pairs != real_template_size) {
                number_of_uncovered.set(real_template_size - number_of_pairs);
                return false;
            }
            return true;
        }
        return false;
    }

    private static answer recursive_permutation_match(Base_Type value_ptr, int value_start_index, int value_size, Record_Of_Template template_ptr, int template_start_index, int template_size, int permutation_index, match_function_t match_function, AtomicInteger shift_size, boolean legacy) {
        boolean good;
        boolean permutation_begins;
        int nof_permutations = template_ptr.get_number_of_permutations();
        if (permutation_index > nof_permutations) {
            throw new TtcnError("Internal error: recursive_permutation_match: invalid argument.");
        }
        if (permutation_index < nof_permutations && template_ptr.get_permutation_end(permutation_index) > template_start_index + template_size) {
            throw new TtcnError(MessageFormat.format("Internal error: recursive_permutation_match: wrong permutation interval settings for permutation {0}.", permutation_index));
        }
        shift_size.set(0);
        if (template_size == 0) {
            if (value_size == 0) {
                return answer.SUCCESS;
            }
            return answer.FAILURE;
        }
        boolean bl = permutation_begins = permutation_index < nof_permutations && template_start_index == template_ptr.get_permutation_start(permutation_index);
        if (permutation_begins || match_function.match(value_ptr, -1, template_ptr, template_start_index, legacy)) {
            boolean already_superset;
            int largest_possible_size;
            boolean has_asterisk;
            int smallest_possible_size;
            int permutation_size;
            boolean is_asterisk;
            if (permutation_begins) {
                is_asterisk = false;
                permutation_size = template_ptr.get_permutation_size(permutation_index);
                smallest_possible_size = 0;
                has_asterisk = false;
                for (int i = 0; i < permutation_size; ++i) {
                    if (match_function.match(value_ptr, -1, template_ptr, i + template_start_index, legacy)) {
                        has_asterisk = true;
                        continue;
                    }
                    ++smallest_possible_size;
                }
                if (smallest_possible_size > value_size) {
                    return answer.NO_CHANCE;
                }
                if (has_asterisk) {
                    largest_possible_size = value_size;
                    already_superset = smallest_possible_size == 0;
                } else {
                    largest_possible_size = smallest_possible_size;
                    already_superset = false;
                }
            } else {
                is_asterisk = true;
                already_superset = true;
                permutation_size = 1;
                smallest_possible_size = 0;
                largest_possible_size = value_size;
                has_asterisk = true;
            }
            int temp_size = smallest_possible_size;
            int[] pair_list = null;
            int old_temp_size = 0;
            if (!already_superset) {
                pair_list = new int[permutation_size];
                for (int i = 0; i < permutation_size; ++i) {
                    pair_list[i] = -1;
                }
            }
            while (!already_superset) {
                AtomicInteger x = new AtomicInteger(0);
                boolean found = RecordOf_Match.match_set_of_internal(value_ptr, value_start_index, temp_size, template_ptr, template_start_index, permutation_size, match_function, type_of_matching.SUPERSET, x, pair_list, old_temp_size, legacy);
                if (found) {
                    already_superset = true;
                    continue;
                }
                if (has_asterisk && temp_size + x.get() <= largest_possible_size) {
                    old_temp_size = temp_size;
                    temp_size += x.get();
                    continue;
                }
                return answer.FAILURE;
            }
            if (permutation_size == template_size) {
                if (has_asterisk || value_size == temp_size) {
                    return answer.SUCCESS;
                }
                return answer.FAILURE;
            }
            int i = temp_size;
            while (i <= largest_possible_size) {
                answer result = is_asterisk ? RecordOf_Match.recursive_permutation_match(value_ptr, value_start_index + i, value_size - i, template_ptr, template_start_index + permutation_size, template_size - permutation_size, permutation_index, match_function, shift_size, legacy) : RecordOf_Match.recursive_permutation_match(value_ptr, value_start_index + i, value_size - i, template_ptr, template_start_index + permutation_size, template_size - permutation_size, permutation_index + 1, match_function, shift_size, legacy);
                if (result == answer.SUCCESS) {
                    return answer.SUCCESS;
                }
                if (result == answer.NO_CHANCE) {
                    return answer.NO_CHANCE;
                }
                if (i == value_size) {
                    return answer.NO_CHANCE;
                }
                if ((i += shift_size.get() > 1 ? shift_size.get() : 1) > largest_possible_size) {
                    shift_size.set(i - largest_possible_size);
                    continue;
                }
                shift_size.set(0);
            }
            return answer.FAILURE;
        }
        int distance = permutation_index < nof_permutations ? template_ptr.get_permutation_start(permutation_index) - template_start_index : template_size;
        if (value_size == 0) {
            return answer.FAILURE;
        }
        int i = 0;
        while ((good = match_function.match(value_ptr, value_start_index + i, template_ptr, template_start_index + i, legacy)) && ++i < value_size && i < distance && !match_function.match(value_ptr, -1, template_ptr, template_start_index + i, legacy)) {
        }
        if (good && (i == distance || match_function.match(value_ptr, -1, template_ptr, template_start_index + i, legacy))) {
            if (i == template_size) {
                if (i < value_size) {
                    return answer.FAILURE;
                }
                return answer.SUCCESS;
            }
            return RecordOf_Match.recursive_permutation_match(value_ptr, value_start_index + i, value_size - i, template_ptr, template_start_index + i, template_size - i, permutation_index, match_function, shift_size, legacy);
        }
        if (i == value_size) {
            return answer.NO_CHANCE;
        }
        shift_size.set(0);
        --i;
        do {
            good = match_function.match(value_ptr, value_start_index + i + shift_size.get(), template_ptr, template_start_index + i, legacy);
            shift_size.incrementAndGet();
        } while (!good && i + shift_size.get() < value_size);
        if (good) {
            shift_size.decrementAndGet();
            return answer.FAILURE;
        }
        return answer.NO_CHANCE;
    }

    public static boolean match_record_of(Base_Type value_ptr, int value_size, Record_Of_Template template_ptr, int template_size, match_function_t match_function, boolean legacy) {
        if (value_ptr == null || value_size < 0 || template_ptr == null || template_size < 0 || template_ptr.get_selection() != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("Internal error: match_record_of: invalid argument.");
        }
        int nof_permutations = template_ptr.get_number_of_permutations();
        if (nof_permutations == 0) {
            return RecordOf_Match.match_array(value_ptr, value_size, template_ptr, template_size, match_function, legacy);
        }
        if (nof_permutations == 1 && template_ptr.get_permutation_start(0) == 0 && template_ptr.get_permutation_end(0) == template_size - 1) {
            return RecordOf_Match.match_set_of(value_ptr, value_size, template_ptr, template_size, match_function, legacy);
        }
        AtomicInteger shift_size = new AtomicInteger(0);
        return RecordOf_Match.recursive_permutation_match(value_ptr, 0, value_size, template_ptr, 0, template_size, 0, match_function, shift_size, legacy) == answer.SUCCESS;
    }

    public static boolean match_set_of(Base_Type value_ptr, int value_size, Restricted_Length_Template template_ptr, int template_size, match_function_t match_function, boolean legacy) {
        if (value_ptr == null || value_size < 0 || template_ptr == null || template_size < 0) {
            throw new TtcnError("Internal error: match_set_of: invalid argument.");
        }
        type_of_matching match_type = type_of_matching.EXACT;
        switch (template_ptr.get_selection()) {
            case SPECIFIC_VALUE: {
                match_type = type_of_matching.EXACT;
                break;
            }
            case SUPERSET_MATCH: {
                match_type = type_of_matching.SUPERSET;
                break;
            }
            case SUBSET_MATCH: {
                match_type = type_of_matching.SUBSET;
                break;
            }
            default: {
                throw new TtcnError("Internal error: match_set_of: invalid matching type.");
            }
        }
        return RecordOf_Match.match_set_of_internal(value_ptr, 0, value_size, template_ptr, 0, template_size, match_function, match_type, null, null, 0, legacy);
    }

    public static void log_match_heuristics(Base_Type value_ptr, int value_size, Restricted_Length_Template template_ptr, int template_size, match_function_t match_function, log_function_t log_function, boolean legacy) {
        int i;
        int j;
        if (value_ptr == null || value_size < 0 || template_ptr == null || template_size < 0 || template_ptr.get_selection() != Base_Template.template_sel.SPECIFIC_VALUE) {
            throw new TtcnError("Internal error: log_match_heuristics: invalid argument.");
        }
        if (value_size == 0 && template_size == 0) {
            return;
        }
        if (!template_ptr.match_length(value_size)) {
            TTCN_Logger.log_event("Length restriction cannot be satisfied. ", new Object[0]);
            return;
        }
        int asterisks_found = 0;
        for (int i2 = 0; i2 < template_size; ++i2) {
            if (!match_function.match(value_ptr, -1, template_ptr, i2, legacy)) continue;
            ++asterisks_found;
        }
        if (value_size < template_size - asterisks_found) {
            TTCN_Logger.print_logmatch_buffer();
            if (asterisks_found == 0) {
                TTCN_Logger.log_event(MessageFormat.format(" Too few elements in value are present: {0} was expected instead of {1}", template_size, value_size), new Object[0]);
            } else {
                TTCN_Logger.log_event(MessageFormat.format(" Too few value elements are present in value: at least {0} was expected instead of {1}", template_size - asterisks_found, value_size), new Object[0]);
            }
            return;
        }
        if (asterisks_found == 0 && value_size > template_size) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event(MessageFormat.format(" Too many elements are present in value: {0} was expected instead of {1}", template_size, value_size), new Object[0]);
            return;
        }
        if (value_size == 0 || template_size == 0) {
            return;
        }
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT != TTCN_Logger.get_matching_verbosity()) {
            TTCN_Logger.log_event_str(" Some hints to find the reason of mismatch: ");
            TTCN_Logger.log_event_str("{ value elements that have no pairs in the template: ");
        }
        boolean value_found = false;
        int nof_unmatched_values = 0;
        boolean[] unmatched_values = new boolean[value_size];
        for (int i3 = 0; i3 < value_size; ++i3) {
            boolean pair_found = false;
            for (int j2 = 0; j2 < template_size; ++j2) {
                if (!match_function.match(value_ptr, i3, template_ptr, j2, legacy)) continue;
                pair_found = true;
                break;
            }
            boolean bl = unmatched_values[i3] = !pair_found;
            if (pair_found) continue;
            if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT != TTCN_Logger.get_matching_verbosity()) {
                if (value_found) {
                    TTCN_Logger.log_event_str(", ");
                } else {
                    value_found = true;
                }
                log_function.log(value_ptr, null, i3, 0, legacy);
                TTCN_Logger.log_event(MessageFormat.format(" at index {0}", i3), new Object[0]);
            }
            ++nof_unmatched_values;
        }
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT != TTCN_Logger.get_matching_verbosity()) {
            if (!value_found) {
                TTCN_Logger.log_event_str("none");
            }
            TTCN_Logger.log_event_str(", template elements that have no pairs in the value: ");
        }
        boolean template_found = false;
        int nof_unmatched_templates = 0;
        boolean[] unmatched_templates = new boolean[template_size];
        for (int i4 = 0; i4 < template_size; ++i4) {
            boolean pair_found = false;
            for (j = -1; j < value_size; ++j) {
                if (!match_function.match(value_ptr, j, template_ptr, i4, legacy)) continue;
                pair_found = true;
                break;
            }
            boolean bl = unmatched_templates[i4] = !pair_found;
            if (pair_found) continue;
            if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT != TTCN_Logger.get_matching_verbosity()) {
                if (template_found) {
                    TTCN_Logger.log_event_str(", ");
                } else {
                    template_found = true;
                }
                log_function.log(null, template_ptr, 0, i4, legacy);
                TTCN_Logger.log_event(MessageFormat.format(" at index {0}", i4), new Object[0]);
            }
            ++nof_unmatched_templates;
        }
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT != TTCN_Logger.get_matching_verbosity()) {
            if (!template_found) {
                TTCN_Logger.log_event_str("none");
            }
            TTCN_Logger.log_event_str(", matching value <-> template index pairs: ");
            boolean pair_found = false;
            for (i = 0; i < value_size; ++i) {
                for (j = 0; j < template_size; ++j) {
                    if (!match_function.match(value_ptr, i, template_ptr, j, legacy)) continue;
                    if (pair_found) {
                        TTCN_Logger.log_char(',');
                    } else {
                        TTCN_Logger.log_char('{');
                        pair_found = true;
                    }
                    TTCN_Logger.log_event(MessageFormat.format(" {0} <-> {1}", i, j), new Object[0]);
                }
            }
            if (pair_found) {
                TTCN_Logger.log_event_str(" }");
            } else {
                TTCN_Logger.log_event_str("none");
            }
        }
        if (nof_unmatched_templates > 0 && nof_unmatched_values > 0) {
            if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity()) {
                int previous_size = TTCN_Logger.get_logmatch_buffer_len();
                for (i = 0; i < value_size; ++i) {
                    if (!unmatched_values[i]) continue;
                    for (j = 0; j < template_size; ++j) {
                        if (!unmatched_templates[j]) continue;
                        TTCN_Logger.log_logmatch_info(MessageFormat.format("[{0} <-> {1}]", i, j), new Object[0]);
                        log_function.log(value_ptr, template_ptr, i, j, legacy);
                        TTCN_Logger.set_logmatch_buffer_len(previous_size);
                    }
                }
            } else {
                TTCN_Logger.log_event_str(", matching unmatched value <-> template index pairs: ");
                int sep = 123;
                for (i = 0; i < value_size; ++i) {
                    if (!unmatched_values[i]) continue;
                    for (j = 0; j < template_size; ++j) {
                        if (!unmatched_templates[j]) continue;
                        TTCN_Logger.log_event(MessageFormat.format("{0} {1} <-> {2}:'{' ", Character.valueOf((char)sep), i, j), new Object[0]);
                        if (123 == sep) {
                            sep = 44;
                        }
                        log_function.log(value_ptr, template_ptr, i, j, legacy);
                        TTCN_Logger.log_event_str(" }");
                    }
                }
                TTCN_Logger.log_event_str(" }");
            }
        }
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT != TTCN_Logger.get_matching_verbosity()) {
            TTCN_Logger.log_event_str(" }");
        }
    }

    private static class Tree_list {
        private final List_elem head = new List_elem();
        private List_elem current;

        public Tree_list(int head_data) {
            this.head.data = head_data;
            this.head.next = null;
            this.head.parent = null;
            this.current = this.head;
        }

        public void insert_data(int new_data) {
            List_elem newptr = new List_elem();
            newptr.data = new_data;
            newptr.next = this.current.next;
            newptr.parent = this.current;
            this.current.next = newptr;
        }

        public void back_step() {
            if (this.current.parent != null) {
                this.current = this.current.parent;
            }
        }

        public void step_forward() {
            if (this.current.next != null) {
                this.current = this.current.next;
            }
        }

        public int head_value() {
            return this.head.data;
        }

        public int actual_data() {
            return this.current.data;
        }

        public boolean is_head() {
            return this.current.parent == null;
        }

        public boolean end_of_list() {
            return this.current.next == null;
        }

        public boolean do_exists(int find_data) {
            List_elem ptr = this.head;
            while (ptr != null) {
                if (ptr.data == find_data) {
                    return true;
                }
                ptr = ptr.next;
            }
            return false;
        }

        private class List_elem {
            int data;
            List_elem next;
            List_elem parent;

            private List_elem() {
            }
        }
    }

    private static class Matching_Table {
        private final match_function_t match_function;
        private final int value_size;
        private final int value_start;
        private final int template_size;
        private final int template_start;
        private final int n_asterisks;
        private final int[] template_index_table;
        private edge_status[][] edge_matrix;
        private boolean[] covered_vector;
        private final boolean legacy;
        private int[] covered_index_vector;
        private int nof_covered;
        private int[] paired_templates;
        private final Base_Type value_ptr;
        private final Restricted_Length_Template template_ptr;

        public Matching_Table(Base_Type par_value_ptr, int par_value_start, int par_value_size, Restricted_Length_Template par_template_ptr, int par_template_start, int par_template_size, match_function_t par_match_function, boolean par_legacy) {
            this.match_function = par_match_function;
            this.value_size = par_value_size;
            this.value_start = par_value_start;
            this.template_start = par_template_start;
            this.value_ptr = par_value_ptr;
            this.template_ptr = par_template_ptr;
            this.legacy = par_legacy;
            this.nof_covered = 0;
            this.template_index_table = new int[par_template_size];
            int temp_n_asterisks = 0;
            for (int i = 0; i < par_template_size; ++i) {
                if (this.match_function.match(this.value_ptr, -1, this.template_ptr, par_template_start + i, this.legacy)) {
                    ++temp_n_asterisks;
                    continue;
                }
                this.template_index_table[i - temp_n_asterisks] = i;
            }
            this.n_asterisks = temp_n_asterisks;
            this.template_size = par_template_size - this.n_asterisks;
            this.edge_matrix = null;
            this.covered_vector = null;
            this.covered_index_vector = null;
            this.paired_templates = null;
        }

        public int get_template_size() {
            return this.template_size;
        }

        public boolean has_asterisk() {
            return this.n_asterisks > 0;
        }

        public void create_matrix() {
            int j;
            this.edge_matrix = new edge_status[this.template_size][this.value_size];
            for (int i = 0; i < this.template_size; ++i) {
                for (int j2 = 0; j2 < this.value_size; ++j2) {
                    this.edge_matrix[i][j2] = edge_status.UNKNOWN;
                }
            }
            this.covered_vector = new boolean[this.value_size];
            for (j = 0; j < this.value_size; ++j) {
                this.covered_vector[j] = false;
            }
            this.paired_templates = new int[this.template_size];
            for (j = 0; j < this.template_size; ++j) {
                this.paired_templates[j] = -1;
            }
            this.covered_index_vector = new int[this.value_size];
        }

        public edge_status get_edge(int template_index, int value_index) {
            if (this.edge_matrix[template_index][value_index] == edge_status.UNKNOWN) {
                this.edge_matrix[template_index][value_index] = this.match_function.match(this.value_ptr, this.value_start + value_index, this.template_ptr, this.template_start + this.template_index_table[template_index], this.legacy) ? edge_status.EDGE : edge_status.NO_EDGE;
            }
            return this.edge_matrix[template_index][value_index];
        }

        public void set_edge(int template_index, int value_index, edge_status new_status) {
            this.edge_matrix[template_index][value_index] = new_status;
        }

        public boolean is_covered(int value_index) {
            return this.covered_vector[value_index];
        }

        public int covered_by(int value_index) {
            return this.covered_index_vector[value_index];
        }

        public int get_nof_covered() {
            return this.nof_covered;
        }

        public void set_covered(int value_index, int template_index) {
            if (!this.covered_vector[value_index]) {
                ++this.nof_covered;
            }
            this.covered_vector[value_index] = true;
            this.covered_index_vector[value_index] = template_index;
        }

        public boolean is_paired(int j) {
            return this.paired_templates[j] != -1;
        }

        public void set_paired(int j, int i) {
            this.paired_templates[j] = i;
        }

        public int get_paired(int j) {
            return this.paired_templates[j];
        }
    }

    private static enum edge_status {
        UNKNOWN,
        NO_EDGE,
        EDGE,
        PAIRS;

    }

    public static enum type_of_matching {
        SUBSET,
        EXACT,
        SUPERSET;

    }

    public static enum answer {
        FAILURE,
        SUCCESS,
        NO_CHANCE;

    }

    public static interface log_function_t {
        public void log(Base_Type var1, Restricted_Length_Template var2, int var3, int var4, boolean var5);
    }

    public static interface compare_function_t {
        public boolean compare(Base_Type var1, int var2, Base_Type var3, int var4);
    }

    public static interface match_function_t {
        public boolean match(Base_Type var1, int var2, Restricted_Length_Template var3, int var4, boolean var5);
    }
}

