/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.provider;

import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.util.JUnitPlugin;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class TestKindProvider {
    private static Map<IJavaProject, List<TestKind>> map = new HashMap<IJavaProject, List<TestKind>>();
    private static final String JUNIT4_TEST = "org.junit.Test";
    private static final String JUNIT5_TEST = "org.junit.jupiter.api.Test";
    private static final String TESTNG_TEST = "org.testng.annotations.Test";

    public static void updateTestKinds(IJavaProject javaProject) {
        map.put(javaProject, TestKindProvider.getTestKinds(javaProject));
    }

    public static List<TestKind> getTestKindsFromCache(IJavaProject javaProject) {
        List<TestKind> kinds = map.get(javaProject);
        if (kinds == null) {
            kinds = TestKindProvider.getTestKinds(javaProject);
            map.put(javaProject, kinds);
        }
        return kinds;
    }

    private static List<TestKind> getTestKinds(IJavaProject javaProject) {
        LinkedList<TestKind> result = new LinkedList<TestKind>();
        try {
            if (CoreTestSearchEngine.hasJUnit6TestAnnotation((IJavaProject)javaProject)) {
                result.add(TestKind.JUnit6);
            } else if (CoreTestSearchEngine.hasJUnit5TestAnnotation((IJavaProject)javaProject)) {
                result.add(TestKind.JUnit5);
            }
            if (javaProject.findType(JUNIT4_TEST) != null) {
                result.add(TestKind.JUnit);
            }
            if (javaProject.findType(TESTNG_TEST) != null) {
                result.add(TestKind.TestNG);
            }
        }
        catch (JavaModelException e) {
            JUnitPlugin.logError("failed to find the test kinds from project: " + javaProject.getElementName());
        }
        return result;
    }
}

