/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.builder.SourceFile;
import org.eclipse.jdt.internal.javac.AccessRestrictionTreeScanner;
import org.eclipse.jdt.internal.javac.JavacClassFile;
import org.eclipse.jdt.internal.javac.JavacCompilationResult;
import org.eclipse.jdt.internal.javac.JavacCompiler;
import org.eclipse.jdt.internal.javac.JavacConfig;
import org.eclipse.jdt.internal.javac.UnusedTreeScanner;
import org.eclipse.jdt.internal.javac.problem.UnusedProblemFactory;

public class JavacCompilerTaskListener
implements TaskListener {
    private Map<ICompilationUnit, JavacCompilationResult> results = new HashMap<ICompilationUnit, JavacCompilationResult>();
    private IProblemFactory problemFactory;
    private UnusedProblemFactory unusedProblemFactory;
    private JavacConfig config;
    private final Map<JavaFileObject, ICompilationUnit> fileObjectToCUMap;
    private final JavacCompiler javacCompiler;
    public final Path tempDir;
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("byte", "short", "int", "long", "float", "double", "char", "boolean"));
    private static final char[] MODULE_INFO_NAME = "module-info".toCharArray();

    public JavacCompilerTaskListener(JavacCompiler javacCompiler, JavacConfig config, IProblemFactory problemFactory, Map<JavaFileObject, ICompilationUnit> fileObjectToCUMap) {
        this.javacCompiler = javacCompiler;
        this.config = config;
        this.problemFactory = problemFactory;
        this.unusedProblemFactory = new UnusedProblemFactory(problemFactory, config.compilerOptions());
        this.fileObjectToCUMap = fileObjectToCUMap;
        Path dir = null;
        try {
            dir = Files.createTempDirectory("javac-build", new FileAttribute[0]);
        }
        catch (IOException e) {
            ILog.get().error(e.getMessage(), (Throwable)e);
        }
        this.tempDir = dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() == TaskEvent.Kind.GENERATE) {
            TypeElement typeElement;
            JavaFileObject file = e.getSourceFile();
            ICompilationUnit cu = this.fileObjectToCUMap.get(file);
            if (cu == null && (typeElement = e.getTypeElement()) instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)typeElement;
                if (this.isGeneratedSource(file)) {
                    try {
                        this.writeClassFile(clazz);
                        return;
                    }
                    catch (CoreException coreException) {
                        return;
                    }
                }
            }
            if (cu == null) return;
            typeElement = e.getTypeElement();
            if (!(typeElement instanceof Symbol.ClassSymbol)) return;
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)typeElement;
            JavacClassFile classFile = this.getJavacClassFile(clazz);
            JavacCompilationResult resultForCU = this.results.computeIfAbsent(cu, JavacCompilationResult::new);
            if (resultForCU.compiledTypes.values().contains((Object)classFile)) return;
            resultForCU.record(clazz.flatName().toString().replace('.', '/').toCharArray(), classFile);
            return;
        }
        if (e.getKind() != TaskEvent.Kind.ANALYZE) return;
        JavaFileObject file = e.getSourceFile();
        final ICompilationUnit cu = this.fileObjectToCUMap.get(file);
        if (cu == null) {
            return;
        }
        final JavacCompilationResult result = this.results.computeIfAbsent(cu, JavacCompilationResult::new);
        final HashMap visitedClasses = new HashMap();
        final HashSet hierarchyRecorded = new HashSet();
        final TypeElement currentTopLevelType = e.getTypeElement();
        UnusedTreeScanner<Void, Void> scanner = new UnusedTreeScanner<Void, Void>(this){
            final /* synthetic */ JavacCompilerTaskListener this$0;
            {
                JavacCompilerTaskListener javacCompilerTaskListener = this$0;
                Objects.requireNonNull(javacCompilerTaskListener);
                this.this$0 = javacCompilerTaskListener;
            }

            @Override
            public Void visitModule(ModuleTree node, Void p) {
                if (node instanceof JCTree.JCModuleDecl) {
                    JCTree.JCModuleDecl moduleDecl = (JCTree.JCModuleDecl)node;
                    IContainer expectedOutputDir = this.this$0.computeOutputDirectory(cu);
                    JavacClassFile currentClass = new JavacClassFile(moduleDecl, expectedOutputDir, this.this$0.tempDir);
                    result.record(MODULE_INFO_NAME, currentClass);
                }
                return (Void)super.visitModule(node, p);
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                if (node instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
                    if (Objects.equals(currentTopLevelType, classDecl.sym) || !(classDecl.sym.owner instanceof Symbol.PackageSymbol)) {
                        String fullName = classDecl.sym.flatName().toString();
                        String compoundName = fullName.replace('.', '/');
                        Symbol enclosingClassSymbol = this.getEnclosingClass(classDecl.sym);
                        ClassFile enclosingClassFile = enclosingClassSymbol == null ? null : (ClassFile)visitedClasses.get(enclosingClassSymbol);
                        IContainer expectedOutputDir = this.this$0.computeOutputDirectory(cu);
                        JavacClassFile currentClass = new JavacClassFile(fullName, enclosingClassFile, expectedOutputDir, this.this$0.tempDir);
                        visitedClasses.put(classDecl.sym, currentClass);
                        result.record(compoundName.toCharArray(), currentClass);
                        this.recordTypeHierarchy(classDecl.sym);
                    } else {
                        return null;
                    }
                }
                return (Void)super.visitClass(node, p);
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                if (node instanceof JCTree.JCIdent) {
                    JCTree.JCIdent id = (JCTree.JCIdent)node;
                    Symbol symbol = id.sym;
                    if (symbol instanceof Symbol.TypeSymbol) {
                        Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)symbol;
                        String qualifiedName = typeSymbol.getQualifiedName().toString();
                        this.recordQualifiedReference(qualifiedName, false);
                    }
                }
                return (Void)super.visitIdentifier(node, p);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void p) {
                if (node instanceof JCTree.JCFieldAccess) {
                    JCTree.JCFieldAccess field = (JCTree.JCFieldAccess)node;
                    if (field.sym != null && !(field.type instanceof Type.MethodType) && !"<any?>".equals(field.type.toString())) {
                        this.recordQualifiedReference(node.toString(), false);
                        if (field.sym instanceof Symbol.VarSymbol) {
                            Symbol.TypeSymbol elementSymbol = field.type.tsym;
                            Type type = field.type;
                            if (type instanceof Type.ArrayType) {
                                Type.ArrayType arrayType = (Type.ArrayType)type;
                                elementSymbol = this.getElementType(arrayType);
                            }
                            if (elementSymbol instanceof Symbol.ClassSymbol) {
                                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)elementSymbol;
                                this.recordQualifiedReference(classSymbol.className(), true);
                            }
                        }
                    }
                }
                return (Void)super.visitMemberSelect(node, p);
            }

            private Symbol getEnclosingClass(Symbol symbol) {
                while (symbol != null) {
                    if (symbol.owner instanceof Symbol.ClassSymbol) {
                        return symbol.owner;
                    }
                    if (symbol.owner instanceof Symbol.PackageSymbol) {
                        return null;
                    }
                    symbol = symbol.owner;
                }
                return null;
            }

            private Symbol.TypeSymbol getElementType(Type.ArrayType arrayType) {
                Type type = arrayType.elemtype;
                if (type instanceof Type.ArrayType) {
                    Type.ArrayType subArrayType = (Type.ArrayType)type;
                    return this.getElementType(subArrayType);
                }
                return arrayType.elemtype.tsym;
            }

            private void recordQualifiedReference(String qualifiedName, boolean recursive) {
                if (PRIMITIVE_TYPES.contains(qualifiedName)) {
                    return;
                }
                String[] nameParts = qualifiedName.split("\\.");
                int length = nameParts.length;
                if (length == 1) {
                    result.addRootReference(nameParts[0]);
                    result.addSimpleNameReference(nameParts[0]);
                    return;
                }
                if (!recursive) {
                    result.addRootReference(nameParts[0]);
                    result.addSimpleNameReference(nameParts[length - 1]);
                    result.addQualifiedReference(nameParts);
                } else {
                    result.addRootReference(nameParts[0]);
                    while (result.addQualifiedReference(Arrays.copyOfRange(nameParts, 0, length))) {
                        if (length == 2) {
                            result.addSimpleNameReference(nameParts[0]);
                            result.addSimpleNameReference(nameParts[1]);
                            return;
                        }
                        result.addSimpleNameReference(nameParts[--length]);
                    }
                }
            }

            private void recordTypeHierarchy(Symbol.ClassSymbol classSymbol) {
                if (hierarchyRecorded.contains(classSymbol)) {
                    return;
                }
                hierarchyRecorded.add(classSymbol);
                Type superClass = classSymbol.getSuperclass();
                Symbol.TypeSymbol typeSymbol = superClass.tsym;
                if (typeSymbol instanceof Symbol.ClassSymbol) {
                    Symbol.ClassSymbol superClassType = (Symbol.ClassSymbol)typeSymbol;
                    this.recordQualifiedReference(superClassType.className(), true);
                    this.recordTypeHierarchy(superClassType);
                }
                for (Type superInterface : classSymbol.getInterfaces()) {
                    Symbol.TypeSymbol typeSymbol2 = superInterface.tsym;
                    if (!(typeSymbol2 instanceof Symbol.ClassSymbol)) continue;
                    Symbol.ClassSymbol superInterfaceType = (Symbol.ClassSymbol)typeSymbol2;
                    this.recordQualifiedReference(superInterfaceType.className(), true);
                    this.recordTypeHierarchy(superInterfaceType);
                }
            }
        };
        CompilationUnitTree unit = e.getCompilationUnit();
        try {
            scanner.scan(unit, null);
        }
        catch (Exception ex) {
            ILog.get().error("Internal error when visiting the AST Tree. " + ex.getMessage(), (Throwable)ex);
        }
        AccessRestrictionTreeScanner accessRestrictionScanner = new AccessRestrictionTreeScanner(this.javacCompiler.lookupEnvironment.nameEnvironment, this.problemFactory, this.javacCompiler.options);
        accessRestrictionScanner.scan((Tree)unit, null);
        result.addUnusedMembers(scanner.getUnusedPrivateMembers(this.unusedProblemFactory));
        result.setUnusedImports(scanner.getUnusedImports(this.unusedProblemFactory));
        result.addUnnecessaryCasts(scanner.getUnnecessaryCasts(this.unusedProblemFactory));
        result.addNoEffectAssignments(scanner.getNoEffectAssignments(this.unusedProblemFactory));
        result.setAccessRestrictionProblems(accessRestrictionScanner.getAccessRestrictionProblems());
    }

    private JavacClassFile getJavacClassFile(Symbol.ClassSymbol clazz) {
        JavacClassFile javacClassFile;
        JavacCompilationResult result;
        if (clazz.sourcefile == null) {
            return null;
        }
        ICompilationUnit cu = this.fileObjectToCUMap.get(clazz.sourcefile);
        if (cu != null && (result = this.results.get(cu)) != null) {
            JavacClassFile existing = Arrays.stream(result.getClassFiles()).filter(JavacClassFile.class::isInstance).map(JavacClassFile.class::cast).filter(other -> Objects.equals(other.fullName, clazz.flatName().toString())).findAny().orElse(null);
            if (existing != null) {
                return existing;
            }
        }
        String string = clazz.flatName().toString();
        Element element = clazz.getEnclosingElement();
        if (element instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol enclosing = (Symbol.ClassSymbol)element;
            javacClassFile = this.getJavacClassFile(enclosing);
        } else {
            javacClassFile = null;
        }
        return new JavacClassFile(string, javacClassFile, this.computeOutputDirectory(cu), this.tempDir);
    }

    private boolean isGeneratedSource(JavaFileObject file) {
        List generatedSourcePaths = this.config.originalConfig().generatedSourcePaths();
        if (generatedSourcePaths == null || generatedSourcePaths.isEmpty()) {
            return false;
        }
        URI uri = file.toUri();
        if (uri != null && uri.getPath() != null) {
            File ioFile = new File(uri.getPath());
            Path fileIOPath = ioFile.toPath();
            return generatedSourcePaths.stream().anyMatch(container -> {
                IPath location = container.getRawLocation();
                if (location != null) {
                    Path locationIOPath = location.toPath();
                    return fileIOPath.startsWith(locationIOPath);
                }
                return false;
            });
        }
        return false;
    }

    private void writeClassFile(Symbol.ClassSymbol clazz) throws CoreException {
        ICompilationUnit cu = this.fileObjectToCUMap.get(clazz.sourcefile);
        String qualifiedName = clazz.flatName().toString().replace('.', '/');
        JavacClassFile javaClassFile = new JavacClassFile(qualifiedName, null, this.computeOutputDirectory(cu), this.tempDir);
        javaClassFile.flushTempToOutput();
    }

    @Override
    public void started(TaskEvent e) {
        this.javacCompiler.reportProgress(e.toString());
        TaskListener.super.started(e);
    }

    public Map<ICompilationUnit, JavacCompilationResult> getResults() {
        return this.results;
    }

    private IContainer computeOutputDirectory(ICompilationUnit unit) {
        if (unit instanceof SourceFile) {
            SourceFile sf = (SourceFile)unit;
            for (IContainer sourceDirectory = sf.resource.getParent(); sourceDirectory != null; sourceDirectory = sourceDirectory.getParent()) {
                IContainer mappedOutput = this.config.sourceOutputMapping().get(sourceDirectory);
                if (mappedOutput == null) continue;
                return mappedOutput;
            }
        }
        return null;
    }
}

