/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.gradle.api.GradleException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.util.internal.CollectionUtils;

public class JavaMethod<T, R> {
    private final Method method;
    private final Class<R> returnType;

    public static <T, R> JavaMethod<T, R> of(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        return new JavaMethod<T, R>(target, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> ofStatic(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        return new JavaMethod<T, R>(target, returnType, name, true, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> of(T target, Class<R> returnType, String name, Class<?> ... paramTypes) throws NoSuchMethodException {
        Class<?> targetClass = target.getClass();
        return JavaMethod.of(targetClass, returnType, name, paramTypes);
    }

    public static <T, R> JavaMethod<T, R> of(Class<R> returnType, Method method) throws NoSuchMethodException {
        return new JavaMethod<T, R>(returnType, method);
    }

    public JavaMethod(Class<T> target, Class<R> returnType, String name, boolean allowStatic, Class<?> ... paramTypes) {
        this(returnType, JavaMethod.findMethod(target, name, allowStatic, paramTypes));
    }

    public JavaMethod(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        this(target, returnType, name, false, paramTypes);
    }

    public JavaMethod(Class<R> returnType, Method method) {
        this.returnType = returnType;
        this.method = method;
        method.setAccessible(true);
    }

    private static Method findMethod(Class<?> target, String name, boolean allowStatic, Class<?>[] paramTypes) {
        Method method = JavaMethod.findMethodFrom(target.getMethods(), name, allowStatic, paramTypes);
        if (method == null) {
            method = JavaMethod.findDeclaredMethod(target, name, allowStatic, paramTypes);
        }
        if (method != null) {
            return method;
        }
        throw new NoSuchMethodException(String.format("Could not find method %s(%s) on %s.", name, CollectionUtils.join(", ", paramTypes), target.getSimpleName()));
    }

    private static @Nullable Method findDeclaredMethod(Class<?> origTarget, String name, boolean allowStatic, Class<?>[] paramTypes) {
        for (Class<?> target = origTarget; target != null; target = target.getSuperclass()) {
            Method method = JavaMethod.findMethodFrom(target.getDeclaredMethods(), name, allowStatic, paramTypes);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static @Nullable Method findMethodFrom(Method[] methods, String name, boolean allowStatic, Class<?>[] paramTypes) {
        for (Method method : methods) {
            if (!allowStatic && Modifier.isStatic(method.getModifiers()) || !method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), paramTypes)) continue;
            return method;
        }
        return null;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public R invokeStatic(Object ... args) {
        return this.invoke(null, args);
    }

    public R invoke(@Nullable T target, Object ... args) {
        try {
            Object result = this.method.invoke(target, args);
            return this.returnType.cast(result);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), target), e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }

    public String toString() {
        return this.method.toString();
    }
}

