/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class InlineValueHandler {
    public static InlineVariable[] resolveInlineVariables(InlineParams params, IProgressMonitor monitor) {
        ITypeRoot root = JDTUtils.resolveTypeRoot((String)params.uri);
        try {
            if (root == null || root.getBuffer() == null) {
                return new InlineVariable[0];
            }
            Position stoppedLocation = params.stoppedLocation.getStart();
            int stoppedOffset = JsonRpcHelpers.toOffset((IBuffer)root.getBuffer(), (int)stoppedLocation.getLine(), (int)stoppedLocation.getCharacter());
            IMethod enclosingMethod = InlineValueHandler.findEnclosingMethod(root, stoppedOffset);
            if (enclosingMethod == null) {
                return new InlineVariable[0];
            }
            Position startLocation = InlineValueHandler.getPosition(root.getBuffer(), enclosingMethod.getSourceRange().getOffset());
            Range stoppedRange = new Range(startLocation, stoppedLocation);
            if (params.viewPort != null && (params.viewPort.getEnd().getLine() < startLocation.getLine() || params.viewPort.getStart().getLine() > stoppedLocation.getLine())) {
                return new InlineVariable[0];
            }
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST(root, CoreASTProvider.WAIT_YES, monitor);
            VariableVisitor visitor = new VariableVisitor(astRoot, stoppedRange, params.viewPort, Flags.isStatic((int)enclosingMethod.getFlags()));
            astRoot.accept((ASTVisitor)visitor);
            InlineVariable[] result = visitor.getInlineVariables();
            return result;
        }
        catch (JavaModelException javaModelException) {
            return new InlineVariable[0];
        }
    }

    private static IMethod findEnclosingMethod(ITypeRoot root, int stoppedOffset) throws JavaModelException {
        int n;
        int n2;
        IType[] iTypeArray;
        IType enclosingType = null;
        if (root instanceof ICompilationUnit) {
            IType[] types;
            iTypeArray = types = ((ICompilationUnit)root).getAllTypes();
            n2 = types.length;
            n = 0;
            while (n < n2) {
                IType type = iTypeArray[n];
                if (InlineValueHandler.isEnclosed((ISourceReference)type, stoppedOffset)) {
                    enclosingType = type;
                }
                ++n;
            }
        } else if (root instanceof IClassFile) {
            enclosingType = ((IClassFile)root).getType();
        }
        if (enclosingType == null) {
            return null;
        }
        IType enclosingMethod = null;
        iTypeArray = enclosingType.getMethods();
        n2 = iTypeArray.length;
        n = 0;
        while (n < n2) {
            IType method = iTypeArray[n];
            if (InlineValueHandler.isEnclosed((ISourceReference)method, stoppedOffset)) {
                enclosingMethod = method;
                break;
            }
            ++n;
        }
        if (enclosingMethod == null) {
            return null;
        }
        return InlineValueHandler.findMethodInLocalTypes(enclosingMethod, stoppedOffset);
    }

    private static boolean isEnclosed(ISourceReference sourceReference, int offset) throws JavaModelException {
        ISourceRange sourceRange = sourceReference.getSourceRange();
        return sourceRange != null && offset >= sourceRange.getOffset() && offset < sourceRange.getOffset() + sourceRange.getLength();
    }

    private static IMethod findMethodInLocalTypes(IMethod enclosingMethod, int stoppedOffset) throws JavaModelException {
        if (enclosingMethod == null) {
            return null;
        }
        IJavaElement[] iJavaElementArray = enclosingMethod.getChildren();
        int n = iJavaElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElement element = iJavaElementArray[n2];
            if (element instanceof IType && InlineValueHandler.isEnclosed((ISourceReference)((IType)element), stoppedOffset)) {
                IMethod[] iMethodArray = ((IType)element).getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    if (InlineValueHandler.isEnclosed((ISourceReference)method, stoppedOffset)) {
                        IMethod nearerMethod = InlineValueHandler.findMethodInLocalTypes(method, stoppedOffset);
                        return nearerMethod == null ? enclosingMethod : nearerMethod;
                    }
                    ++n4;
                }
                break;
            }
            ++n2;
        }
        return enclosingMethod;
    }

    private static Position getPosition(IBuffer buffer, int offset) {
        int[] result = JsonRpcHelpers.toLine((IBuffer)buffer, (int)offset);
        if (result == null || result.length < 1) {
            return new Position(-1, -1);
        }
        return new Position(result[0], result[1]);
    }

    static enum InlineKind {
        VariableLookup,
        Evaluation;

    }

    static class InlineParams {
        String uri;
        Range viewPort;
        Range stoppedLocation;

        InlineParams() {
        }
    }

    static class InlineVariable {
        Range range;
        String name;
        InlineKind kind;
        String expression;
        String declaringClass;

        public InlineVariable(Range range, String name, InlineKind kind) {
            this.range = range;
            this.name = name;
            this.kind = kind;
        }

        public InlineVariable(Range range, String name, InlineKind kind, String declaringClass) {
            this.range = range;
            this.name = name;
            this.kind = kind;
            this.declaringClass = declaringClass;
        }
    }

    static class Token {
        String name;
        Position position;
        String declaringClass = null;

        public Token(String name, Position position) {
            this.name = name;
            this.position = position;
        }

        public Token(String name, Position position, String declaringClass) {
            this.name = name;
            this.position = position;
            this.declaringClass = declaringClass;
        }

        public int hashCode() {
            return Objects.hash(this.declaringClass, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Token)) {
                return false;
            }
            Token other = (Token)obj;
            return Objects.equals(this.declaringClass, other.declaringClass) && Objects.equals(this.name, other.name);
        }
    }

    static class VariableVisitor
    extends ASTVisitor {
        private CompilationUnit unit = null;
        private Range stoppedSourceRange;
        private Range viewPort;
        private boolean isStoppingAtStaticMethod;
        private int baseLine;
        private Set<Token>[] tokens;
        private List<String> localVarDecls = new ArrayList<String>();
        private List<Position> localVarDeclPositions = new ArrayList<Position>();
        private boolean isStoppingAtLambda = false;
        private Set<String> varDeclsAtLastLine = new HashSet<String>();
        private Range visibleInlineRange = null;

        public VariableVisitor(CompilationUnit unit, Range stoppedSourceRange, Range viewPort, boolean stopAtStaticMethod) {
            this.unit = unit;
            this.stoppedSourceRange = stoppedSourceRange;
            this.viewPort = viewPort;
            this.isStoppingAtStaticMethod = stopAtStaticMethod;
            this.baseLine = stoppedSourceRange.getStart().getLine();
            this.tokens = new Set[stoppedSourceRange.getEnd().getLine() - stoppedSourceRange.getStart().getLine() + 1];
            this.updateVisibleRange();
        }

        private void updateVisibleRange() {
            if (this.viewPort == null) {
                this.visibleInlineRange = this.stoppedSourceRange;
            } else if (this.compare(this.viewPort.getStart(), this.stoppedSourceRange.getEnd()) > 0 || this.compare(this.viewPort.getEnd(), this.stoppedSourceRange.getStart()) < 0) {
                this.visibleInlineRange = null;
            } else {
                Position start = this.compare(this.viewPort.getStart(), this.stoppedSourceRange.getStart()) >= 0 ? this.viewPort.getStart() : this.stoppedSourceRange.getStart();
                Position end = this.compare(this.viewPort.getEnd(), this.stoppedSourceRange.getEnd()) <= 0 ? this.viewPort.getEnd() : this.stoppedSourceRange.getEnd();
                this.visibleInlineRange = new Range(start, end);
            }
        }

        public boolean visit(SimpleName node) {
            if (this.visibleInlineRange == null) {
                return false;
            }
            Position startPosition = this.getStartPosition((ASTNode)node);
            boolean isAtLastLine = this.isAtStopLocation(startPosition);
            if (this.isEnclosed(this.visibleInlineRange, startPosition) || isAtLastLine) {
                IBinding binding = node.resolveBinding();
                if (!(binding instanceof IVariableBinding)) {
                    return false;
                }
                if (isAtLastLine && this.varDeclsAtLastLine.contains(binding.getKey())) {
                    return false;
                }
                String declaringClass = null;
                if (((IVariableBinding)binding).isField()) {
                    ITypeBinding typeBinding = ((IVariableBinding)binding).getDeclaringClass();
                    if (typeBinding == null) {
                        return false;
                    }
                    declaringClass = typeBinding.getBinaryName();
                }
                Token token = new Token(node.getIdentifier(), startPosition, declaringClass);
                int index = startPosition.getLine() - this.baseLine;
                if (this.tokens[index] == null) {
                    this.tokens[index] = new LinkedHashSet<Token>();
                }
                if (!this.tokens[index].contains(token)) {
                    this.tokens[index].add(token);
                }
            }
            return false;
        }

        public boolean visit(VariableDeclarationFragment node) {
            IVariableBinding binding;
            SimpleName name = node.getName();
            Position startPosition = this.getStartPosition((ASTNode)name);
            if (this.isEnclosed(this.stoppedSourceRange, startPosition)) {
                this.localVarDecls.add(name.getIdentifier());
                this.localVarDeclPositions.add(startPosition);
            }
            if (this.isAtStopLocation(startPosition) && (binding = node.resolveBinding()) != null) {
                this.varDeclsAtLastLine.add(binding.getKey());
            }
            return true;
        }

        public boolean visit(SingleVariableDeclaration node) {
            SimpleName name = node.getName();
            Position startPosition = this.getStartPosition((ASTNode)name);
            if (this.isEnclosed(this.stoppedSourceRange, startPosition)) {
                this.localVarDecls.add(name.getIdentifier());
                this.localVarDeclPositions.add(startPosition);
            }
            return false;
        }

        public boolean visit(LambdaExpression node) {
            Position startPosition = this.getStartPosition((ASTNode)node);
            Position endPosition = this.getEndPosition((ASTNode)node);
            if (this.compare(startPosition, this.stoppedSourceRange.getStart()) >= 0 && this.isEnclosed(new Range(startPosition, endPosition), this.stoppedSourceRange.getEnd())) {
                this.stoppedSourceRange.setStart(startPosition);
                this.updateVisibleRange();
                this.isStoppingAtLambda = true;
                this.localVarDecls.clear();
                this.localVarDeclPositions.clear();
                return true;
            }
            return super.visit(node);
        }

        public boolean visit(MethodDeclaration node) {
            Position startPosition = this.getStartPosition((ASTNode)node);
            Position endPosition = this.getEndPosition((ASTNode)node);
            return this.compare(startPosition, this.stoppedSourceRange.getStart()) <= 0 && this.compare(endPosition, this.stoppedSourceRange.getEnd()) >= 0;
        }

        public boolean visit(Block node) {
            return !this.isUnreachableNode((ASTNode)node);
        }

        public boolean visit(DoStatement node) {
            if (this.isUnreachableNode((ASTNode)node) && !this.isAtStopLocation((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(ForStatement node) {
            if (this.isUnreachableNode((ASTNode)node) && !this.isAtStopLocation((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(IfStatement node) {
            if (this.isUnreachableNode((ASTNode)node) && !this.isAtStopLocation((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(SwitchStatement node) {
            if (this.isUnreachableNode((ASTNode)node) && !this.isAtStopLocation((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(WhileStatement node) {
            if (this.isUnreachableNode((ASTNode)node) && !this.isAtStopLocation((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            if (this.isUnreachableNode((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(AnonymousClassDeclaration node) {
            if (this.isUnreachableNode((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(TypeDeclarationStatement node) {
            if (this.isUnreachableNode((ASTNode)node)) {
                return false;
            }
            return super.visit(node);
        }

        public boolean visit(ImportDeclaration node) {
            return false;
        }

        public boolean visit(ModuleDeclaration node) {
            return false;
        }

        public boolean visit(PackageDeclaration node) {
            return false;
        }

        public boolean visit(QualifiedName node) {
            return Objects.equals("length", node.getName().getIdentifier());
        }

        public boolean visit(QualifiedType node) {
            return false;
        }

        public InlineVariable[] getInlineVariables() {
            if (this.visibleInlineRange == null) {
                return new InlineVariable[0];
            }
            int i = 0;
            while (i < this.localVarDecls.size()) {
                String name = this.localVarDecls.get(i);
                Position position = this.localVarDeclPositions.get(i);
                if (this.isEnclosed(this.visibleInlineRange, position)) {
                    Token token;
                    int index = position.getLine() - this.baseLine;
                    if (this.tokens[index] == null) {
                        this.tokens[index] = new LinkedHashSet<Token>();
                    }
                    if (!this.tokens[index].contains(token = new Token(name, position, null))) {
                        this.tokens[index].add(token);
                    }
                }
                ++i;
            }
            int capturedArgIndexInLambda = this.isStoppingAtStaticMethod ? 1 : 2;
            HashMap<String, String> capturedVarsInLambda = new HashMap<String, String>();
            ArrayList<InlineVariable> result = new ArrayList<InlineVariable>();
            int i2 = 0;
            while (i2 < this.tokens.length) {
                int line = this.baseLine + i2;
                if (this.tokens[i2] != null && line >= this.visibleInlineRange.getStart().getLine()) {
                    for (Token token : this.tokens[i2]) {
                        int declIndex;
                        Position declPosition;
                        if (!this.isEnclosed(this.visibleInlineRange, token.position) && !this.isAtLastVisibleLine(token.position)) continue;
                        if (token.declaringClass == null && this.localVarDecls.contains(token.name) && this.compare(token.position, declPosition = this.localVarDeclPositions.get(declIndex = this.localVarDecls.lastIndexOf(token.name))) >= 0) {
                            result.add(new InlineVariable(new Range(token.position, token.position), token.name, InlineKind.VariableLookup));
                            continue;
                        }
                        InlineVariable value = new InlineVariable(new Range(token.position, token.position), token.name, InlineKind.Evaluation, token.declaringClass);
                        if (this.isStoppingAtLambda && token.declaringClass == null) {
                            if (capturedVarsInLambda.containsKey(token.name)) {
                                value.expression = (String)capturedVarsInLambda.get(token.name);
                            } else {
                                value.expression = "arg$" + capturedArgIndexInLambda++;
                                capturedVarsInLambda.put(token.name, value.expression);
                            }
                        }
                        result.add(value);
                    }
                }
                ++i2;
            }
            return result.toArray(new InlineVariable[0]);
        }

        private Position getStartPosition(ASTNode node) {
            int lineNumber = this.unit.getLineNumber(node.getStartPosition()) - 1;
            int columnNumber = this.unit.getColumnNumber(node.getStartPosition());
            return new Position(lineNumber, columnNumber);
        }

        private Position getEndPosition(ASTNode node) {
            int lineNumber = this.unit.getLineNumber(node.getStartPosition() + node.getLength() - 1) - 1;
            int columnNumber = this.unit.getColumnNumber(node.getStartPosition() + node.getLength() - 1);
            return new Position(lineNumber, columnNumber);
        }

        private boolean isUnreachableNode(ASTNode node) {
            Position startPosition = this.getStartPosition(node);
            Position endPosition = this.getEndPosition(node);
            return this.compare(startPosition, this.stoppedSourceRange.getEnd()) > 0 || this.compare(endPosition, this.stoppedSourceRange.getEnd()) < 0;
        }

        private boolean isEnclosed(Range range, Position position) {
            return this.compare(range.getStart(), position) <= 0 && this.compare(range.getEnd(), position) >= 0;
        }

        private int compare(Position p1, Position p2) {
            if (p1.getLine() < p2.getLine()) {
                return -1;
            }
            if (p1.getLine() == p2.getLine()) {
                return p1.getCharacter() - p2.getCharacter();
            }
            return 1;
        }

        private boolean isAtStopLocation(Position position) {
            return position.getLine() == this.stoppedSourceRange.getEnd().getLine();
        }

        private boolean isAtStopLocation(ASTNode node) {
            Position startPosition = this.getStartPosition(node);
            return this.isAtStopLocation(startPosition);
        }

        private boolean isAtLastVisibleLine(Position position) {
            return this.visibleInlineRange != null && this.visibleInlineRange.getEnd().getLine() == position.getLine();
        }
    }
}

