/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RedundantSemicolonsCleanUpCore
extends AbstractMultiFix
implements ICleanUpFix {
    private TextEditGroup[] fEditGroups;
    private String fName;
    private ICompilationUnit fCompilationUnit;
    static final Pattern pattern = Pattern.compile("^((\\s*;)+)");

    public RedundantSemicolonsCleanUpCore() {
        this(Collections.emptyMap());
    }

    public RedundantSemicolonsCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.remove_redundant_semicolons");
        Map<String, String> requiredOptions = null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.remove_redundant_semicolons")) {
            return new String[]{MultiFixMessages.RedundantSemicolonsCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder buf = new StringBuilder();
        buf.append("enum color {\n");
        buf.append("  red, yellow, green\n");
        if (this.isEnabled("cleanup.remove_redundant_semicolons")) {
            buf.append("}\n");
        } else {
            buf.append("};\n");
        }
        buf.append("\npublic class IFoo {\n");
        if (this.isEnabled("cleanup.remove_redundant_semicolons")) {
            buf.append("  int a= 3;\n");
            buf.append("  public void foo() {}\n");
            buf.append("}\n");
        } else {
            buf.append("  int a= 3;;\n");
            buf.append("  public void foo() {;};\n");
            buf.append("};\n");
        }
        return buf.toString();
    }

    private void searchNode(ASTNode node, String contents, String label, ArrayList<TextEditGroup> textedits) {
        int length;
        int start = node.getStartPosition();
        int trailing = this.findTrailingSemicolons(contents, start + (length = node.getLength()));
        if (trailing > 0) {
            ReplaceEdit edit = new ReplaceEdit(start + length, trailing, "");
            textedits.add(new TextEditGroup(label, (TextEdit)edit));
        }
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.remove_redundant_semicolons")) {
            return null;
        }
        ICompilationUnit compilationUnit = (ICompilationUnit)unit.getJavaElement();
        IBuffer buffer = compilationUnit.getBuffer();
        final String contents = buffer.getContents();
        final String label = MultiFixMessages.RedundantSemicolonsCleanup_description;
        final ArrayList textedits = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(PackageDeclaration node) {
                RedundantSemicolonsCleanUpCore.this.searchNode((ASTNode)node, contents, label, textedits);
                return false;
            }

            public boolean visit(FieldDeclaration node) {
                RedundantSemicolonsCleanUpCore.this.searchNode((ASTNode)node, contents, label, textedits);
                return false;
            }

            public boolean visit(MethodDeclaration node) {
                RedundantSemicolonsCleanUpCore.this.searchNode((ASTNode)node, contents, label, textedits);
                return true;
            }

            public boolean visit(EnumDeclaration node) {
                RedundantSemicolonsCleanUpCore.this.searchNode((ASTNode)node, contents, label, textedits);
                return true;
            }

            public boolean visit(TypeDeclaration node) {
                RedundantSemicolonsCleanUpCore.this.searchNode((ASTNode)node, contents, label, textedits);
                return true;
            }

            public boolean visit(RecordDeclaration node) {
                RedundantSemicolonsCleanUpCore.this.searchNode((ASTNode)node, contents, label, textedits);
                return true;
            }

            public boolean visit(EmptyStatement node) {
                ASTNode parent = node.getParent();
                if (parent instanceof Block) {
                    int start = node.getStartPosition();
                    ReplaceEdit edit = new ReplaceEdit(start, 1, "");
                    textedits.add(new TextEditGroup(label, (TextEdit)edit));
                }
                return false;
            }

            public boolean visit(Block node) {
                if (!(node.getParent() instanceof LambdaExpression)) {
                    RedundantSemicolonsCleanUpCore.this.searchNode((ASTNode)node, contents, label, textedits);
                }
                return true;
            }
        });
        if (textedits.size() > 0) {
            return new RedundantSemicolonsCleanUpCore(label, unit, textedits.toArray(new TextEditGroup[0]));
        }
        return null;
    }

    private int findTrailingSemicolons(String contents, int startLocation) {
        int i = startLocation;
        Matcher matcher = pattern.matcher(contents.substring(i));
        if (matcher.find(0)) {
            return matcher.end(2);
        }
        return -1;
    }

    private RedundantSemicolonsCleanUpCore(String name, CompilationUnit compilationUnit, TextEditGroup[] groups) {
        this.fName = name;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fEditGroups = groups;
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        if (this.fEditGroups == null || this.fEditGroups.length == 0) {
            return null;
        }
        CompilationUnitChange result = new CompilationUnitChange(this.fName, this.fCompilationUnit);
        TextEditGroup[] textEditGroupArray = this.fEditGroups;
        int n = this.fEditGroups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditGroup editGroup = textEditGroupArray[n2];
            String groupName = editGroup.getName();
            TextEdit[] textEditArray = editGroup.getTextEdits();
            int n3 = textEditArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TextEdit edit = textEditArray[n4];
                TextChangeCompatibility.addTextEdit((TextChange)result, groupName, edit);
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }
}

