/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.ls.core.internal.HoverInfoProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class HoverHandler {
    private final PreferenceManager preferenceManager;

    public HoverHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public Hover hover(TextDocumentPositionParams position, IProgressMonitor monitor) {
        Hover hover;
        if (this.preferenceManager != null && !this.preferenceManager.getPreferences().isHoverJavadocEnabled()) {
            return null;
        }
        ITypeRoot unit = null;
        try {
            boolean returnCompilationUnit = this.preferenceManager == null ? false : this.preferenceManager.isClientSupportsClassFileContent() && this.preferenceManager.getPreferences().isIncludeDecompiledSources();
            unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri(), returnCompilationUnit, monitor);
            List<Object> content = null;
            content = unit != null && !monitor.isCanceled() ? this.computeHover(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor) : Collections.singletonList(Either.forLeft((Object)""));
            Hover $ = new Hover();
            $.setContents(content);
            hover = $;
        }
        catch (Throwable throwable) {
            JDTUtils.discardClassFileWorkingCopy(unit);
            throw throwable;
        }
        JDTUtils.discardClassFileWorkingCopy(unit);
        return hover;
    }

    private List<Either<String, MarkedString>> computeHover(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        HoverInfoProvider provider = new HoverInfoProvider(unit, this.preferenceManager);
        return provider.computeHover(line, column, monitor);
    }
}

