/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ExtensionsExtractor {
    public static <T> List<T> extractOrderedExtensions(String namespace, String extensionPointName) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPointName);
        IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
        TreeMap<Integer, T> extensionMap = new TreeMap<Integer, T>();
        int i = 0;
        while (i < configs.length) {
            Integer order = Integer.valueOf(configs[i].getAttribute("order"));
            extensionMap.put(order, ExtensionsExtractor.makeExtension(configs[i]));
            ++i;
        }
        return extensionMap.values().stream().collect(Collectors.toUnmodifiableList());
    }

    private static <T> T makeExtension(IConfigurationElement config) {
        try {
            return (T)config.createExecutableExtension("class");
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not create the extension", ex);
        }
    }
}

