/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.doctree.SeeTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.javac.problem.UnusedProblemFactory;

public class UnusedTreeScanner<R, P>
extends TreeScanner<R, P> {
    final Set<Tree> privateDecls = new LinkedHashSet<Tree>();
    final Set<Symbol> usedElements = new HashSet<Symbol>();
    final Map<String, java.util.List<JCTree.JCImport>> unusedImports = new LinkedHashMap<String, java.util.List<JCTree.JCImport>>();
    final java.util.List<JCTree.JCTypeCast> unnecessaryCasts = new ArrayList<JCTree.JCTypeCast>();
    final java.util.List<JCTree.JCAssign> noEffectAssignments = new ArrayList<JCTree.JCAssign>();
    private CompilationUnitTree unit = null;
    private boolean classSuppressUnused = false;
    private boolean methodSuppressUnused = false;
    private boolean lhsInAssignment = false;
    private final UnusedDocTreeScanner unusedDocTreeScanner = new UnusedDocTreeScanner(this);

    @Override
    public R scan(Tree tree, P p) {
        JCTree jcTree;
        Tokens.Comment c;
        if (tree == null) {
            return super.scan(tree, p);
        }
        JCTree.JCCompilationUnit jcUnit = null;
        CompilationUnitTree compilationUnitTree = this.unit;
        if (compilationUnitTree instanceof JCTree.JCCompilationUnit) {
            JCTree.JCCompilationUnit currentUnit;
            jcUnit = currentUnit = (JCTree.JCCompilationUnit)compilationUnitTree;
        } else if (tree instanceof JCTree.JCCompilationUnit) {
            JCTree.JCCompilationUnit currentUnit;
            jcUnit = currentUnit = (JCTree.JCCompilationUnit)tree;
        }
        if (jcUnit != null && tree instanceof JCTree && (c = jcUnit.docComments.getComment(jcTree = (JCTree)tree)) != null && (c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_BLOCK || c.getStyle() == Tokens.Comment.CommentStyle.JAVADOC_LINE)) {
            DocCommentTree docCommentTree = jcUnit.docComments.getCommentTree(jcTree);
            this.unusedDocTreeScanner.scan(docCommentTree, p);
        }
        return super.scan(tree, p);
    }

    @Override
    public R visitCompilationUnit(CompilationUnitTree node, P p) {
        this.unit = node;
        return super.visitCompilationUnit(node, p);
    }

    @Override
    public R visitImport(ImportTree node, P p) {
        if (node instanceof JCTree.JCImport) {
            JCTree.JCImport jcImport = (JCTree.JCImport)node;
            String importClass = jcImport.qualid.toString();
            java.util.List<JCTree.JCImport> importList = this.unusedImports.get(importClass);
            if (importList == null) {
                importList = new ArrayList<JCTree.JCImport>();
                this.unusedImports.put(importClass, importList);
            }
            importList.add(jcImport);
        }
        return super.visitImport(node, p);
    }

    @Override
    public R visitClass(ClassTree node, P p) {
        if (node instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)node;
            Iterator<JCTree.JCAnnotation> iterator = classDecl.mods.annotations.iterator();
            if (iterator.hasNext()) {
                JCTree.JCAnnotation annot = iterator.next();
                this.classSuppressUnused = this.isUnusedSuppressed(annot);
            }
            if (this.isPotentialUnusedDeclaration(classDecl) && !this.classSuppressUnused) {
                this.privateDecls.add(classDecl);
            }
        }
        return super.visitClass(node, p);
    }

    @Override
    public R visitIdentifier(IdentifierTree node, P p) {
        JCTree.JCIdent id;
        if (node instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)node;
            if (this.isPrivateSymbol(id.sym) && !this.lhsInAssignment) {
                this.usedElements.add(id.sym);
            }
        }
        if (node instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)node;
            if (this.isMemberSymbol(id.sym)) {
                String name = id.toString();
                String ownerName = id.sym.owner.toString();
                if (!ownerName.isBlank()) {
                    String starImport = ownerName + ".*";
                    String usualImport = ownerName + "." + name;
                    if (this.unusedImports.containsKey(starImport)) {
                        this.unusedImports.remove(starImport);
                    } else if (this.unusedImports.containsKey(usualImport)) {
                        this.unusedImports.remove(usualImport);
                    }
                }
            }
        }
        if (node instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)node;
            Symbol symbol = id.sym;
            if (symbol instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)symbol;
                if (classSym.owner instanceof Symbol.MethodSymbol) {
                    this.usedElements.add(id.sym);
                }
            }
        }
        return super.visitIdentifier(node, p);
    }

    @Override
    public R visitAssignment(AssignmentTree node, P p) {
        if (node instanceof JCTree.JCAssign) {
            JCTree.JCAssign assign = (JCTree.JCAssign)node;
            this.scan(assign.rhs, p);
            this.lhsInAssignment = true;
            this.scan(assign.lhs, p);
            this.lhsInAssignment = false;
            if (this.isNoEffectAssignment(assign)) {
                this.noEffectAssignments.add(assign);
            }
            return null;
        }
        return super.visitAssignment(node, p);
    }

    @Override
    public R visitMemberSelect(MemberSelectTree node, P p) {
        if (node instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess field = (JCTree.JCFieldAccess)node;
            if (this.isPrivateSymbol(field.sym)) {
                this.usedElements.add(field.sym);
            }
        }
        return super.visitMemberSelect(node, p);
    }

    @Override
    public R visitMethod(MethodTree node, P p) {
        boolean isPrivateMethod = this.isPotentialUnusedDeclaration(node);
        if (isPrivateMethod) {
            this.privateDecls.add(node);
        }
        return super.visitMethod(node, p);
    }

    @Override
    public R visitVariable(VariableTree node, P p) {
        boolean isPrivateVariable = this.isPotentialUnusedDeclaration(node);
        if (isPrivateVariable) {
            this.privateDecls.add(node);
        }
        return super.visitVariable(node, p);
    }

    @Override
    public R visitMemberReference(MemberReferenceTree node, P p) {
        if (node instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference member = (JCTree.JCMemberReference)node;
            if (this.isPrivateSymbol(member.sym)) {
                this.usedElements.add(member.sym);
            }
        }
        return super.visitMemberReference(node, p);
    }

    @Override
    public R visitNewClass(NewClassTree node, P p) {
        if (node instanceof JCTree.JCNewClass) {
            Symbol.TypeSymbol targetClass;
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)node;
            Symbol.TypeSymbol typeSymbol = targetClass = newClass.def != null ? newClass.def.sym : newClass.type.tsym;
            if (this.isPrivateSymbol(targetClass) || targetClass.owner instanceof Symbol.MethodSymbol) {
                this.usedElements.add(targetClass);
            }
            if (newClass.constructor != null) {
                this.usedElements.add(newClass.constructor);
            }
        }
        return super.visitNewClass(node, p);
    }

    @Override
    public R visitTypeCast(TypeCastTree node, P p) {
        if (node instanceof JCTree.JCTypeCast) {
            JCTree.JCTypeCast typeCast = (JCTree.JCTypeCast)node;
            Type castType = typeCast.clazz.type;
            Type exprType = this.getExpression((JCTree.JCExpression)typeCast.expr).type;
            if (!castType.isPrimitive() && !exprType.isPrimitive() && this.isSameOrSuperReferenceType(castType, exprType) || castType.isPrimitive() && exprType.isPrimitive() && this.isSameOrWideningPrimitiveType(castType, exprType) || castType.isPrimitive() && !exprType.isPrimitive() && this.matchesBoxedPrimitive(exprType, castType) || !castType.isPrimitive() && exprType.isPrimitive() && this.matchesBoxedPrimitive(castType, exprType)) {
                this.unnecessaryCasts.add(typeCast);
            }
        }
        return super.visitTypeCast(node, p);
    }

    private JCTree.JCExpression getExpression(JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCTypeCast) {
            JCTree.JCTypeCast innerCast = (JCTree.JCTypeCast)expr;
            return this.getExpression(innerCast.expr);
        }
        return expr;
    }

    private boolean isSameOrSuperReferenceType(Type castType, Type exprType) {
        Symbol.TypeSymbol targetSymbol = castType.tsym;
        Symbol.TypeSymbol sourceSymbol = exprType.tsym;
        if (targetSymbol.equals(sourceSymbol)) {
            return true;
        }
        if (sourceSymbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)sourceSymbol;
            return this.isSameOrSuperReferenceType(castType, classSymbol.getSuperclass());
        }
        return false;
    }

    private boolean isSameOrWideningPrimitiveType(Type castType, Type exprType) {
        TypeTag from = exprType.getTag();
        TypeTag to = castType.getTag();
        if (to.equals((Object)from)) {
            return true;
        }
        return switch (from) {
            case TypeTag.BYTE -> {
                if (to == TypeTag.SHORT || to == TypeTag.INT || to == TypeTag.LONG || to == TypeTag.FLOAT || to == TypeTag.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case TypeTag.SHORT -> {
                if (to == TypeTag.INT || to == TypeTag.LONG || to == TypeTag.FLOAT || to == TypeTag.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case TypeTag.CHAR -> {
                if (to == TypeTag.INT || to == TypeTag.LONG || to == TypeTag.FLOAT || to == TypeTag.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case TypeTag.INT -> {
                if (to == TypeTag.LONG || to == TypeTag.FLOAT || to == TypeTag.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case TypeTag.LONG -> {
                if (to == TypeTag.FLOAT || to == TypeTag.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case TypeTag.FLOAT -> {
                if (to == TypeTag.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean matchesBoxedPrimitive(Type boxedType, Type primitiveType) {
        String boxedTypeName;
        TypeTag primitiveTag = primitiveType.getTag();
        return switch (boxedTypeName = boxedType.tsym != null ? boxedType.tsym.flatName().toString() : boxedType.toString()) {
            case "java.lang.Boolean" -> {
                if (primitiveTag == TypeTag.BOOLEAN) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Byte" -> {
                if (primitiveTag == TypeTag.BYTE) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Character" -> {
                if (primitiveTag == TypeTag.CHAR) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Short" -> {
                if (primitiveTag == TypeTag.SHORT) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Integer" -> {
                if (primitiveTag == TypeTag.INT) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Long" -> {
                if (primitiveTag == TypeTag.LONG) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Float" -> {
                if (primitiveTag == TypeTag.FLOAT) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Double" -> {
                if (primitiveTag == TypeTag.DOUBLE) {
                    yield true;
                }
                yield false;
            }
            case "java.lang.Void" -> {
                if (primitiveTag == TypeTag.VOID) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isNoEffectAssignment(JCTree.JCAssign assign) {
        JCTree.JCFieldAccess fa;
        JCTree.JCIdent id;
        Symbol lhsSym = null;
        Symbol rhsSym = null;
        JCTree.JCExpression jCExpression = assign.lhs;
        if (jCExpression instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)jCExpression;
            lhsSym = id.sym;
        } else {
            jCExpression = assign.lhs;
            if (jCExpression instanceof JCTree.JCFieldAccess) {
                fa = (JCTree.JCFieldAccess)jCExpression;
                lhsSym = fa.sym;
            }
        }
        jCExpression = assign.rhs;
        if (jCExpression instanceof JCTree.JCIdent) {
            id = (JCTree.JCIdent)jCExpression;
            rhsSym = id.sym;
        } else {
            jCExpression = assign.rhs;
            if (jCExpression instanceof JCTree.JCFieldAccess) {
                fa = (JCTree.JCFieldAccess)jCExpression;
                rhsSym = fa.sym;
            }
        }
        return lhsSym != null && rhsSym != null && lhsSym == rhsSym;
    }

    private boolean isPotentialUnusedDeclaration(Tree tree) {
        if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classTree = (JCTree.JCClassDecl)tree;
            return (classTree.getModifiers().flags & 2L) != 0L || classTree.sym.owner instanceof Symbol.MethodSymbol;
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodTree = (JCTree.JCMethodDecl)tree;
            Iterator<JCTree.JCAnnotation> iterator = methodTree.mods.annotations.iterator();
            if (iterator.hasNext()) {
                JCTree.JCAnnotation annot = iterator.next();
                this.methodSuppressUnused = this.isUnusedSuppressed(annot);
            }
            if (this.isConstructor(methodTree)) {
                return (methodTree.getModifiers().flags & 2L) != 0L && this.hasPackageVisibleConstructor(methodTree.sym.owner);
            }
            return (methodTree.getModifiers().flags & 2L) != 0L;
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            Symbol.MethodSymbol method;
            Symbol owner;
            JCTree.JCVariableDecl variable = (JCTree.JCVariableDecl)tree;
            Symbol symbol = owner = variable.sym == null ? null : variable.sym.owner;
            if (owner instanceof Symbol.ClassSymbol) {
                return !this.isSerialVersionConstant(variable) && (variable.getModifiers().flags & 2L) != 0L;
            }
            if (owner instanceof Symbol.MethodSymbol && !(method = (Symbol.MethodSymbol)owner).enclClass().isInterface() && !method.isAbstract() && method.getAnnotation(Override.class) == null) {
                return true;
            }
        }
        return false;
    }

    private boolean isConstructor(JCTree.JCMethodDecl methodDecl) {
        return methodDecl.sym != null && methodDecl.sym.isConstructor();
    }

    private boolean hasPackageVisibleConstructor(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol clazz = (Symbol.ClassSymbol)symbol;
            for (Symbol member : clazz.members().getSymbols()) {
                Symbol.MethodSymbol method;
                if (!(member instanceof Symbol.MethodSymbol) || !(method = (Symbol.MethodSymbol)member).isConstructor() || (method.flags() & 2L) != 0L) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPrivateSymbol(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.MethodSymbol) {
            return (symbol.flags() & 2L) != 0L;
        }
        if (symbol instanceof Symbol.VarSymbol) {
            if (symbol.owner instanceof Symbol.ClassSymbol) {
                return (symbol.flags() & 2L) != 0L;
            }
            if (symbol.owner instanceof Symbol.MethodSymbol) {
                return true;
            }
        }
        return false;
    }

    private boolean isMemberSymbol(Symbol symbol) {
        if (symbol instanceof Symbol.ClassSymbol || symbol instanceof Symbol.MethodSymbol) {
            return true;
        }
        if (symbol instanceof Symbol.VarSymbol) {
            return symbol.owner instanceof Symbol.ClassSymbol;
        }
        return false;
    }

    private boolean isSerialVersionConstant(JCTree.JCVariableDecl variable) {
        Type.JCPrimitiveType type;
        Type type2;
        long flags = variable.getModifiers().flags;
        return (flags & 0x10L) != 0L && (flags & 8L) != 0L && (type2 = variable.type) instanceof Type.JCPrimitiveType && (type = (Type.JCPrimitiveType)type2).getTag() == TypeTag.LONG && "serialVersionUID".equals(variable.name.toString());
    }

    public java.util.List<CategorizedProblem> getUnusedImports(UnusedProblemFactory problemFactory) {
        return problemFactory.addUnusedImports(this.unit, this.unusedImports);
    }

    public java.util.List<CategorizedProblem> getUnnecessaryCasts(UnusedProblemFactory problemFactory) {
        return problemFactory.addUnnecessaryCasts(this.unit, this.unnecessaryCasts);
    }

    public java.util.List<CategorizedProblem> getUnusedPrivateMembers(UnusedProblemFactory problemFactory) {
        ArrayList<Tree> unusedPrivateMembers = new ArrayList<Tree>();
        if (!this.classSuppressUnused && !this.methodSuppressUnused) {
            for (Tree decl : this.privateDecls) {
                Symbol symbol;
                Symbol.VarSymbol varSymbol;
                ElementKind varKind;
                if (decl instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)decl;
                    if (!this.usedElements.contains(classDecl.sym)) {
                        unusedPrivateMembers.add(decl);
                        continue;
                    }
                }
                if (decl instanceof JCTree.JCMethodDecl) {
                    JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)decl;
                    if (!this.usedElements.contains(methodDecl.sym)) {
                        unusedPrivateMembers.add(decl);
                        continue;
                    }
                }
                if (!(decl instanceof JCTree.JCVariableDecl)) continue;
                JCTree.JCVariableDecl variableDecl = (JCTree.JCVariableDecl)decl;
                if (this.usedElements.contains(variableDecl.sym)) continue;
                boolean suppressed = false;
                Iterator<JCTree.JCAnnotation> iterator = variableDecl.mods.annotations.iterator();
                if (iterator.hasNext()) {
                    JCTree.JCAnnotation annot = iterator.next();
                    suppressed = this.isUnusedSuppressed(annot);
                }
                ElementKind elementKind = varKind = (varSymbol = variableDecl.sym) == null ? null : varSymbol.getKind();
                if (varKind == ElementKind.FIELD && (symbol = varSymbol.owner) instanceof Symbol.ClassSymbol) {
                    Symbol.ClassSymbol css = (Symbol.ClassSymbol)symbol;
                    String name = variableDecl.name.toString();
                    if (((List)css.getRecordComponents()).map(x -> x.toString()).contains(name)) {
                        suppressed = true;
                    }
                }
                if (suppressed) continue;
                unusedPrivateMembers.add(decl);
            }
        }
        return problemFactory.addUnusedPrivateMembers(this.unit, unusedPrivateMembers);
    }

    public java.util.List<CategorizedProblem> getNoEffectAssignments(UnusedProblemFactory problemFactory) {
        return problemFactory.addNoEffectAssignments(this.unit, this.noEffectAssignments);
    }

    private boolean isUnusedSuppressed(JCTree.JCAnnotation annot) {
        boolean suppressed = false;
        JCTree type = annot.getAnnotationType();
        if (type instanceof JCTree.JCIdent) {
            JCTree.JCIdent id = (JCTree.JCIdent)type;
            if (id.sym.name.contentEquals("SuppressWarnings")) {
                block0: for (JCTree.JCExpression exp : annot.getArguments()) {
                    if (!(exp instanceof JCTree.JCAssign)) continue;
                    JCTree.JCAssign assign = (JCTree.JCAssign)exp;
                    JCTree.JCExpression jCExpression = assign.lhs;
                    if (!(jCExpression instanceof JCTree.JCIdent)) continue;
                    JCTree.JCIdent lhsId = (JCTree.JCIdent)jCExpression;
                    if (!lhsId.sym.name.contentEquals("value")) continue;
                    Object object = assign.rhs;
                    if (object instanceof JCTree.JCLiteral) {
                        JCTree.JCLiteral rhsId = (JCTree.JCLiteral)object;
                        if (rhsId.value.equals("unused")) {
                            suppressed = true;
                            break;
                        }
                    }
                    if (!((object = assign.rhs) instanceof JCTree.JCNewArray)) continue;
                    JCTree.JCNewArray array = (JCTree.JCNewArray)object;
                    for (JCTree.JCExpression el : array.elems) {
                        if (!(el instanceof JCTree.JCLiteral)) continue;
                        JCTree.JCLiteral lit = (JCTree.JCLiteral)el;
                        if (!lit.value.equals("unused")) continue;
                        suppressed = true;
                        continue block0;
                    }
                }
            }
        }
        return suppressed;
    }

    private class UnusedDocTreeScanner
    extends DocTreeScanner<R, P> {
        final /* synthetic */ UnusedTreeScanner this$0;

        private UnusedDocTreeScanner(UnusedTreeScanner unusedTreeScanner) {
            UnusedTreeScanner unusedTreeScanner2 = unusedTreeScanner;
            Objects.requireNonNull(unusedTreeScanner2);
            this.this$0 = unusedTreeScanner2;
        }

        @Override
        public R visitLink(LinkTree node, P p) {
            ReferenceTree referenceTree = node.getReference();
            if (referenceTree instanceof DCTree.DCReference) {
                DCTree.DCReference ref = (DCTree.DCReference)referenceTree;
                this.useImport(ref);
            }
            return super.visitLink(node, p);
        }

        @Override
        public R visitSee(SeeTree node, P p) {
            java.util.List<? extends DocTree> list = node.getReference();
            if (list instanceof java.util.List) {
                java.util.List<? extends DocTree> refs = list;
                for (Object e : refs) {
                    if (!(e instanceof DCTree.DCReference)) continue;
                    this.useImport((DCTree.DCReference)e);
                }
            }
            return super.visitSee(node, p);
        }

        @Override
        public R visitThrows(ThrowsTree node, P p) {
            ReferenceTree referenceTree = node.getExceptionName();
            if (referenceTree instanceof DCTree.DCReference) {
                DCTree.DCReference ref = (DCTree.DCReference)referenceTree;
                this.useImport(ref);
            }
            return super.visitThrows(node, p);
        }

        private void useImport(DCTree.DCReference ref) {
            Object ident;
            Object qualifier = null;
            JCTree jCTree = ref.qualifierExpression;
            if (jCTree instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident2 = (JCTree.JCIdent)jCTree;
                qualifier = ident2;
            } else {
                jCTree = ref.qualifierExpression;
                if (jCTree instanceof JCTree.JCArrayTypeTree) {
                    JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)jCTree;
                    jCTree = arrayType.elemtype;
                    if (jCTree instanceof JCTree.JCIdent) {
                        qualifier = ident = (JCTree.JCIdent)jCTree;
                    }
                }
            }
            String fieldName = null;
            ident = ref.memberName;
            if (ident instanceof JCTree.JCIdent) {
                JCTree.JCIdent field = (JCTree.JCIdent)ident;
                fieldName = field.toString();
            }
            if (qualifier != null) {
                this.checkQualifier((JCTree.JCIdent)qualifier, fieldName);
            }
            if (ref.paramTypes != null) {
                for (JCTree paramType : ref.paramTypes) {
                    if (paramType instanceof JCTree.JCIdent) {
                        JCTree.JCIdent param = (JCTree.JCIdent)paramType;
                        this.checkQualifier(param, fieldName);
                        continue;
                    }
                    if (!(paramType instanceof JCTree.JCArrayTypeTree)) continue;
                    JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)paramType;
                    JCTree.JCExpression jCExpression = arrayType.elemtype;
                    if (!(jCExpression instanceof JCTree.JCIdent)) continue;
                    JCTree.JCIdent param = (JCTree.JCIdent)jCExpression;
                    this.checkQualifier(param, fieldName);
                }
            }
        }

        private void checkQualifier(JCTree.JCIdent qualifier, String fieldName) {
            if (qualifier.sym == null || qualifier.sym.owner.toString().isBlank()) {
                String suffix = "." + qualifier.getName().toString();
                Optional<String> potentialImport = this.this$0.unusedImports.keySet().stream().filter(a -> a.endsWith(suffix)).findFirst();
                if (potentialImport.isPresent()) {
                    this.this$0.unusedImports.remove(potentialImport.get());
                }
                if (fieldName != null) {
                    Optional<String> potentialStaticWildcardImport;
                    String suffixWithField = suffix + "." + fieldName;
                    String suffixWithWildcard = suffix + ".*";
                    Optional<String> potentialStaticImport = this.this$0.unusedImports.keySet().stream().filter(a -> a.endsWith(suffixWithField)).findFirst();
                    if (potentialStaticImport.isPresent()) {
                        this.this$0.unusedImports.remove(potentialStaticImport.get());
                    }
                    if ((potentialStaticWildcardImport = this.this$0.unusedImports.keySet().stream().filter(a -> a.endsWith(suffixWithWildcard)).findFirst()).isPresent()) {
                        this.this$0.unusedImports.remove(potentialStaticWildcardImport.get());
                    }
                }
            } else {
                String name = qualifier.toString();
                String ownerName = qualifier.sym.owner.toString();
                if (!ownerName.isBlank()) {
                    String starImport = ownerName + ".*";
                    String usualImport = ownerName + "." + name;
                    if (this.this$0.unusedImports.containsKey(starImport)) {
                        this.this$0.unusedImports.remove(starImport);
                    } else if (this.this$0.unusedImports.containsKey(usualImport)) {
                        this.this$0.unusedImports.remove(usualImport);
                    }
                    if (fieldName != null) {
                        String suffixWithField = usualImport + "." + fieldName;
                        String suffixWithWildcard = usualImport + ".*";
                        if (this.this$0.unusedImports.containsKey(suffixWithField)) {
                            this.this$0.unusedImports.remove(suffixWithField);
                        }
                        if (this.this$0.unusedImports.containsKey(suffixWithWildcard)) {
                            this.this$0.unusedImports.remove(suffixWithWildcard);
                        }
                    }
                }
            }
        }
    }
}

