/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.BuildWorkspaceHandler;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.extended.ProjectBuildParams;

public class Compile {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final int GRADLE_BS_COMPILATION_ERROR = 100;

    public static Object compile(CompileParams params, IProgressMonitor monitor) {
        if (params == null) {
            throw new IllegalArgumentException("The compile parameters should not be null.");
        }
        IProject mainProject = JdtUtils.getMainProject(params.getProjectName(), params.getMainClass());
        if (JdtUtils.isBspProject(mainProject) && !ProjectUtils.isGradleProject((IProject)mainProject)) {
            try {
                ResourcesPlugin.getWorkspace().build(new IBuildConfiguration[]{mainProject.getActiveBuildConfig()}, 10, false, monitor);
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 75) {
                    return 100;
                }
                return BuildWorkspaceStatus.FAILED;
            }
            return BuildWorkspaceStatus.SUCCEED;
        }
        if (monitor.isCanceled()) {
            return BuildWorkspaceStatus.CANCELLED;
        }
        ProjectBuildParams buildParams = new ProjectBuildParams();
        LinkedList<TextDocumentIdentifier> identifiers = new LinkedList<TextDocumentIdentifier>();
        buildParams.setFullBuild(params.isFullBuild);
        IJavaProject[] iJavaProjectArray = ProjectUtils.getJavaProjects();
        int n = iJavaProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject = iJavaProjectArray[n2];
            if (!ProjectsManager.getDefaultProject().equals((Object)javaProject.getProject()) && !JdtUtils.isBspProject(javaProject.getProject())) {
                identifiers.add(new TextDocumentIdentifier(javaProject.getProject().getLocationURI().toString()));
            }
            ++n2;
        }
        if (identifiers.size() == 0) {
            return BuildWorkspaceStatus.SUCCEED;
        }
        buildParams.setIdentifiers(identifiers);
        long compileAt = System.currentTimeMillis();
        BuildWorkspaceHandler buildWorkspaceHandler = new BuildWorkspaceHandler(JavaLanguageServerPlugin.getProjectsManager());
        BuildWorkspaceStatus status = buildWorkspaceHandler.buildProjects(buildParams, monitor);
        logger.info("Time cost for ECJ: " + (System.currentTimeMillis() - compileAt) + "ms");
        if (status == BuildWorkspaceStatus.FAILED || status == BuildWorkspaceStatus.CANCELLED) {
            return status;
        }
        try {
            IType mainType;
            IProject currentResource = mainProject;
            if (Compile.isUnmanagedFolder(mainProject) && StringUtils.isNotBlank((CharSequence)params.getMainClass()) && (mainType = ProjectUtils.getJavaProject((IProject)mainProject).findType(params.getMainClass())) != null && mainType.getResource() != null) {
                currentResource = mainType.getResource();
            }
            ArrayList problemMarkers = new ArrayList();
            if (currentResource != null) {
                List markers = ResourceUtils.getErrorMarkers((IResource)currentResource);
                if (markers != null) {
                    problemMarkers.addAll(markers);
                }
                if (currentResource instanceof IProject && ProjectUtils.isJavaProject((IProject)currentResource)) {
                    IJavaProject[] javaProjects;
                    IJavaProject currentJavaProject = ProjectUtils.getJavaProject((IProject)currentResource);
                    IJavaProject[] iJavaProjectArray2 = javaProjects = ProjectUtils.getJavaProjects();
                    int n3 = javaProjects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaProject otherJavaProject = iJavaProjectArray2[n4];
                        IProject other = otherJavaProject.getProject();
                        if (!other.equals((Object)Compile.getDefaultProject()) && !other.equals((Object)currentResource) && currentJavaProject.isOnClasspath((IJavaElement)otherJavaProject) && (markers = ResourceUtils.getErrorMarkers((IResource)other)) != null) {
                            problemMarkers.addAll(markers);
                        }
                        ++n4;
                    }
                }
            } else {
                IJavaProject[] javaProjects;
                IJavaProject[] iJavaProjectArray3 = javaProjects = ProjectUtils.getJavaProjects();
                int n5 = javaProjects.length;
                int n6 = 0;
                while (n6 < n5) {
                    List markers;
                    IJavaProject javaProject = iJavaProjectArray3[n6];
                    IProject project = javaProject.getProject();
                    if (!project.equals((Object)Compile.getDefaultProject()) && (markers = ResourceUtils.getErrorMarkers((IResource)project)) != null) {
                        problemMarkers.addAll(markers);
                    }
                    ++n6;
                }
            }
            if (!problemMarkers.isEmpty()) {
                return BuildWorkspaceStatus.WITH_ERROR;
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log((CoreException)e);
        }
        return BuildWorkspaceStatus.SUCCEED;
    }

    private static boolean isUnmanagedFolder(IProject project) {
        return project != null && ProjectUtils.isUnmanagedFolder((IProject)project) && ProjectUtils.isJavaProject((IProject)project);
    }

    private static IProject getDefaultProject() {
        return Compile.getWorkspaceRoot().getProject("jdt.ls-java-project");
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    class CompileParams {
        String projectName;
        String mainClass;
        boolean isFullBuild = false;

        CompileParams() {
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public boolean isFullBuild() {
            return this.isFullBuild;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }
}

