"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createEnvValues = void 0;
/*********************************************************************
 * Copyright (c) 2022 Kichwa Coders Canada, Inc. and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
const os_1 = require("os");
/**
 * This method is providing an automatic operation to including new variables to process.env.
 * Method is not injecting the new variables to current thread, rather it is returning a new
 * object with included parameters.
 *
 * @param source
 * 		Source environment variables to include.
 * @param valuesToMerge
 * 		Key-Value dictionary to include.
 * @return
 * 		New environment variables dictionary.
 */
function createEnvValues(source, valuesToMerge) {
    const findTarget = (obj, key) => {
        if ((0, os_1.platform)() === 'win32') {
            return (Object.keys(obj).find((i) => i.localeCompare(key, undefined, {
                sensitivity: 'accent',
            }) === 0) || key);
        }
        return key;
    };
    const result = Object.assign({}, source);
    for (const [key, value] of Object.entries(valuesToMerge)) {
        const target = findTarget(result, key);
        if (value === null) {
            delete result[target];
        }
        else {
            result[target] = value;
        }
    }
    return result;
}
exports.createEnvValues = createEnvValues;
//# sourceMappingURL=createEnvValues.js.map