/*********************************************************************
 * Copyright (c) 2024 Renesas Electronics Corporation and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
import { Logger } from '@vscode/debugadapter/lib/logger';
import { IGDBBackend, IGDBBackendFactory, IGDBProcessManager } from '../../types/gdb';
import { AttachRequestArguments, LaunchRequestArguments } from '../../types/session';
import { GDBDebugSessionBase } from '../../gdb/GDBDebugSessionBase';
export declare class GDBBackendFactory implements IGDBBackendFactory {
    logger: Logger;
    constructor();
    createGDBManager(session: GDBDebugSessionBase, args: LaunchRequestArguments | AttachRequestArguments): Promise<IGDBProcessManager>;
    createBackend(session: GDBDebugSessionBase, manager: IGDBProcessManager, args: LaunchRequestArguments | AttachRequestArguments): Promise<IGDBBackend>;
}
