(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_file-search_lib_browser_quick-file-select-service_js"],{

/***/ "../../node_modules/@theia/core/shared/fuzzy/index.js":
/*!************************************************************!*\
  !*** ../../node_modules/@theia/core/shared/fuzzy/index.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! fuzzy */ "../../node_modules/fuzzy/lib/fuzzy.js");


/***/ }),

/***/ "../../node_modules/@theia/file-search/lib/browser/quick-file-select-service.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@theia/file-search/lib/browser/quick-file-select-service.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
var QuickFileSelectService_1;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.QuickFileSelectService = exports.FileQuickPickItem = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const label_provider_1 = __webpack_require__(/*! @theia/core/lib/browser/label-provider */ "../../node_modules/@theia/core/lib/browser/label-provider.js");
const quick_input_service_1 = __webpack_require__(/*! @theia/core/lib/browser/quick-input/quick-input-service */ "../../node_modules/@theia/core/lib/browser/quick-input/quick-input-service.js");
const common_1 = __webpack_require__(/*! @theia/core/lib/common */ "../../node_modules/@theia/core/lib/common/index.js");
const message_service_1 = __webpack_require__(/*! @theia/core/lib/common/message-service */ "../../node_modules/@theia/core/lib/common/message-service.js");
const uri_1 = __webpack_require__(/*! @theia/core/lib/common/uri */ "../../node_modules/@theia/core/lib/common/uri.js");
const fuzzy = __webpack_require__(/*! @theia/core/shared/fuzzy */ "../../node_modules/@theia/core/shared/fuzzy/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_2 = __webpack_require__(/*! @theia/editor/lib/browser */ "../../node_modules/@theia/editor/lib/browser/index.js");
const navigation_location_service_1 = __webpack_require__(/*! @theia/editor/lib/browser/navigation/navigation-location-service */ "../../node_modules/@theia/editor/lib/browser/navigation/navigation-location-service.js");
const browser_3 = __webpack_require__(/*! @theia/filesystem/lib/browser */ "../../node_modules/@theia/filesystem/lib/browser/index.js");
const workspace_service_1 = __webpack_require__(/*! @theia/workspace/lib/browser/workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js");
const file_search_service_1 = __webpack_require__(/*! ../common/file-search-service */ "../../node_modules/@theia/file-search/lib/common/file-search-service.js");
// Supports patterns of <path><#|:><line><#|:|,><col?>
const LINE_COLON_PATTERN = /\s?[#:\(](?:line )?(\d*)(?:[#:,](\d*))?\)?\s*$/;
var FileQuickPickItem;
(function (FileQuickPickItem) {
    function is(obj) {
        return obj && 'uri' in obj;
    }
    FileQuickPickItem.is = is;
})(FileQuickPickItem || (exports.FileQuickPickItem = FileQuickPickItem = {}));
let QuickFileSelectService = QuickFileSelectService_1 = class QuickFileSelectService {
    async getPicks(fileFilter = '', token = common_1.CancellationToken.None, options = {
        hideIgnoredFiles: true
    }) {
        const roots = this.workspaceService.tryGetRoots();
        const alreadyCollected = new Set();
        const recentlyUsedItems = [];
        if (this.preferences.get('search.quickOpen.includeHistory')) {
            const locations = [...this.navigationLocationService.locations()].reverse();
            for (const location of locations) {
                const uriString = location.uri.toString();
                if (location.uri.scheme === 'file' && !alreadyCollected.has(uriString) && fuzzy.test(fileFilter, uriString)) {
                    if (recentlyUsedItems.length === 0) {
                        recentlyUsedItems.push({
                            type: 'separator',
                            label: common_1.nls.localizeByDefault('recently opened')
                        });
                    }
                    const item = this.toItem(fileFilter, location.uri, options.onSelect);
                    recentlyUsedItems.push(item);
                    alreadyCollected.add(uriString);
                }
            }
        }
        if (fileFilter.length > 0) {
            const handler = async (results) => {
                if (token.isCancellationRequested || results.length <= 0) {
                    return [];
                }
                const result = [...recentlyUsedItems];
                const fileSearchResultItems = [];
                for (const fileUri of results) {
                    if (!alreadyCollected.has(fileUri)) {
                        const item = this.toItem(fileFilter, fileUri, options.onSelect);
                        fileSearchResultItems.push(item);
                        alreadyCollected.add(fileUri);
                    }
                }
                // Create a copy of the file search results and sort.
                const sortedResults = fileSearchResultItems.slice();
                sortedResults.sort((a, b) => this.compareItems(a, b, fileFilter));
                if (sortedResults.length > 0) {
                    result.push({
                        type: 'separator',
                        label: common_1.nls.localizeByDefault('file results')
                    });
                    result.push(...sortedResults);
                }
                // Return the recently used items, followed by the search results.
                return result;
            };
            return this.fileSearchService.find(fileFilter, {
                rootUris: roots.map(r => r.resource.toString()),
                fuzzyMatch: true,
                limit: 200,
                useGitIgnore: options.hideIgnoredFiles,
                excludePatterns: options.hideIgnoredFiles
                    ? Object.keys(this.fsPreferences['files.exclude'])
                    : undefined,
            }, token).then(handler);
        }
        else {
            return roots.length !== 0 ? recentlyUsedItems : [];
        }
    }
    compareItems(left, right, fileFilter) {
        /**
         * Score a given string.
         *
         * @param str the string to score on.
         * @returns the score.
         */
        function score(str) {
            var _a;
            if (!str) {
                return 0;
            }
            let exactMatch = true;
            const partialMatches = querySplit.reduce((matched, part) => {
                const partMatches = str.includes(part);
                exactMatch = exactMatch && partMatches;
                return partMatches ? matched + QuickFileSelectService_1.Scores.partial : matched;
            }, 0);
            // Check fuzzy matches.
            const fuzzyMatch = (_a = fuzzy.match(queryJoin, str)) !== null && _a !== void 0 ? _a : { score: 0 };
            if (fuzzyMatch.score === Infinity && exactMatch) {
                return Number.MAX_SAFE_INTEGER;
            }
            return fuzzyMatch.score + partialMatches + (exactMatch ? QuickFileSelectService_1.Scores.exact : 0);
        }
        const query = normalize(fileFilter);
        // Adjust for whitespaces in the query.
        const querySplit = query.split(file_search_service_1.WHITESPACE_QUERY_SEPARATOR);
        const queryJoin = querySplit.join('');
        const compareByLabelScore = (l, r) => score(r.label) - score(l.label);
        const compareByLabelIndex = (l, r) => r.label.indexOf(query) - l.label.indexOf(query);
        const compareByLabel = (l, r) => l.label.localeCompare(r.label);
        const compareByPathScore = (l, r) => score(r.uri.path.toString()) - score(l.uri.path.toString());
        const compareByPathIndex = (l, r) => r.uri.path.toString().indexOf(query) - l.uri.path.toString().indexOf(query);
        const compareByPathLabel = (l, r) => l.uri.path.toString().localeCompare(r.uri.path.toString());
        return compareWithDiscriminators(left, right, compareByLabelScore, compareByLabelIndex, compareByLabel, compareByPathScore, compareByPathIndex, compareByPathLabel);
    }
    toItem(lookFor, uriOrString, onSelect) {
        const uri = uriOrString instanceof uri_1.default ? uriOrString : new uri_1.default(uriOrString);
        const label = this.labelProvider.getName(uri);
        const description = this.getItemDescription(uri);
        const iconClasses = this.getItemIconClasses(uri);
        const item = {
            label,
            description,
            highlights: {
                label: (0, quick_input_service_1.findMatches)(label, lookFor),
                description: (0, quick_input_service_1.findMatches)(description, lookFor)
            },
            iconClasses,
            uri
        };
        return {
            ...item,
            execute: () => onSelect ? onSelect(item) : undefined
        };
    }
    getItemIconClasses(uri) {
        const icon = this.labelProvider.getIcon(uri).split(' ').filter(v => v.length > 0);
        if (icon.length > 0) {
            icon.push('file-icon');
        }
        return icon;
    }
    getItemDescription(uri) {
        return this.labelProvider.getDetails(uri);
    }
    /**
     * Splits the given expression into a structure of search-file-filter and
     * location-range.
     *
     * @param expression patterns of <path><#|:><line><#|:|,><col?>
     */
    splitFilterAndRange(expression) {
        var _a, _b;
        let filter = expression;
        let range = undefined;
        // Find line and column number from the expression using RegExp.
        const patternMatch = LINE_COLON_PATTERN.exec(expression);
        if (patternMatch) {
            const line = parseInt((_a = patternMatch[1]) !== null && _a !== void 0 ? _a : '', 10);
            if (Number.isFinite(line)) {
                const lineNumber = line > 0 ? line - 1 : 0;
                const column = parseInt((_b = patternMatch[2]) !== null && _b !== void 0 ? _b : '', 10);
                const startColumn = Number.isFinite(column) && column > 0 ? column - 1 : 0;
                const position = browser_2.Position.create(lineNumber, startColumn);
                filter = expression.substring(0, patternMatch.index);
                range = browser_2.Range.create(position, position);
            }
        }
        return { filter, range };
    }
};
exports.QuickFileSelectService = QuickFileSelectService;
/**
 * The score constants when comparing file search results.
 */
QuickFileSelectService.Scores = {
    max: 1000, // represents the maximum score from fuzzy matching (Infinity).
    exact: 500, // represents the score assigned to exact matching.
    partial: 250 // represents the score assigned to partial matching.
};
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.KeybindingRegistry),
    tslib_1.__metadata("design:type", browser_1.KeybindingRegistry)
], QuickFileSelectService.prototype, "keybindingRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(workspace_service_1.WorkspaceService),
    tslib_1.__metadata("design:type", workspace_service_1.WorkspaceService)
], QuickFileSelectService.prototype, "workspaceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], QuickFileSelectService.prototype, "openerService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_input_service_1.QuickInputService),
    (0, inversify_1.optional)(),
    tslib_1.__metadata("design:type", Object)
], QuickFileSelectService.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.QuickAccessRegistry),
    tslib_1.__metadata("design:type", Object)
], QuickFileSelectService.prototype, "quickAccessRegistry", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(file_search_service_1.FileSearchService),
    tslib_1.__metadata("design:type", Object)
], QuickFileSelectService.prototype, "fileSearchService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(label_provider_1.LabelProvider),
    tslib_1.__metadata("design:type", label_provider_1.LabelProvider)
], QuickFileSelectService.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(navigation_location_service_1.NavigationLocationService),
    tslib_1.__metadata("design:type", navigation_location_service_1.NavigationLocationService)
], QuickFileSelectService.prototype, "navigationLocationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(message_service_1.MessageService),
    tslib_1.__metadata("design:type", message_service_1.MessageService)
], QuickFileSelectService.prototype, "messageService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_3.FileSystemPreferences),
    tslib_1.__metadata("design:type", Object)
], QuickFileSelectService.prototype, "fsPreferences", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], QuickFileSelectService.prototype, "preferences", void 0);
exports.QuickFileSelectService = QuickFileSelectService = QuickFileSelectService_1 = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], QuickFileSelectService);
/**
 * Normalize a given string.
 *
 * @param str the raw string value.
 * @returns the normalized string value.
 */
function normalize(str) {
    return str.trim().toLowerCase();
}
function compareWithDiscriminators(left, right, ...discriminators) {
    let comparisonValue = 0;
    let i = 0;
    while (comparisonValue === 0 && i < discriminators.length) {
        comparisonValue = discriminators[i](left, right);
        i++;
    }
    return comparisonValue;
}


/***/ }),

/***/ "../../node_modules/@theia/file-search/lib/common/file-search-service.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@theia/file-search/lib/common/file-search-service.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.WHITESPACE_QUERY_SEPARATOR = exports.FileSearchService = exports.fileSearchServicePath = void 0;
exports.fileSearchServicePath = '/services/search';
exports.FileSearchService = Symbol('FileSearchService');
exports.WHITESPACE_QUERY_SEPARATOR = /\s+/;


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_file-search_lib_browser_quick-file-select-service_js.js.map