/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.Unsigned;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class AnnotationConstruct {
    private List<AnnotationElement> annotationElements = Collections.emptyList();
    private byte unsignedFlag = (byte)-1;

    public AnnotationConstruct(List<AnnotationElement> list) {
        this.annotationElements = list;
    }

    public AnnotationConstruct() {
    }

    public void setAnnotationElements(List<AnnotationElement> list) {
        this.annotationElements = Utils.smallUnmodifiable(list);
    }

    public String getLabel() {
        Label label = (Label)this.getAnnotation(Label.class);
        if (label == null) {
            return null;
        }
        return label.value();
    }

    public String getDescription() {
        Description description = (Description)this.getAnnotation(Description.class);
        if (description == null) {
            return null;
        }
        return description.value();
    }

    public final <T> T getAnnotation(Class<? extends Annotation> clazz) {
        AnnotationElement annotationElement = this.getAnnotationElement(clazz);
        if (annotationElement != null) {
            return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AnnotationInvokationHandler(annotationElement));
        }
        return null;
    }

    public List<AnnotationElement> getUnmodifiableAnnotationElements() {
        return this.annotationElements;
    }

    boolean remove(AnnotationElement annotationElement) {
        return this.annotationElements.remove(annotationElement);
    }

    private AnnotationElement getAnnotationElement(Class<? extends Annotation> clazz) {
        long l = Type.getTypeId(clazz);
        String string = clazz.getName();
        for (AnnotationElement annotationElement : this.getUnmodifiableAnnotationElements()) {
            if (annotationElement.getTypeId() != l || !annotationElement.getTypeName().equals(string)) continue;
            return annotationElement;
        }
        for (AnnotationElement annotationElement : this.getUnmodifiableAnnotationElements()) {
            if (!annotationElement.getTypeName().equals(string)) continue;
            return annotationElement;
        }
        return null;
    }

    public boolean hasUnsigned() {
        if (this.unsignedFlag < 0) {
            Unsigned unsigned = (Unsigned)this.getAnnotation(Unsigned.class);
            this.unsignedFlag = (byte)(unsigned != null ? 1 : 0);
        }
        return this.unsignedFlag == 1;
    }

    private static final class AnnotationInvokationHandler
    implements InvocationHandler {
        private final AnnotationElement annotationElement;

        AnnotationInvokationHandler(AnnotationElement annotationElement) {
            this.annotationElement = annotationElement;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            String string = method.getName();
            int n = method.getTypeParameters().length;
            if (n == 0 && this.annotationElement.hasValue(string)) {
                return this.annotationElement.getValue(string);
            }
            throw new UnsupportedOperationException("Flight Recorder proxy only supports members declared in annotation interfaces, i.e. not toString, equals etc.");
        }
    }
}

