/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

final class WDesktopPeer
implements DesktopPeer {
    private static final String ACTION_OPEN_VERB = "open";
    private static final String ACTION_EDIT_VERB = "edit";
    private static final String ACTION_PRINT_VERB = "print";
    private static final String ACTION_BROWSE_VERB = "browse";
    private static final String ACTION_MAIL_VERB = "mail";

    WDesktopPeer() {
    }

    @Override
    public boolean isSupported(Desktop.Action action) {
        return true;
    }

    @Override
    public void open(File file) throws IOException {
        this.ShellExecute(file, ACTION_OPEN_VERB);
    }

    @Override
    public void edit(File file) throws IOException {
        this.ShellExecute(file, ACTION_EDIT_VERB);
    }

    @Override
    public void print(File file) throws IOException {
        this.ShellExecute(file, ACTION_PRINT_VERB);
    }

    @Override
    public void mail(URI uRI) throws IOException {
        this.ShellExecute(uRI, ACTION_MAIL_VERB);
    }

    @Override
    public void browse(URI uRI) throws IOException {
        this.launchUriInBrowser(uRI);
    }

    private void ShellExecute(File file, String string) throws IOException {
        String string2 = WDesktopPeer.ShellExecute(file.getAbsolutePath(), string);
        if (string2 != null) {
            throw new IOException("Failed to " + string + " " + file + ". Error message: " + string2);
        }
    }

    private void ShellExecute(URI uRI, String string) throws IOException {
        String string2 = WDesktopPeer.ShellExecute(uRI.toString(), string);
        if (string2 != null) {
            throw new IOException("Failed to " + string + " " + uRI + ". Error message: " + string2);
        }
    }

    private void launchUriInBrowser(URI uRI) throws IOException {
        String string = WDesktopPeer.getDefaultBrowser();
        if (string == null) {
            throw new IOException("Failed to get default browser");
        }
        List<String> list = WDesktopPeer.getCmdLineTokens(uRI, string);
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(list);
            processBuilder.start();
        }
        catch (Exception exception) {
            throw new IOException("Error launching Browser: ", exception);
        }
    }

    private static List<String> getCmdLineTokens(URI uRI, String string) {
        string = string.contains("%1") ? string.replace("%1", uRI.toString()) : string + " " + uRI.toString();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf("\"");
        int n2 = string.indexOf("\"", n + 1);
        if (n == 0 && n2 != n) {
            arrayList.add(string.substring(n, n2 + 1));
            string = string.substring(n2 + 1).trim();
        }
        arrayList.addAll(Arrays.asList(string.split(" ")));
        return arrayList;
    }

    private static native String getDefaultBrowser();

    private static native String ShellExecute(String var0, String var1);
}

