/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.net.URI;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Extension;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class PKIXRevocationChecker
extends PKIXCertPathChecker {
    private URI ocspResponder;
    private X509Certificate ocspResponderCert;
    private List<Extension> ocspExtensions = Collections.emptyList();
    private Map<X509Certificate, byte[]> ocspResponses = Collections.emptyMap();
    private Set<Option> options = Collections.emptySet();

    protected PKIXRevocationChecker() {
    }

    public void setOcspResponder(URI uRI) {
        this.ocspResponder = uRI;
    }

    public URI getOcspResponder() {
        return this.ocspResponder;
    }

    public void setOcspResponderCert(X509Certificate x509Certificate) {
        this.ocspResponderCert = x509Certificate;
    }

    public X509Certificate getOcspResponderCert() {
        return this.ocspResponderCert;
    }

    public void setOcspExtensions(List<Extension> list) {
        this.ocspExtensions = list == null ? Collections.emptyList() : new ArrayList<Extension>(list);
    }

    public List<Extension> getOcspExtensions() {
        return Collections.unmodifiableList(this.ocspExtensions);
    }

    public void setOcspResponses(Map<X509Certificate, byte[]> map) {
        if (map == null) {
            this.ocspResponses = Collections.emptyMap();
        } else {
            HashMap<X509Certificate, byte[]> hashMap = new HashMap<X509Certificate, byte[]>(map.size());
            for (Map.Entry<X509Certificate, byte[]> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), (byte[])entry.getValue().clone());
            }
            this.ocspResponses = hashMap;
        }
    }

    public Map<X509Certificate, byte[]> getOcspResponses() {
        HashMap<X509Certificate, byte[]> hashMap = new HashMap<X509Certificate, byte[]>(this.ocspResponses.size());
        for (Map.Entry<X509Certificate, byte[]> entry : this.ocspResponses.entrySet()) {
            hashMap.put(entry.getKey(), (byte[])entry.getValue().clone());
        }
        return hashMap;
    }

    public void setOptions(Set<Option> set) {
        this.options = set == null ? Collections.emptySet() : new HashSet<Option>(set);
    }

    public Set<Option> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    public abstract List<CertPathValidatorException> getSoftFailExceptions();

    @Override
    public PKIXRevocationChecker clone() {
        PKIXRevocationChecker pKIXRevocationChecker = (PKIXRevocationChecker)super.clone();
        pKIXRevocationChecker.ocspExtensions = new ArrayList<Extension>(this.ocspExtensions);
        pKIXRevocationChecker.ocspResponses = new HashMap<X509Certificate, byte[]>(this.ocspResponses);
        for (Map.Entry<X509Certificate, byte[]> entry : pKIXRevocationChecker.ocspResponses.entrySet()) {
            byte[] byArray = entry.getValue();
            entry.setValue((byte[])byArray.clone());
        }
        pKIXRevocationChecker.options = new HashSet<Option>(this.options);
        return pKIXRevocationChecker;
    }

    public static enum Option {
        ONLY_END_ENTITY,
        PREFER_CRLS,
        NO_FALLBACK,
        SOFT_FAIL;

    }
}

