/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.util.Enumeration;
import java.util.Vector;
import jdk.test.lib.hprof.model.JavaField;
import jdk.test.lib.hprof.model.JavaHeapObject;
import jdk.test.lib.hprof.model.JavaHeapObjectVisitor;
import jdk.test.lib.hprof.model.JavaObjectRef;
import jdk.test.lib.hprof.model.JavaStatic;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.Root;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.model.StackTrace;
import jdk.test.lib.hprof.parser.ReadBuffer;
import jdk.test.lib.hprof.util.CompositeEnumeration;

public class JavaClass
extends JavaHeapObject {
    private long id;
    private String name;
    private JavaThing superclass;
    private JavaThing loader;
    private JavaThing signers;
    private JavaThing protectionDomain;
    private JavaField[] fields;
    private JavaStatic[] statics;
    private static final JavaClass[] EMPTY_CLASS_ARRAY = new JavaClass[0];
    private JavaClass[] subclasses = EMPTY_CLASS_ARRAY;
    private Vector<JavaHeapObject> instances = new Vector();
    private Snapshot mySnapshot;
    private int instanceSize;
    private int totalNumFields;

    public JavaClass(long id, String name, long superclassId, long loaderId, long signersId, long protDomainId, JavaField[] fields, JavaStatic[] statics, int instanceSize) {
        this.id = id;
        this.name = name;
        this.superclass = new JavaObjectRef(superclassId);
        this.loader = new JavaObjectRef(loaderId);
        this.signers = new JavaObjectRef(signersId);
        this.protectionDomain = new JavaObjectRef(protDomainId);
        this.fields = fields;
        this.statics = statics;
        this.instanceSize = instanceSize;
    }

    public JavaClass(String name, long superclassId, long loaderId, long signersId, long protDomainId, JavaField[] fields, JavaStatic[] statics, int instanceSize) {
        this(-1L, name, superclassId, loaderId, signersId, protDomainId, fields, statics, instanceSize);
    }

    @Override
    public final JavaClass getClazz() {
        return this.mySnapshot.getJavaLangClass();
    }

    public final int getIdentifierSize() {
        return this.mySnapshot.getIdentifierSize();
    }

    public final int getMinimumObjectSize() {
        return this.mySnapshot.getMinimumObjectSize();
    }

    @Override
    public void resolve(Snapshot snapshot) {
        if (this.mySnapshot != null) {
            return;
        }
        this.mySnapshot = snapshot;
        this.resolveSuperclass(snapshot);
        if (this.superclass != null) {
            ((JavaClass)this.superclass).addSubclass(this);
        }
        this.loader = this.loader.dereference(snapshot, null);
        this.signers = this.signers.dereference(snapshot, null);
        this.protectionDomain = this.protectionDomain.dereference(snapshot, null);
        for (int i = 0; i < this.statics.length; ++i) {
            this.statics[i].resolve(this, snapshot);
        }
        snapshot.getJavaLangClass().addInstance(this);
        super.resolve(snapshot);
    }

    public void resolveSuperclass(Snapshot snapshot) {
        if (this.superclass != null) {
            this.totalNumFields = this.fields.length;
            this.superclass = this.superclass.dereference(snapshot, null);
            if (this.superclass == snapshot.getNullThing()) {
                this.superclass = null;
            } else {
                try {
                    JavaClass sc = (JavaClass)this.superclass;
                    sc.resolveSuperclass(snapshot);
                    this.totalNumFields += sc.totalNumFields;
                }
                catch (ClassCastException ex) {
                    System.out.println("Warning!  Superclass of " + this.name + " is " + String.valueOf(this.superclass));
                    this.superclass = null;
                }
            }
        }
    }

    public boolean isString() {
        return this.mySnapshot.getJavaLangString() == this;
    }

    public boolean isClassLoader() {
        return this.mySnapshot.getJavaLangClassLoader().isAssignableFrom(this);
    }

    public JavaField getField(int i) {
        if (i < 0 || i >= this.fields.length) {
            throw new Error("No field " + i + " for " + this.name);
        }
        return this.fields[i];
    }

    public int getNumFieldsForInstance() {
        return this.totalNumFields;
    }

    public JavaField getFieldForInstance(int i) {
        if (this.superclass != null) {
            JavaClass sc = (JavaClass)this.superclass;
            if (i < sc.totalNumFields) {
                return sc.getFieldForInstance(i);
            }
            i -= sc.totalNumFields;
        }
        return this.getField(i);
    }

    public JavaClass getClassForField(int i) {
        if (this.superclass != null) {
            JavaClass sc = (JavaClass)this.superclass;
            if (i < sc.totalNumFields) {
                return sc.getClassForField(i);
            }
        }
        return this;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArray() {
        return this.name.indexOf(91) != -1;
    }

    public Enumeration<JavaHeapObject> getInstances(boolean includeSubclasses) {
        if (includeSubclasses) {
            CompositeEnumeration res = this.instances.elements();
            for (int i = 0; i < this.subclasses.length; ++i) {
                res = new CompositeEnumeration(res, this.subclasses[i].getInstances(true));
            }
            return res;
        }
        return this.instances.elements();
    }

    public int getInstancesCount(boolean includeSubclasses) {
        int result = this.instances.size();
        if (includeSubclasses) {
            for (int i = 0; i < this.subclasses.length; ++i) {
                result += this.subclasses[i].getInstancesCount(includeSubclasses);
            }
        }
        return result;
    }

    public JavaClass[] getSubclasses() {
        return this.subclasses;
    }

    public JavaClass getSuperclass() {
        return (JavaClass)this.superclass;
    }

    public JavaThing getLoader() {
        return this.loader;
    }

    public boolean isBootstrap() {
        return this.loader == this.mySnapshot.getNullThing();
    }

    public JavaThing getSigners() {
        return this.signers;
    }

    public JavaThing getProtectionDomain() {
        return this.protectionDomain;
    }

    public JavaField[] getFields() {
        return this.fields;
    }

    public JavaField[] getFieldsForInstance() {
        Vector<JavaField> v = new Vector<JavaField>();
        this.addFields(v);
        JavaField[] result = new JavaField[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            result[i] = v.elementAt(i);
        }
        return result;
    }

    public JavaStatic[] getStatics() {
        return this.statics;
    }

    public JavaThing getStaticField(String name) {
        for (int i = 0; i < this.statics.length; ++i) {
            JavaStatic s = this.statics[i];
            if (!s.getField().getName().equals(name)) continue;
            return s.getValue();
        }
        return null;
    }

    @Override
    public String toString() {
        return "class " + this.name;
    }

    @Override
    public int compareTo(JavaThing other) {
        if (other instanceof JavaClass) {
            return this.name.compareTo(((JavaClass)other).name);
        }
        return super.compareTo(other);
    }

    public boolean isAssignableFrom(JavaClass other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.isAssignableFrom((JavaClass)other.superclass);
    }

    @Override
    public String describeReferenceTo(JavaThing target, Snapshot ss) {
        for (int i = 0; i < this.statics.length; ++i) {
            JavaThing other;
            JavaField f = this.statics[i].getField();
            if (!f.hasId() || (other = this.statics[i].getValue()) != target) continue;
            return "static field " + f.getName();
        }
        return super.describeReferenceTo(target, ss);
    }

    public int getInstanceSize() {
        return this.instanceSize + this.mySnapshot.getMinimumObjectSize();
    }

    public long getTotalInstanceSize() {
        int count = this.instances.size();
        if (count == 0 || !this.isArray()) {
            return count * this.instanceSize;
        }
        long result = 0L;
        for (int i = 0; i < count; ++i) {
            JavaThing t = this.instances.elementAt(i);
            result += t.getSize();
        }
        return result;
    }

    @Override
    public long getSize() {
        JavaClass cl = this.mySnapshot.getJavaLangClass();
        if (cl == null) {
            return 0L;
        }
        return cl.getInstanceSize();
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        JavaThing other;
        super.visitReferencedObjects(v);
        JavaClass sc = this.getSuperclass();
        if (sc != null) {
            v.visit(this.getSuperclass());
        }
        if ((other = this.getLoader()) instanceof JavaHeapObject) {
            v.visit((JavaHeapObject)other);
        }
        if ((other = this.getSigners()) instanceof JavaHeapObject) {
            v.visit((JavaHeapObject)other);
        }
        if ((other = this.getProtectionDomain()) instanceof JavaHeapObject) {
            v.visit((JavaHeapObject)other);
        }
        for (int i = 0; i < this.statics.length; ++i) {
            JavaField f = this.statics[i].getField();
            if (v.exclude(this, f) || !f.hasId() || !((other = this.statics[i].getValue()) instanceof JavaHeapObject)) continue;
            v.visit((JavaHeapObject)other);
        }
    }

    final ReadBuffer getReadBuffer() {
        return this.mySnapshot.getReadBuffer();
    }

    final void setNew(JavaHeapObject obj, boolean flag) {
        this.mySnapshot.setNew(obj, flag);
    }

    final boolean isNew(JavaHeapObject obj) {
        return this.mySnapshot.isNew(obj);
    }

    final StackTrace getSiteTrace(JavaHeapObject obj) {
        return this.mySnapshot.getSiteTrace(obj);
    }

    final void addReferenceFromRoot(Root root, JavaHeapObject obj) {
        this.mySnapshot.addReferenceFromRoot(root, obj);
    }

    final Root getRoot(JavaHeapObject obj) {
        return this.mySnapshot.getRoot(obj);
    }

    final Snapshot getSnapshot() {
        return this.mySnapshot;
    }

    void addInstance(JavaHeapObject inst) {
        this.instances.addElement(inst);
    }

    private void addFields(Vector<JavaField> v) {
        if (this.superclass != null) {
            ((JavaClass)this.superclass).addFields(v);
        }
        for (int i = 0; i < this.fields.length; ++i) {
            v.addElement(this.fields[i]);
        }
    }

    private void addSubclassInstances(Vector<JavaHeapObject> v) {
        int i;
        for (i = 0; i < this.subclasses.length; ++i) {
            this.subclasses[i].addSubclassInstances(v);
        }
        for (i = 0; i < this.instances.size(); ++i) {
            v.addElement(this.instances.elementAt(i));
        }
    }

    private void addSubclass(JavaClass sub) {
        JavaClass[] newValue = new JavaClass[this.subclasses.length + 1];
        System.arraycopy(this.subclasses, 0, newValue, 0, this.subclasses.length);
        newValue[this.subclasses.length] = sub;
        this.subclasses = newValue;
    }
}

