/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UIBuilder {

    public static class DialogBuilder {
        private JDialog dialog = new JDialog(new JFrame());
        private JTextArea instructionsText;
        private JTextArea messageText;
        private JButton pass;
        private JButton fail;

        public DialogBuilder() {
            this.dialog.setDefaultCloseOperation(0);
            this.instructionsText = new JTextArea("", 5, 100);
            this.dialog.add("North", new JScrollPane(this.instructionsText, 22, 32));
            this.messageText = new JTextArea("", 20, 100);
            this.dialog.add("Center", new JScrollPane(this.messageText, 22, 32));
            JPanel buttons = new JPanel();
            this.pass = new JButton("pass");
            this.pass.setActionCommand("pass");
            buttons.add("East", this.pass);
            this.fail = new JButton("fail");
            this.fail.setActionCommand("fail");
            buttons.add("West", this.fail);
            this.dialog.add("South", buttons);
        }

        public DialogBuilder setTitle(String title) {
            this.dialog.setTitle(title);
            return this;
        }

        public DialogBuilder setInstruction(String instruction) {
            this.instructionsText.setText("Test instructions:\n" + instruction);
            return this;
        }

        public DialogBuilder setMessage(String message) {
            this.messageText.setText(message);
            return this;
        }

        public DialogBuilder setPassAction(ActionListener action) {
            this.pass.addActionListener(action);
            return this;
        }

        public DialogBuilder setFailAction(ActionListener action) {
            this.fail.addActionListener(action);
            return this;
        }

        public DialogBuilder setCloseAction(final Runnable action) {
            this.dialog.addWindowListener(new WindowAdapter(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    super.windowClosing(e);
                    action.run();
                }
            });
            return this;
        }

        public JDialog build() {
            this.dialog.pack();
            return this.dialog;
        }
    }
}

