/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.util;

import java.util.Vector;
import jdk.test.lib.hprof.util.Comparer;

public class VectorSorter {
    public static void sort(Vector<Object> v, Comparer c) {
        VectorSorter.quickSort(v, c, 0, v.size() - 1);
    }

    public static void sortVectorOfStrings(Vector<Object> v) {
        VectorSorter.sort(v, new Comparer(){

            @Override
            public int compare(Object lhs, Object rhs) {
                return ((String)lhs).compareTo((String)rhs);
            }
        });
    }

    private static void swap(Vector<Object> v, int a, int b) {
        Object tmp = v.elementAt(a);
        v.setElementAt(v.elementAt(b), a);
        v.setElementAt(tmp, b);
    }

    private static void quickSort(Vector<Object> v, Comparer c, int from, int to) {
        if (to <= from) {
            return;
        }
        int mid = (from + to) / 2;
        if (mid != from) {
            VectorSorter.swap(v, mid, from);
        }
        Object pivot = v.elementAt(from);
        int highestBelowPivot = from - 1;
        int low = from + 1;
        int high = to;
        while (low <= high) {
            int c2;
            int cmp = c.compare(v.elementAt(low), pivot);
            if (cmp <= 0) {
                if (cmp < 0) {
                    highestBelowPivot = low;
                }
                ++low;
                continue;
            }
            while ((c2 = c.compare(v.elementAt(high), pivot)) > 0 && low <= --high) {
            }
            if (low > high) continue;
            VectorSorter.swap(v, low, high);
            if (c2 < 0) {
                highestBelowPivot = low;
            }
            ++low;
            --high;
        }
        if (highestBelowPivot > from) {
            VectorSorter.swap(v, from, highestBelowPivot);
            VectorSorter.quickSort(v, c, from, highestBelowPivot - 1);
        }
        VectorSorter.quickSort(v, c, high + 1, to);
    }
}

