/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.jaxws;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.xml.transform.TransformerException;
import org.eclipse.scout.sdk.core.java.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.java.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.util.maven.MavenBuild;
import org.eclipse.scout.sdk.core.s.util.maven.MavenRunner;
import org.eclipse.scout.sdk.core.s.util.maven.Pom;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.core.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JaxWsModuleNewHelper {
    private JaxWsModuleNewHelper() {
    }

    public static Path getParentPomOf(Path modulePomFile, Document modulePomDocument) {
        Path grandParentDir;
        Optional relPat;
        Optional parent = Xml.firstChildElement((Node)modulePomDocument.getDocumentElement(), (String)"parent");
        if (parent.isPresent() && (relPat = Xml.firstChildElement((Node)((Node)parent.orElseThrow()), (String)"relativePath")).isPresent()) {
            Path parentDir;
            Object path = ((Element)relPat.orElseThrow()).getTextContent();
            if (Strings.isBlank((CharSequence)path)) {
                return null;
            }
            if (!((String)path).endsWith("pom.xml")) {
                if (((String)path).charAt(((String)path).length() - 1) != '/') {
                    path = (String)path + "/";
                }
                path = (String)path + "pom.xml";
            }
            if ((parentDir = modulePomFile.getParent()) != null) {
                return parentDir.resolve((String)path).normalize();
            }
            return null;
        }
        Path parentDir = modulePomFile.getParent();
        if (parentDir != null && (grandParentDir = parentDir.getParent()) != null) {
            return grandParentDir.resolve("pom.xml");
        }
        return null;
    }

    public static Path getParentPomOf(Path projectPomFile) throws IOException {
        return JaxWsModuleNewHelper.getParentPomOf(projectPomFile, Xml.get((Path)projectPomFile));
    }

    public static Path createModule(Path targetModulePomFile, String artifactId, IEnvironment env, IProgress progress) throws IOException {
        return JaxWsModuleNewHelper.createModuleImpl(targetModulePomFile, artifactId, env, progress);
    }

    static String scoutVersionOfModule(Path targetModulePomFile, IEnvironment env) {
        Path serverModuleDir = targetModulePomFile.getParent();
        return ScoutApi.version(serverModuleDir, env).map(ApiVersion::asString).orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot compute Scout version of module at '{}'.", (Object[])new Object[]{serverModuleDir}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Path createModuleImpl(Path targetModulePomFile, String artifactId, IEnvironment env, IProgress progress) throws IOException {
        String createdProjectName;
        Ensure.isFile((Path)targetModulePomFile, (CharSequence)"Target module pom file '{}' could not be found.", (Object[])new Object[]{targetModulePomFile});
        Path parentDir = Ensure.isDirectory((Path)targetModulePomFile.getParent(), (CharSequence)"Unknown module structure. Cannot find parent of pom '{}'.", (Object[])new Object[]{targetModulePomFile});
        Path targetDirectory = Ensure.isDirectory((Path)parentDir.getParent(), (CharSequence)"Unknown module structure. Cannot find parent of '{}'.", (Object[])new Object[]{parentDir});
        Ensure.notBlank((CharSequence)artifactId);
        Document targetModulePomDocument = Xml.get((Path)targetModulePomFile);
        String groupId = Pom.groupId(targetModulePomDocument).orElseThrow(() -> Ensure.newFail((CharSequence)"Unable to calculate {} for new module.", (Object[])new Object[]{"groupId"}));
        String version = Pom.version(targetModulePomDocument).orElseThrow(() -> Ensure.newFail((CharSequence)"Unable to calculate {} for new module.", (Object[])new Object[]{"version"}));
        String parentArtifactId = Pom.parentArtifactId(targetModulePomDocument).orElseThrow(() -> Ensure.newFail((CharSequence)"Unable to calculate parent for new module.", (Object[])new Object[0]));
        String displayName = Xml.firstChildElement((Node)targetModulePomDocument.getDocumentElement(), (String)"name").map(Node::getTextContent).orElse("Server Web Services");
        Path tempDirectory = Files.createTempDirectory("jaxws-module-tmp", new FileAttribute[0]);
        try {
            MavenBuild archetypeBuild = new MavenBuild().withWorkingDirectory(tempDirectory).withGoal("archetype:generate").withProperty("interactiveMode", "false").withProperty("archetypeGroupId", "org.eclipse.scout.archetypes").withProperty("archetypeArtifactId", "scout-jaxws-module").withProperty("archetypeVersion", JaxWsModuleNewHelper.scoutVersionOfModule(targetModulePomFile, env)).withProperty("groupId", groupId).withProperty("artifactId", artifactId).withProperty("version", version).withProperty("package", "not.used").withProperty("displayName", displayName).withProperty("parentArtifactId", parentArtifactId);
            MavenRunner.execute(archetypeBuild, env, progress);
            try (Stream<Path> files = Files.list(tempDirectory);){
                Path createdProjectDir = files.findAny().orElseThrow(() -> new IOException("Created project dir not found. Project creation failed."));
                JaxWsModuleNewHelper.deleteGitKeepFiles(createdProjectDir);
                Files.createDirectories(createdProjectDir.resolve("target/generated-sources/wsimport"), new FileAttribute[0]);
                Files.createDirectories(createdProjectDir.resolve("target/generated-sources/annotations"), new FileAttribute[0]);
                createdProjectName = createdProjectDir.getFileName().toString();
                CoreUtils.moveDirectory((Path)createdProjectDir, (Path)targetDirectory);
            }
        }
        finally {
            CoreUtils.deleteDirectory((Path)tempDirectory);
        }
        JaxWsModuleNewHelper.registerNewModuleInParent(targetModulePomFile, targetModulePomDocument, groupId, artifactId, version, parentArtifactId);
        JaxWsModuleNewHelper.addDependencyToTargetModule(targetModulePomFile, groupId, artifactId);
        return targetDirectory.resolve(createdProjectName);
    }

    static void deleteGitKeepFiles(Path createdProjectDir) throws IOException {
        Files.delete(Ensure.isFile((Path)createdProjectDir.resolve("src/main/resources/WEB-INF/wsdl/.gitkeep")));
        Files.delete(Ensure.isFile((Path)createdProjectDir.resolve("src/main/java/.gitkeep")));
    }

    static void registerNewModuleInParent(Path targetModulePomFile, Document targetModulePom, String groupId, String artifactId, String version, String parentArtifactId) throws IOException {
        Path parentPomFile = JaxWsModuleNewHelper.getParentPomOf(targetModulePomFile, targetModulePom);
        if (parentPomFile == null || !Files.isReadable(parentPomFile) || !Files.isRegularFile(parentPomFile, new LinkOption[0])) {
            SdkLog.warning((CharSequence)"Parent pom for new JAX-WS module could not be found. New module will not be registered.", (Object[])new Object[0]);
            return;
        }
        try {
            Document parentPom = Xml.get((Path)parentPomFile);
            Element modulesElement = JaxWsUtils.getOrCreateElement(parentPom.getDocumentElement(), "modules");
            Element newModuleElement = parentPom.createElement("module");
            newModuleElement.setTextContent("../" + artifactId);
            modulesElement.appendChild(newModuleElement);
            Element dependencyManagementElement = JaxWsUtils.getOrCreateElement(parentPom.getDocumentElement(), "dependencyManagement");
            Element dependenciesElement = JaxWsUtils.getOrCreateElement(dependencyManagementElement, "dependencies");
            Element newDependencyElement = JaxWsModuleNewHelper.createDependencyElement(groupId, artifactId, parentPom);
            dependenciesElement.appendChild(newDependencyElement);
            Element newVersionElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "version");
            Optional properties = Xml.firstChildElement((Node)parentPom.getDocumentElement(), (String)"properties");
            if (properties.isPresent()) {
                String[] suffixes = new String[]{".version", "_version"};
                Arrays.stream(suffixes).map(suffix -> groupId + "." + parentArtifactId + suffix).filter(versionPropertyName -> Xml.firstChildElement((Node)((Node)properties.orElseThrow()), (String)versionPropertyName).isPresent()).findFirst().ifPresent(versionPropertyName -> newVersionElement.setTextContent("${" + versionPropertyName + "}"));
            }
            if (Strings.isEmpty((CharSequence)newVersionElement.getTextContent())) {
                newVersionElement.setTextContent(version);
            }
            Xml.writeDocument((Document)parentPom, (boolean)true, (Path)parentPomFile);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }

    private static Element createDependencyElement(String groupId, String artifactId, Document parentPom) {
        Element newDependencyElement = parentPom.createElement("dependency");
        Element newGroupIdElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "groupId");
        newGroupIdElement.setTextContent(groupId);
        Element newArtifactIdElement = JaxWsUtils.getOrCreateElement(newDependencyElement, "artifactId");
        newArtifactIdElement.setTextContent(artifactId);
        return newDependencyElement;
    }

    static void addDependencyToTargetModule(Path targetModulePomFile, String groupId, String artifactId) throws IOException {
        try {
            Document pom = Xml.get((Path)targetModulePomFile);
            Element dependenciesElement = JaxWsUtils.getOrCreateElement(pom.getDocumentElement(), "dependencies");
            Element dependencyElement = JaxWsModuleNewHelper.createDependencyElement(groupId, artifactId, pom);
            dependenciesElement.appendChild(dependencyElement);
            Xml.writeDocument((Document)pom, (boolean)true, (Path)targetModulePomFile);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
    }
}

