/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.util;

import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class XSDTypeDefinitionUtil {
    private XSDTypeDefinitionUtil() {
    }

    public static boolean isXSDBuiltInTypeDefinition(XSDTypeDefinition type) {
        if (type == null) {
            return false;
        }
        String ns = type.getTargetNamespace();
        return ns != null && ns.equals("http://www.w3.org/2001/XMLSchema");
    }

    public static boolean isRootTypeDefinition(XSDTypeDefinition type) {
        if (type == null) {
            return true;
        }
        XSDTypeDefinition baseType = type.getBaseType();
        if (baseType == null) {
            return true;
        }
        String typeNS = type.getTargetNamespace();
        String baseTypeNS = baseType.getTargetNamespace();
        String typeName = type.getName();
        String baseTypeName = baseType.getName();
        boolean sameNS = typeNS == null && baseTypeNS == null ? true : typeNS != null && baseTypeNS != null && typeNS.equals(baseTypeNS);
        boolean sameName = typeName == null && baseTypeName == null ? true : typeName != null && baseTypeName != null && typeName.equals(baseTypeName);
        return sameNS && sameName;
    }

    public static XSDTypeDefinition resolveToXSDBuiltInTypeDefinition(XSDTypeDefinition type) {
        if (type == null) {
            return null;
        }
        XSDTypeDefinition currType = type;
        while (!XSDTypeDefinitionUtil.isXSDBuiltInTypeDefinition(currType)) {
            if (XSDTypeDefinitionUtil.isRootTypeDefinition(currType)) {
                return null;
            }
            currType = currType.getBaseType();
        }
        return currType;
    }

    public static boolean isSoapEncArray(XSDTypeDefinition type) {
        XSDTypeDefinition currType = type;
        if (currType != null) {
            while (currType != null) {
                String ns = currType.getTargetNamespace();
                String name = currType.getName();
                if ("http://schemas.xmlsoap.org/soap/encoding/".equals(ns) && "Array".equals(name)) {
                    return true;
                }
                if (XSDTypeDefinitionUtil.isRootTypeDefinition(currType)) {
                    return false;
                }
                currType = currType.getBaseType();
            }
        }
        return false;
    }

    public static XSDComplexTypeContent getXSDComplexTypeContent(XSDComplexTypeDefinition complexType) {
        if (!XSDTypeDefinitionUtil.isXSDBuiltInTypeDefinition((XSDTypeDefinition)complexType)) {
            XSDComplexTypeDefinition type = complexType;
            while (!XSDTypeDefinitionUtil.isXSDBuiltInTypeDefinition((XSDTypeDefinition)type) && type instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeContent complexTypeContent = type.getContent();
                if (complexTypeContent != null) {
                    return complexTypeContent;
                }
                if (XSDTypeDefinitionUtil.isRootTypeDefinition((XSDTypeDefinition)type)) {
                    return null;
                }
                type = type.getBaseType();
            }
            return null;
        }
        return complexType.getContent();
    }
}

