/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.util.search;

import java.nio.file.Path;
import java.util.function.Supplier;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class FileQueryInput {
    private final Path m_file;
    private final Path m_module;
    private final String m_extension;
    private final Supplier<CharSequence> m_fileContentLoader;
    private final FinalValue<CharSequence> m_fileContent;

    public FileQueryInput(Path file, Path module, Supplier<CharSequence> fileContentLoader) {
        this.m_file = (Path)Ensure.notNull((Object)file);
        this.m_module = (Path)Ensure.notNull((Object)module);
        this.m_fileContentLoader = (Supplier)Ensure.notNull(fileContentLoader);
        this.m_fileContent = new FinalValue();
        this.m_extension = CoreUtils.extensionOf((Path)file);
    }

    public Path file() {
        return this.m_file;
    }

    public Path module() {
        return this.m_module;
    }

    public String fileExtension() {
        return this.m_extension;
    }

    public CharSequence fileContent() {
        return (CharSequence)this.m_fileContent.computeIfAbsentAndGet(this.m_fileContentLoader);
    }

    public String toString() {
        return FileQueryInput.class.getSimpleName() + " [file=" + this.m_file + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileQueryInput that = (FileQueryInput)o;
        return this.m_file.equals(that.m_file);
    }

    public int hashCode() {
        return this.m_file.hashCode();
    }
}

