/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiComparators;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiDuration;

public class LamiDurationAspect
extends LamiGenericAspect {
    public LamiDurationAspect(String colName, int colIndex) {
        super(colName, "ns", colIndex, true, false);
    }

    @Override
    public boolean isTimeDuration() {
        return true;
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        Number n = this.resolveNumber(entry);
        if (n == null) {
            return String.valueOf(entry.getValue(this.getColIndex()));
        }
        return n.toString();
    }

    @Override
    public @Nullable Number resolveNumber(@NonNull LamiTableEntry entry) {
        LamiData data = entry.getValue(this.getColIndex());
        if (data instanceof LamiDuration) {
            LamiDuration duration = (LamiDuration)data;
            return duration.getValue();
        }
        return null;
    }

    @Override
    public @NonNull Comparator<@NonNull LamiTableEntry> getComparator() {
        return LamiComparators.getLongComparator(this::resolveNumber);
    }
}

