/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.meson.ui;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.internal.meson.ui.Messages;
import org.eclipse.cdt.internal.meson.ui.NewMesonToolChainFileWizard;
import org.eclipse.cdt.meson.core.Activator;
import org.eclipse.cdt.meson.core.IMesonToolChainFile;
import org.eclipse.cdt.meson.core.IMesonToolChainManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class MesonPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private IMesonToolChainManager manager;
    private Table filesTable;
    private Button removeButton;
    private Map<Path, IMesonToolChainFile> filesToAdd = new HashMap<Path, IMesonToolChainFile>();
    private Map<Path, IMesonToolChainFile> filesToRemove = new HashMap<Path, IMesonToolChainFile>();

    public void init(IWorkbench workbench) {
        this.manager = (IMesonToolChainManager)Activator.getService(IMesonToolChainManager.class);
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Group filesGroup = new Group(control, 0);
        filesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        filesGroup.setText(Messages.MesonPreferencePage_Files);
        filesGroup.setLayout((Layout)new GridLayout(2, false));
        Composite filesComp = new Composite((Composite)filesGroup, 0);
        filesComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filesTable = new Table(filesComp, 68100);
        this.filesTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.filesTable.setHeaderVisible(true);
        this.filesTable.setLinesVisible(true);
        this.filesTable.addListener(13, e -> {
            TableItem[] items = this.filesTable.getSelection();
            this.removeButton.setEnabled(items.length > 0);
        });
        TableColumn pathColumn = new TableColumn(this.filesTable, 0);
        pathColumn.setText(Messages.MesonPreferencePage_Path);
        TableColumn tcColumn = new TableColumn(this.filesTable, 0);
        tcColumn.setText(Messages.MesonPreferencePage_Toolchain);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)pathColumn, (ColumnLayoutData)new ColumnWeightData(50, 350, true));
        tableLayout.setColumnData((Widget)tcColumn, (ColumnLayoutData)new ColumnWeightData(50, 350, true));
        filesComp.setLayout((Layout)tableLayout);
        Composite buttonsComp = new Composite((Composite)filesGroup, 0);
        buttonsComp.setLayoutData((Object)new GridData(4, 4, false, true));
        buttonsComp.setLayout((Layout)new GridLayout());
        Button addButton = new Button(buttonsComp, 8);
        addButton.setLayoutData((Object)new GridData(4, 4, false, false));
        addButton.setText(Messages.MesonPreferencePage_Add);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            NewMesonToolChainFileWizard wizard = new NewMesonToolChainFileWizard();
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                IMesonToolChainFile file = wizard.getNewFile();
                IMesonToolChainFile oldFile = this.manager.getToolChainFile(file.getPath());
                if (oldFile != null) {
                    this.filesToRemove.put(oldFile.getPath(), oldFile);
                }
                this.filesToAdd.put(file.getPath(), file);
                this.updateTable();
            }
        }));
        this.removeButton = new Button(buttonsComp, 8);
        this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeButton.setText(Messages.MesonPreferencePage_Remove);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, e -> {
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MesonPreferencePage_ConfirmRemoveTitle, (String)Messages.MesonPreferencePage_ConfirmRemoveDesc)) {
                TableItem[] tableItemArray = this.filesTable.getSelection();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    IMesonToolChainFile file = (IMesonToolChainFile)item.getData();
                    if (this.filesToAdd.containsKey(file.getPath())) {
                        this.filesToAdd.remove(file.getPath());
                    } else {
                        this.filesToRemove.put(file.getPath(), file);
                    }
                    this.updateTable();
                    ++n2;
                }
            }
        });
        this.updateTable();
        return control;
    }

    private void updateTable() {
        ArrayList<IMesonToolChainFile> sorted = new ArrayList<IMesonToolChainFile>(this.getFiles().values());
        Collections.sort(sorted, (o1, o2) -> o1.getPath().toString().compareToIgnoreCase(o2.getPath().toString()));
        this.filesTable.removeAll();
        for (IMesonToolChainFile file : sorted) {
            TableItem item = new TableItem(this.filesTable, 0);
            item.setText(0, file.getPath().toString());
            try {
                IToolChain tc = file.getToolChain();
                if (tc != null) {
                    item.setText(1, tc.getName());
                }
            }
            catch (CoreException e) {
                Activator.log((IStatus)e.getStatus());
            }
            item.setData((Object)file);
        }
    }

    private Map<Path, IMesonToolChainFile> getFiles() {
        HashMap<Path, IMesonToolChainFile> files = new HashMap<Path, IMesonToolChainFile>();
        for (IMesonToolChainFile file : this.manager.getToolChainFiles()) {
            files.put(file.getPath(), file);
        }
        for (IMesonToolChainFile file : this.filesToRemove.values()) {
            files.remove(file.getPath());
        }
        for (IMesonToolChainFile file : this.filesToAdd.values()) {
            files.put(file.getPath(), file);
        }
        return files;
    }

    public boolean performOk() {
        for (IMesonToolChainFile file : this.filesToRemove.values()) {
            this.manager.removeToolChainFile(file);
        }
        for (IMesonToolChainFile file : this.filesToAdd.values()) {
            this.manager.addToolChainFile(file);
        }
        this.filesToAdd.clear();
        this.filesToRemove.clear();
        return true;
    }
}

