/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ClasspathTooLongStatusHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) {
        ILaunch launch = (ILaunch)source;
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        boolean enableClasspathOnlyJar = this.askEnableClasspathOnlyJar();
        if (enableClasspathOnlyJar && launchConfiguration != null) {
            try {
                ILaunchConfigurationWorkingCopy configurationWorkingCopy = launchConfiguration.getWorkingCopy();
                configurationWorkingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_CLASSPATH_ONLY_JAR, true);
                configurationWorkingCopy.doSave();
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return enableClasspathOnlyJar;
    }

    private boolean askEnableClasspathOnlyJar() {
        final boolean[] result = new boolean[1];
        JDIDebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                String title = LauncherMessages.ClasspathTooLongStatusHandler_0;
                String message = LauncherMessages.ClasspathTooLongStatusHandler_1;
                result[0] = MessageDialog.openQuestion((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
            }
        });
        return result[0];
    }
}

