/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum GenResourceKind implements Enumerator
{
    NONE_LITERAL(0, "None", "None"),
    BASIC_LITERAL(1, "Basic", "Basic"),
    XMI_LITERAL(2, "XMI", "XMI"),
    XML_LITERAL(3, "XML", "XML");

    public static final int NONE = 0;
    public static final int BASIC = 1;
    public static final int XMI = 2;
    public static final int XML = 3;
    private static final GenResourceKind[] VALUES_ARRAY;
    public static final List<GenResourceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new GenResourceKind[]{NONE_LITERAL, BASIC_LITERAL, XMI_LITERAL, XML_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static GenResourceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenResourceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenResourceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            GenResourceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static GenResourceKind get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return BASIC_LITERAL;
            }
            case 2: {
                return XMI_LITERAL;
            }
            case 3: {
                return XML_LITERAL;
            }
        }
        return null;
    }

    private GenResourceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

