/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.swt;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.util.ImageUtil;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.osgi.framework.Bundle;

public class SharedStyleManager {
    protected Properties properties;
    protected StyleContext context;

    SharedStyleManager() {
    }

    public SharedStyleManager(IntroModelRoot modelRoot) {
        this.context = new StyleContext();
        this.context.bundle = modelRoot.getBundle();
        this.properties = new Properties();
        String[] sharedStyles = modelRoot.getPresentation().getImplementationStyles();
        if (sharedStyles != null) {
            int i = 0;
            while (i < sharedStyles.length) {
                this.load(this.properties, sharedStyles[i], this.context);
                ++i;
            }
        }
    }

    protected void load(Properties properties, String style, StyleContext context) {
        if (style == null) {
            return;
        }
        try {
            URL styleURL = new URL(style);
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream is = styleURL.openStream();){
                properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            context.path = IPath.fromOSString((String)style).removeLastSegments(1);
            String t = (String)properties.get("theme");
            if (t != null && t.trim().equalsIgnoreCase("true")) {
                context.inTheme = true;
            }
        }
        catch (Exception e) {
            Log.error("Could not load SWT style: " + style, e);
        }
    }

    public String getProperty(String key) {
        return this.doGetProperty(this.properties, key);
    }

    protected String doGetProperty(Properties aProperties, String key) {
        String value = aProperties.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    protected RGB getRGB(String key) {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        return SharedStyleManager.parseRGB(value);
    }

    public static RGB parseRGB(String value) {
        if (value.charAt(0) == '#') {
            try {
                int r = Integer.parseInt(value.substring(1, 3), 16);
                int g = Integer.parseInt(value.substring(3, 5), 16);
                int b = Integer.parseInt(value.substring(5, 7), 16);
                return new RGB(r, g, b);
            }
            catch (NumberFormatException e) {
                Log.error("Failed to parser: " + value + " as an integer", e);
            }
        }
        return null;
    }

    protected Bundle getAssociatedBundle(String key) {
        return this.context.bundle;
    }

    protected StyleContext getAssociatedContext(String key) {
        return this.context;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Color getColor(FormToolkit toolkit, String key) {
        RGB rgb;
        FormColors colors = toolkit.getColors();
        Color color = colors.getColor(key);
        if (color == null && (rgb = this.getRGB(key)) != null) {
            color = colors.createColor(key, rgb);
        }
        return color;
    }

    public Image getImage(String key, String defaultPageKey, String defaultKey) {
        String currentKey = key;
        String value = this.getProperty(currentKey);
        if (value == null && defaultPageKey != null) {
            currentKey = defaultPageKey;
            value = this.getProperty(defaultPageKey);
        }
        if (value != null) {
            if (ImageUtil.hasImage(currentKey)) {
                return ImageUtil.getImage(currentKey);
            }
            StyleContext ccontext = this.getAssociatedContext(currentKey);
            if (ccontext.inTheme) {
                ImageUtil.registerImage(currentKey, ccontext.path, value);
            } else {
                Bundle bundle = ccontext.bundle;
                if (bundle == null) {
                    bundle = this.context.bundle;
                }
                ImageUtil.registerImage(currentKey, bundle, value);
            }
            Image image = ImageUtil.getImage(currentKey);
            if (image != null) {
                return image;
            }
        }
        if (defaultKey != null) {
            return ImageUtil.getImage(defaultKey);
        }
        return null;
    }

    public boolean useCustomHomePagelayout() {
        String key = "home-page-custom-layout";
        String value = this.getProperty(key);
        if (value == null) {
            value = "true";
        }
        return value.equalsIgnoreCase("true");
    }

    static class StyleContext {
        IPath path;
        Bundle bundle;
        boolean inTheme;

        StyleContext() {
        }
    }
}

