/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceModel;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.internal.resource.java.source.SourceXmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlElementsAnnotation;

public class SourceXmlElementsAnnotation
extends SourceAnnotation
implements XmlElementsAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.xml.bind.annotation.XmlElements");
    private final XmlElementsAnnotationContainer xmlElementsContainer = new XmlElementsAnnotationContainer();

    public SourceXmlElementsAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement) {
        this(parent, annotatedElement, DECLARATION_ANNOTATION_ADAPTER);
    }

    public SourceXmlElementsAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, DeclarationAnnotationAdapter daa) {
        super((JavaResourceModel)parent, annotatedElement, daa);
    }

    public String getAnnotationName() {
        return "javax.xml.bind.annotation.XmlElements";
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.xmlElementsContainer.initializeFromContainerAnnotation(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.xmlElementsContainer.synchronize(astAnnotation);
    }

    @Override
    public ListIterable<XmlElementAnnotation> getXmlElements() {
        return this.xmlElementsContainer.getNestedAnnotations();
    }

    @Override
    public int getXmlElementsSize() {
        return this.xmlElementsContainer.getNestedAnnotationsSize();
    }

    @Override
    public XmlElementAnnotation xmlElementAt(int index) {
        return (XmlElementAnnotation)this.xmlElementsContainer.getNestedAnnotation(index);
    }

    @Override
    public XmlElementAnnotation addXmlElement(int index) {
        return (XmlElementAnnotation)this.xmlElementsContainer.addNestedAnnotation(index);
    }

    private XmlElementAnnotation buildXmlElement(int index) {
        return SourceXmlElementAnnotation.buildNestedSourceXmlElementAnnotation((JavaResourceModel)this, this.annotatedElement, this.buildXmlElementIndexedDeclarationAnnotationAdapter(index));
    }

    private IndexedDeclarationAnnotationAdapter buildXmlElementIndexedDeclarationAnnotationAdapter(int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(this.daa, "value", index, "javax.xml.bind.annotation.XmlElement");
    }

    @Override
    public void moveXmlElement(int targetIndex, int sourceIndex) {
        this.xmlElementsContainer.moveNestedAnnotation(targetIndex, sourceIndex);
    }

    @Override
    public void removeXmlElement(int index) {
        this.xmlElementsContainer.removeNestedAnnotation(index);
    }

    class XmlElementsAnnotationContainer
    extends SourceModel.AnnotationContainer<XmlElementAnnotation> {
        XmlElementsAnnotationContainer() {
            super((SourceModel)SourceXmlElementsAnnotation.this);
        }

        protected String getNestedAnnotationsListName() {
            return "xmlElements";
        }

        protected String getElementName() {
            return "value";
        }

        protected String getNestedAnnotationName() {
            return "javax.xml.bind.annotation.XmlElement";
        }

        protected XmlElementAnnotation buildNestedAnnotation(int index) {
            return SourceXmlElementsAnnotation.this.buildXmlElement(index);
        }
    }
}

