/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class JavadocConfigurationPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.wst.jsdt.ui.propertyPages.JavadocConfigurationPropertyPage";
    private JavadocConfigurationBlock fJavadocConfigurationBlock;
    private boolean fIsValidElement;
    private IPath fContainerPath;
    private IIncludePathEntry fEntry;
    private URL fInitalLocation;

    public void createControl(Composite parent) {
        IJavaScriptElement elem = this.getJavaElement();
        try {
            if (elem instanceof IPackageFragmentRoot && ((IPackageFragmentRoot)elem).getKind() == 2) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)elem;
                IIncludePathEntry entry = root.getRawIncludepathEntry();
                if (entry == null) {
                    this.fIsValidElement = false;
                    this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
                } else if (entry.getEntryKind() == 5) {
                    this.fContainerPath = entry.getPath();
                    this.fEntry = this.handleContainerEntry(this.fContainerPath, elem.getJavaScriptProject(), root.getPath());
                    this.fIsValidElement = this.fEntry != null;
                } else {
                    this.fContainerPath = null;
                    this.fEntry = entry;
                    this.fIsValidElement = true;
                    this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsPackageFragmentRoot_description);
                }
            } else if (elem instanceof IJavaScriptProject) {
                this.fIsValidElement = true;
                this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsJavaProject_description);
            } else {
                this.fIsValidElement = false;
                this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.fIsValidElement = false;
            this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsIncorrectElement_description);
        }
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.javadoc_configuration_property_page_context");
    }

    private IIncludePathEntry handleContainerEntry(IPath containerPath, IJavaScriptProject jproject, IPath jarPath) throws JavaScriptModelException {
        JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)containerPath.segment(0));
        IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject)jproject);
        if (initializer == null || container == null) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_invalid_container, containerPath.toString()));
            return null;
        }
        String containerName = container.getDescription();
        IStatus status = initializer.getAttributeStatus(containerPath, jproject, "javadoc_location");
        if (status.getCode() == 1) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_not_supported, containerName));
            return null;
        }
        if (status.getCode() == 2) {
            this.setDescription(Messages.format(PreferencesMessages.JavadocConfigurationPropertyPage_read_only, containerName));
            return null;
        }
        IIncludePathEntry entry = JavaModelUtil.findEntryInContainer(container, jarPath);
        Assert.isNotNull((Object)entry);
        this.setDescription(PreferencesMessages.JavadocConfigurationPropertyPage_IsPackageFragmentRoot_description);
        return entry;
    }

    protected Control createContents(Composite parent) {
        if (!this.fIsValidElement) {
            return new Composite(parent, 0);
        }
        IJavaScriptElement elem = this.getJavaElement();
        this.fInitalLocation = null;
        if (elem != null) {
            try {
                this.fInitalLocation = JavaScriptUI.getJSdocBaseLocation(elem);
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e);
            }
        }
        boolean isProject = elem instanceof IJavaScriptProject;
        this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(this.getShell(), this, this.fInitalLocation, isProject);
        Control control = this.fJavadocConfigurationBlock.createContents(parent);
        control.setVisible(elem != null);
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    private IJavaScriptElement getJavaElement() {
        IAdaptable adaptable = this.getElement();
        IJavaScriptElement elem = (IJavaScriptElement)adaptable.getAdapter(IJavaScriptElement.class);
        if (elem == null) {
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            try {
                IProject proj;
                if (resource instanceof IFile && ArchiveFileFilter.isArchivePath(resource.getFullPath()) && (proj = resource.getProject()).hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                    IJavaScriptProject jproject = JavaScriptCore.create((IProject)proj);
                    elem = jproject.getPackageFragmentRoot(resource);
                }
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
            }
        }
        return elem;
    }

    protected void performDefaults() {
        if (this.fJavadocConfigurationBlock != null) {
            this.fJavadocConfigurationBlock.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fJavadocConfigurationBlock != null) {
            URL javadocLocation = this.fJavadocConfigurationBlock.getJavadocLocation();
            if (javadocLocation == null && this.fInitalLocation == null || javadocLocation != null && this.fInitalLocation != null && javadocLocation.toString().equals(this.fInitalLocation.toString())) {
                return true;
            }
            IJavaScriptElement elem = this.getJavaElement();
            try {
                IRunnableWithProgress runnable = JavadocConfigurationPropertyPage.getRunnable(this.getShell(), elem, javadocLocation, this.fEntry, this.fContainerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = PreferencesMessages.SourceAttachmentPropertyPage_error_title;
                String message = PreferencesMessages.SourceAttachmentPropertyPage_error_message;
                ExceptionHandler.handle(e, this.getShell(), title, message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    private static IRunnableWithProgress getRunnable(final Shell shell, final IJavaScriptElement elem, final URL javadocLocation, final IIncludePathEntry entry, final IPath containerPath) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IJavaScriptProject project = elem.getJavaScriptProject();
                    if (elem instanceof IPackageFragmentRoot) {
                        CPListElement cpElem = CPListElement.createFromExisting(entry, project);
                        String loc = javadocLocation != null ? javadocLocation.toExternalForm() : null;
                        cpElem.setAttribute("javadoc_location", loc);
                        IIncludePathEntry newEntry = cpElem.getClasspathEntry();
                        String[] changedAttributes = new String[]{"javadoc_location"};
                        BuildPathSupport.modifyClasspathEntry(shell, newEntry, changedAttributes, project, containerPath, monitor);
                    } else {
                        JavaScriptUI.setProjectJSdocLocation(project, javadocLocation);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    @Override
    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

