/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;

public final class FacetedProjectPropertyTester
extends PropertyTester {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object value) {
        try {
            String vexpr;
            String fid;
            String val = (String)value;
            int colon = val.indexOf(58);
            if (colon == -1 || colon == val.length() - 1) {
                fid = val;
                vexpr = null;
            } else {
                fid = val.substring(0, colon);
                vexpr = val.substring(colon + 1);
            }
            if (receiver instanceof IResource) {
                IProject pj = ((IResource)receiver).getProject();
                if (pj != null) return FacetedProjectFramework.hasProjectFacet(pj, fid, vexpr);
                return false;
            }
            if (!(receiver instanceof IProjectFacetVersion)) return false;
            IProjectFacetVersion fv = (IProjectFacetVersion)receiver;
            IProjectFacet f = fv.getProjectFacet();
            if (!f.getId().equals(fid)) return false;
            if (vexpr == null) return true;
            if (!f.getVersions(vexpr).contains(fv)) return false;
            return true;
        }
        catch (CoreException e) {
            FacetCorePlugin.log(e.getStatus());
        }
        return false;
    }
}

