/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionReader {
    private static final Logger log = LoggerFactory.getLogger(ExtensionReader.class);
    public static final String EXTENSION_ARCHETYPES = "org.eclipse.m2e.core.archetypeCatalogs";
    public static final String EXTENSION_PROJECT_CHANGED_EVENT_LISTENERS = "org.eclipse.m2e.core.mavenProjectChangedListeners";
    public static final String EXTENSION_INCREMENTAL_BUILD_FRAMEWORKS = "org.eclipse.m2e.core.incrementalBuildFrameworks";
    private static final String ELEMENT_LISTENER = "listener";

    public static List<IMavenProjectChangedListener> readProjectChangedEventListenerExtentions() {
        ArrayList<IMavenProjectChangedListener> listeners = new ArrayList<IMavenProjectChangedListener>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint mappingsExtensionPoint = registry.getExtensionPoint(EXTENSION_PROJECT_CHANGED_EVENT_LISTENERS);
        if (mappingsExtensionPoint != null) {
            IExtension[] mappingsExtensions;
            IExtension[] iExtensionArray = mappingsExtensions = mappingsExtensionPoint.getExtensions();
            int n = mappingsExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (ELEMENT_LISTENER.equals(element.getName())) {
                        try {
                            listeners.add((IMavenProjectChangedListener)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return listeners;
    }

    public static List<IIncrementalBuildFramework> readIncrementalBuildFrameworks() {
        ArrayList<IIncrementalBuildFramework> frameworks = new ArrayList<IIncrementalBuildFramework>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint mappingsExtensionPoint = registry.getExtensionPoint(EXTENSION_INCREMENTAL_BUILD_FRAMEWORKS);
        if (mappingsExtensionPoint != null) {
            IExtension[] mappingsExtensions;
            IExtension[] iExtensionArray = mappingsExtensions = mappingsExtensionPoint.getExtensions();
            int n = mappingsExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if ("framework".equals(element.getName())) {
                        try {
                            frameworks.add((IIncrementalBuildFramework)element.createExecutableExtension("class"));
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return frameworks;
    }
}

