/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.search2.internal.ui.text.PositionTracker;

public class AnnotationHighlighter
extends Highlighter {
    private final IAnnotationModel fModel;
    private final IDocument fDocument;
    private final Map<Match, Annotation> fMatchesToAnnotations;

    public AnnotationHighlighter(IAnnotationModel model, IDocument document) {
        this.fModel = model;
        this.fDocument = document;
        this.fMatchesToAnnotations = new HashMap<Match, Annotation>();
    }

    @Override
    public void addHighlights(Match[] matches) {
        HashMap<Annotation, Position> map = new HashMap<Annotation, Position>(matches.length);
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Position position;
            Match match = matchArray[n2];
            int offset = match.getOffset();
            int length = match.getLength();
            if (offset >= 0 && length >= 0 && (position = this.createPosition(match)) != null) {
                Annotation annotation = match.isFiltered() ? new Annotation("org.eclipse.search.filteredResults", true, null) : new Annotation("org.eclipse.search.results", true, null);
                this.fMatchesToAnnotations.put(match, annotation);
                map.put(annotation, position);
            }
            ++n2;
        }
        this.addAnnotations(map);
    }

    private Position createPosition(Match match) {
        Position position = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
        position = position == null ? new Position(match.getOffset(), match.getLength()) : new Position(position.getOffset(), position.getLength());
        if (match.getBaseUnit() == 1) {
            if (this.fDocument != null) {
                try {
                    position = PositionTracker.convertToCharacterPosition(position, this.fDocument);
                }
                catch (BadLocationException e) {
                    return null;
                }
            } else {
                SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.AnnotationHighlighter_error_noDocument, null));
                return null;
            }
        }
        return position;
    }

    @Override
    public void removeHighlights(Match[] matches) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(matches.length);
        Match[] matchArray = matches;
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            Annotation annotation = this.fMatchesToAnnotations.remove(match);
            if (annotation != null) {
                annotations.add(annotation);
            }
            ++n2;
        }
        this.removeAnnotations(annotations);
    }

    @Override
    public void removeAll() {
        Collection<Annotation> matchSet = this.fMatchesToAnnotations.values();
        this.removeAnnotations(matchSet);
        this.fMatchesToAnnotations.clear();
    }

    private void addAnnotations(Map<Annotation, Position> annotationToPositionMap) {
        IAnnotationModel iAnnotationModel = this.fModel;
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)iAnnotationModel;
            ame.replaceAnnotations(new Annotation[0], annotationToPositionMap);
        } else {
            Set<Map.Entry<Annotation, Position>> entrySet = annotationToPositionMap.entrySet();
            for (Map.Entry<Annotation, Position> entry : entrySet) {
                this.fModel.addAnnotation(entry.getKey(), entry.getValue());
            }
        }
    }

    private void removeAnnotations(Collection<Annotation> annotations) {
        IAnnotationModel iAnnotationModel = this.fModel;
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)iAnnotationModel;
            Annotation[] annotationArray = new Annotation[annotations.size()];
            ame.replaceAnnotations(annotations.toArray(annotationArray), Collections.emptyMap());
        } else {
            for (Annotation element : annotations) {
                this.fModel.removeAnnotation(element);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleContentReplaced(IFileBuffer buffer) {
        void textBuffer;
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        ITextFileBuffer iTextFileBuffer = (ITextFileBuffer)buffer;
        if (this.fDocument != null && this.fDocument.equals(textBuffer.getDocument())) {
            Set<Match> allMatches = this.fMatchesToAnnotations.keySet();
            Match[] matchesCopy = allMatches.toArray(new Match[allMatches.size()]);
            this.removeAll();
            this.addHighlights(matchesCopy);
        }
    }
}

