/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.graph.Traverser;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.TestRunConfiguration;
import org.eclipse.buildship.core.internal.launch.RunGradleTestLaunchRequestJob;
import org.eclipse.buildship.ui.internal.PluginImage;
import org.eclipse.buildship.ui.internal.PluginImages;
import org.eclipse.buildship.ui.internal.i18n.UiMessages;
import org.eclipse.buildship.ui.internal.util.gradle.GradleUtils;
import org.eclipse.buildship.ui.internal.util.widget.FilteredTree;
import org.eclipse.buildship.ui.internal.view.execution.ExecutionPage;
import org.eclipse.buildship.ui.internal.view.execution.OperationItem;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.gradle.tooling.events.test.JvmTestKind;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestFailureResult;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class RerunFailedTestsAction
extends Action {
    private final ExecutionPage page;

    public RerunFailedTestsAction(ExecutionPage executionPage) {
        this.page = (ExecutionPage)Preconditions.checkNotNull((Object)executionPage);
        this.setToolTipText(UiMessages.Action_RerunFailedTests_Tooltip);
        this.setImageDescriptor(PluginImages.RERUN_FAILED_TESTS.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.RERUN_FAILED_TESTS.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
    }

    private void registerJobChangeListener() {
        Job job = this.page.getProcessDescription().getJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                RerunFailedTestsAction.this.update();
            }
        });
        this.update();
    }

    private void update() {
        this.setEnabled(this.page.getProcessDescription().getJob().getState() == 0 && !this.collectFailedTests().isEmpty());
    }

    public void run() {
        ImmutableList<TestOperationDescriptor> failedTests = this.collectFailedTests();
        List<TestOperationDescriptor> filteredFailedTests = GradleUtils.filterChildren(failedTests);
        TestRunConfiguration runConfig = CorePlugin.configurationManager().loadTestRunConfiguration(this.page.getProcessDescription().getRunConfig());
        RunGradleTestLaunchRequestJob job = new RunGradleTestLaunchRequestJob(filteredFailedTests, runConfig);
        job.schedule();
    }

    private ImmutableList<TestOperationDescriptor> collectFailedTests() {
        OperationItem root = (OperationItem)((FilteredTree)((Object)this.page.getPageControl())).getViewer().getInput();
        if (root == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (OperationItem item : Traverser.forTree(OperationItem::getChildren).breadthFirst((Object)root)) {
            if (!this.isFailedJvmTest(item)) continue;
            result.add((Object)((JvmTestOperationDescriptor)item.getFinishEvent().getDescriptor()));
        }
        return result.build();
    }

    private boolean isFailedJvmTest(OperationItem operationItem) {
        JvmTestOperationDescriptor descriptor;
        TestFinishEvent testFinishEvent;
        return operationItem.getFinishEvent() instanceof TestFinishEvent && (testFinishEvent = (TestFinishEvent)operationItem.getFinishEvent()).getResult() instanceof TestFailureResult && testFinishEvent.getDescriptor() instanceof JvmTestOperationDescriptor && ((descriptor = (JvmTestOperationDescriptor)testFinishEvent.getDescriptor()).getJvmTestKind() == JvmTestKind.ATOMIC || descriptor.getJvmTestKind() == JvmTestKind.UNKNOWN);
    }
}

